/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.rse.services.clientserver.IServiceConstants;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessComparator;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalServerProcessImpl;

public class UniversalLinuxProcessHandler
implements ProcessHandler,
IServiceConstants,
ISystemProcessRemoteConstants {
    protected HashMap _usernamesByUid;
    protected HashMap _uidsByUserName;
    private HashMap stateMap = new HashMap();

    public UniversalLinuxProcessHandler() {
        int i = 0;
        while (i < 9) {
            this.stateMap.put(new Character(ALL_STATES[i]), ALL_STATES_STR[i]);
            ++i;
        }
    }

    public IHostProcess kill(IHostProcess process, String type) throws Exception {
        type = type.equals("default") ? "" : "-" + type;
        String cmdLine = "kill " + type + " " + process.getPid();
        Runtime.getRuntime().exec(cmdLine);
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid("" + process.getPid());
        SortedSet results = this.lookupProcesses(rpfs);
        if (results == null || results.size() == 0) {
            return null;
        }
        return (IHostProcess)results.first();
    }

    public SortedSet lookupProcesses(IHostProcessFilter rpfs) throws Exception {
        File procDir = new File("/proc");
        if (!procDir.exists()) {
            throw new Exception("failed with does not exist");
        }
        if (!procDir.canRead()) {
            throw new Exception("failed with security");
        }
        File[] processes = rpfs.getPid().indexOf("*") == -1 ? new File[]{new File(procDir, rpfs.getPid())} : procDir.listFiles();
        TreeSet<UniversalServerProcessImpl> results = new TreeSet<UniversalServerProcessImpl>(new ProcessComparator());
        int i = 0;
        while (i < processes.length) {
            block18: {
                try {
                    Integer.valueOf(processes[i].getName());
                }
                catch (NumberFormatException numberFormatException) {
                    break block18;
                }
                String statusLine = "";
                try {
                    BufferedReader reader;
                    FileReader fr;
                    File statusFile = new File(processes[i], "status");
                    if (!statusFile.exists() || !statusFile.canRead() || (fr = new FileReader(statusFile)) == null || (reader = new BufferedReader(fr)) == null) break block18;
                    HashMap statusFileContents = this.getStatusFileContents(reader);
                    statusLine = String.valueOf(processes[i].getName()) + "|";
                    String name = (String)statusFileContents.get("name");
                    if (name == null) {
                        name = " ";
                    }
                    statusLine = String.valueOf(statusLine) + name + "|";
                    String state = (String)statusFileContents.get("state");
                    if (state == null) {
                        state = " ";
                    }
                    String stateCode = this.convertToStateCode(state);
                    statusLine = String.valueOf(statusLine) + stateCode + "|";
                    String tgid = (String)statusFileContents.get("tgid");
                    if (tgid == null) {
                        tgid = " ";
                    }
                    statusLine = String.valueOf(statusLine) + tgid + "|";
                    String pPid = (String)statusFileContents.get("ppid");
                    if (pPid == null) {
                        pPid = " ";
                    }
                    statusLine = String.valueOf(statusLine) + pPid + "|";
                    String tracerpid = (String)statusFileContents.get("tracerpid");
                    if (tracerpid == null) {
                        tracerpid = " ";
                    }
                    statusLine = String.valueOf(statusLine) + tracerpid + "|";
                    String uid = (String)statusFileContents.get("uid");
                    if (uid == null) {
                        uid = " ";
                    }
                    statusLine = String.valueOf(statusLine) + uid + "|";
                    String username = this.getUsername(uid);
                    if (username == null) {
                        username = " ";
                    }
                    statusLine = String.valueOf(statusLine) + username + "|";
                    String gid = (String)statusFileContents.get("gid");
                    if (gid == null) {
                        gid = " ";
                    }
                    statusLine = String.valueOf(statusLine) + gid + "|";
                    String vmsize = (String)statusFileContents.get("vmsize");
                    if (vmsize == null) {
                        vmsize = " ";
                    }
                    statusLine = String.valueOf(statusLine) + vmsize + "|";
                    String vmrss = (String)statusFileContents.get("vmrss");
                    if (vmrss == null) {
                        vmrss = " ";
                    }
                    statusLine = String.valueOf(statusLine) + vmrss;
                    reader.close();
                    fr.close();
                }
                catch (Exception exception) {
                    break block18;
                }
                if (rpfs.allows(statusLine)) {
                    UniversalServerProcessImpl usp = new UniversalServerProcessImpl(statusLine);
                    results.add(usp);
                }
            }
            ++i;
        }
        return results;
    }

    public String getUid(String username) {
        if (this._uidsByUserName == null) {
            this.populateUsernames();
        }
        return (String)this._uidsByUserName.get(username);
    }

    public String getUsername(String uid) {
        if (this._usernamesByUid == null) {
            this.populateUsernames();
        }
        return (String)this._usernamesByUid.get(uid);
    }

    private HashMap getStatusFileContents(BufferedReader reader) {
        HashMap<String, String> contents = new HashMap<String, String>();
        try {
            String nextLine;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine != null) {
                    String key = nextLine.substring(0, nextLine.indexOf(":")).trim().toLowerCase();
                    String theRest = this.processStatusLine(nextLine, -1);
                    StringTokenizer tz = new StringTokenizer(theRest);
                    String value = null;
                    if (tz.hasMoreTokens()) {
                        value = tz.nextToken();
                    }
                    if (key == null || value == null) continue;
                    contents.put(key, value);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return contents;
    }

    private String processStatusLine(String line, int length) {
        if (length == -1) {
            return line.substring(line.indexOf(":") + 1).trim();
        }
        return line.substring(line.indexOf(":") + 1).trim().substring(0, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateUsernames() {
        this._usernamesByUid = new HashMap();
        this._uidsByUserName = new HashMap();
        try {
            Process ps = Runtime.getRuntime().exec("getent passwd");
            InputStreamReader isr = new InputStreamReader(ps.getInputStream());
            if (isr == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(isr);
            if (reader == null) {
                return;
            }
            while (true) {
                String nextLine;
                if ((nextLine = reader.readLine()) == null) {
                    reader.close();
                    isr.close();
                    return;
                }
                String[] fields = nextLine.split(":");
                int length = fields.length;
                if (length < 3) continue;
                String uid = fields[2];
                String username = fields[0];
                if (uid == null || username == null) continue;
                this._usernamesByUid.put(uid, username);
                this._uidsByUserName.put(username, uid);
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected String convertToStateCode(String state) {
        String stateCode = " ";
        if (state == null) {
            return stateCode;
        }
        if (state.trim().equals("")) {
            return stateCode;
        }
        int i = 0;
        while (i < state.length()) {
            String nextState = (String)this.stateMap.get(new Character(state.charAt(i)));
            if (nextState != null) {
                stateCode = String.valueOf(stateCode) + nextState;
                if (i < state.length() - 1) {
                    stateCode = String.valueOf(stateCode) + ",";
                }
            }
            ++i;
        }
        if (stateCode.trim().equals("")) {
            return " ";
        }
        return stateCode.trim();
    }
}

