/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.subsystem;

import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.dstore.search.DStoreSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResult;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.OutputRefresh;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.subsystems.files.dstore.model.DStoreSearchResult;
import org.eclipse.swt.widgets.Display;

public class DStoreFileSubSystemSearchResultConfiguration
extends DStoreSearchResultConfiguration {
    private FileServiceSubSystem _fileSubSystem;
    private IRemoteFile _searchObject;

    public DStoreFileSubSystemSearchResultConfiguration(IHostSearchResultSet set, Object searchObject, SystemSearchString searchString, ISearchService searchService, IHostFileToRemoteFileAdapter fileAdapter) {
        super(set, searchObject, searchString, searchService);
        this._searchObject = (IRemoteFile)searchObject;
        this._fileSubSystem = (FileServiceSubSystem)this._searchObject.getParentRemoteFileSubSystem();
    }

    public int getResultsSize() {
        DataElement status = this.getStatusObject();
        if (status != null) {
            return this.getStatusObject().getNestedSize();
        }
        return 0;
    }

    public Object[] getResults() {
        List results = this.getStatusObject().getNestedData();
        if (results != null) {
            Object[] convertedResults = new IRemoteFile[results.size()];
            int i = 0;
            while (i < results.size()) {
                DataElement fileNode = (DataElement)results.get(i);
                if (fileNode != null) {
                    IRemoteFile parentRemoteFile = null;
                    try {
                        parentRemoteFile = this._fileSubSystem.getRemoteFileObject(fileNode.getValue());
                        if (!parentRemoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance())) {
                            this._fileSubSystem.listFiles(parentRemoteFile, null);
                        }
                        String path = String.valueOf(fileNode.getValue()) + "/" + fileNode.getName();
                        IRemoteFile remoteFile = this._fileSubSystem.getRemoteFileObject(path);
                        List contained = fileNode.getNestedData();
                        if (contained != null) {
                            Object[] searchResults = new IHostSearchResult[contained.size()];
                            int c = 0;
                            while (c < contained.size()) {
                                searchResults[c] = new DStoreSearchResult((IHostSearchResultConfiguration)this, remoteFile, (DataElement)contained.get(c), this.getSearchString());
                                ++c;
                            }
                            remoteFile.setContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), this.getSearchString().getTextString(), searchResults);
                        }
                        convertedResults[i] = remoteFile;
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            return convertedResults;
        }
        return new IRemoteFile[0];
    }

    public Object getSearchTarget() {
        try {
            return this._fileSubSystem.getFileService().getFile(null, this._searchObject.getParentPath(), this._searchObject.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void domainChanged(DomainEvent e) {
        if (this._status.getValue().equals("done")) {
            this.setStatus(1);
            this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
        }
        OutputRefresh refresh = new OutputRefresh((IHostSearchResultConfiguration)this);
        Display.getDefault().asyncExec((Runnable)refresh);
    }
}

