/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteSystemEnvVar;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteSystemEnvVar;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class RemoteCmdSubSystem
extends SubSystem
implements IRemoteCmdSubSystem,
ICommunicationsListener {
    public static String COMMAND_SHELLS_MEMENTO = "commandshells";
    protected List envVars = null;
    protected List _envVars;
    protected ArrayList _cmdShells = new ArrayList();
    protected IRemoteCommandShell _defaultShell;
    protected IRemoteFileSubSystem _fileSubSystem;

    public RemoteCmdSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public IRemoteCmdSubSystemConfiguration getParentRemoteCmdSubSystemConfiguration() {
        return (IRemoteCmdSubSystemConfiguration)super.getSubSystemConfiguration();
    }

    public String getShellEncoding() {
        IPropertySet set = this.getPropertySet("Remote");
        if (set != null) {
            return set.getPropertyValue("shell.encoding");
        }
        return null;
    }

    public void setShellEncoding(String encoding) {
        IPropertySet set = this.getPropertySet("Remote");
        if (set == null) {
            set = this.createPropertySet("Remote", this.getDescription());
        }
        set.addProperty("shell.encoding", encoding);
        this.setDirty(true);
        this.commit();
    }

    public boolean checkForCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException(RSEUIPlugin.getPluginMessage((String)"RSEG1067").getLevelOneText());
        }
        return false;
    }

    public IRemoteSystemEnvVar[] getEnvironmentVariableList() {
        List initEVL = this.getEnvVars();
        IRemoteSystemEnvVar[] envl = new IRemoteSystemEnvVar[initEVL.size()];
        Iterator i = initEVL.iterator();
        int idx = 0;
        while (i.hasNext()) {
            envl[idx++] = (IRemoteSystemEnvVar)i.next();
        }
        return envl;
    }

    public void setEnvironmentVariableList(String[] envVarNames, String[] envVarValues) {
        List initEVL = this.getEnvVars();
        initEVL.clear();
        if (envVarNames != null) {
            RemoteSystemEnvVar rsev = null;
            int idx = 0;
            while (idx < envVarNames.length) {
                rsev = new RemoteSystemEnvVar();
                rsev.setName(envVarNames[idx]);
                rsev.setValue(envVarValues[idx]);
                initEVL.add(rsev);
                ++idx;
            }
        }
        try {
            if (this.getSubSystemConfiguration() != null) {
                this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error saving command subsystem after setting env var entries", (Throwable)exc);
        }
    }

    public void addEnvironmentVariable(String name, String value) {
        RemoteSystemEnvVar rsev = new RemoteSystemEnvVar();
        rsev.setName(name);
        rsev.setValue(value);
        this.addEnvironmentVariable(rsev);
    }

    public void addEnvironmentVariable(IRemoteSystemEnvVar rsev) {
        this.getEnvVars().add(rsev);
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error saving command subsystem after adding env var entry", (Throwable)exc);
        }
    }

    public void removeEnvironmentVariable(IRemoteSystemEnvVar rsev) {
        this.getEnvVars().remove(rsev);
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error saving command subsystem after removing env var entry", (Throwable)exc);
        }
    }

    public void removeEnvironmentVariable(String name) {
        IRemoteSystemEnvVar rsev = this.getEnvironmentVariable(name);
        if (rsev != null) {
            this.removeEnvironmentVariable(rsev);
        }
    }

    public IRemoteSystemEnvVar getEnvironmentVariable(String name) {
        List envVarList = this.getEnvVars();
        IRemoteSystemEnvVar match = null;
        Iterator i = envVarList.iterator();
        while (match == null && i.hasNext()) {
            IRemoteSystemEnvVar rsev = (IRemoteSystemEnvVar)i.next();
            if (!rsev.getName().equals(name)) continue;
            match = rsev;
        }
        return match;
    }

    public String getEnvironmentVariableValue(String name) {
        IRemoteSystemEnvVar match = this.getEnvironmentVariable(name);
        if (match != null) {
            return match.getValue();
        }
        return null;
    }

    protected String[] getEnvVarsAsStringArray() {
        String[] envVars = null;
        IRemoteSystemEnvVar[] list = this.getEnvironmentVariableList();
        if (list != null && list.length > 0) {
            envVars = new String[list.length];
            int i = 0;
            while (i < list.length) {
                String name = list[i].getName();
                if (this.isWindows()) {
                    name = name.toUpperCase();
                }
                envVars[i] = String.valueOf(name) + "=" + list[i].getValue();
                ++i;
            }
        }
        return envVars;
    }

    protected boolean isUniqueVariable(List variables, String varName) {
        int i = 0;
        while (i < variables.size()) {
            String variableStr = (String)variables.get(i);
            if (variableStr.startsWith(varName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String[] getUserAndHostEnvVarsAsStringArray() {
        int assignIndex;
        String varName;
        String[] userVars = this.getEnvVarsAsStringArray();
        List systemVars = this.getHostEnvironmentVariables();
        ArrayList<String> combinedVars = new ArrayList<String>();
        if (userVars != null) {
            int i = userVars.length - 1;
            while (i >= 0) {
                String userVar = userVars[i];
                varName = null;
                assignIndex = userVar.indexOf(61);
                if (assignIndex > 0 && this.isUniqueVariable(combinedVars, varName = userVar.substring(0, assignIndex + 1))) {
                    combinedVars.add(userVar);
                }
                --i;
            }
        }
        int s = 0;
        while (s < systemVars.size()) {
            String systemVar = (String)systemVars.get(s);
            varName = null;
            assignIndex = systemVar.indexOf(61);
            if (assignIndex > 0 && this.isUniqueVariable(combinedVars, varName = systemVar.substring(0, assignIndex + 1))) {
                combinedVars.add(systemVar);
            }
            ++s;
        }
        String[] result = new String[combinedVars.size()];
        int a = 0;
        while (a < combinedVars.size()) {
            result[a] = (String)combinedVars.get(a);
            ++a;
        }
        return result;
    }

    public boolean isWindows() {
        String type = this.getSystemType();
        return type.equals("Windows") || type.equals("Local") && System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public ICandidateCommand[] getCandidateCommands(Object context) {
        if (context instanceof IRemoteCommandShell) {
            IRemoteCommandShell command = (IRemoteCommandShell)context;
            return command.getCandidateCommands();
        }
        return null;
    }

    protected List parsePathEnvironmentVariable(String path) {
        ArrayList<String> addedPaths = new ArrayList<String>();
        ArrayList<IRemoteFile> addedFolders = new ArrayList<IRemoteFile>();
        char separator = this.isWindows() ? (char)';' : ':';
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf(separator));
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (addedPaths.contains(token)) continue;
            addedPaths.add(token);
            IRemoteFileSubSystem fs = this.getFileSubSystem();
            try {
                IRemoteFile file = fs.getRemoteFileObject(token);
                addedFolders.add(file);
            }
            catch (Exception exception) {}
        }
        return addedFolders;
    }

    public IRemoteFileSubSystem getFileSubSystem() {
        if (this._fileSubSystem == null) {
            this._fileSubSystem = RemoteFileUtility.getFileSubSystem((IHost)this.getHost());
        }
        return this._fileSubSystem;
    }

    public String getInvalidEnvironmentVariableNameCharacters() {
        return "=";
    }

    public IRemoteCmdSubSystem getCommandSubSystem() {
        return this;
    }

    protected Object[] internalResolveFilterString(IProgressMonitor monitor, String filterString) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public Object[] getChildren() {
        return this.getShells();
    }

    public boolean hasChildren() {
        if (this._cmdShells == null) {
            return false;
        }
        return this._cmdShells.size() > 0;
    }

    public IRemoteCommandShell getDefaultShell() throws Exception {
        IRemoteCommandShell[] shells = this.getShells();
        if (shells == null || shells.length == 0) {
            return this.runShell(null);
        }
        return shells[0];
    }

    public IRemoteCommandShell[] getShells() {
        IRemoteCommandShell[] shells = new IRemoteCommandShell[this._cmdShells.size()];
        int i = 0;
        while (i < this._cmdShells.size()) {
            shells[i] = (IRemoteCommandShell)this._cmdShells.get(i);
            ++i;
        }
        return shells;
    }

    public boolean canRunShell() {
        return true;
    }

    public boolean canRunCommand() {
        return true;
    }

    public Object getObjectWithAbsoluteName(String key) throws Exception {
        String cmdKey = key;
        String outKey = null;
        int indexOfColon = key.indexOf(58);
        if (indexOfColon > 0) {
            cmdKey = key.substring(0, indexOfColon);
            outKey = key.substring(indexOfColon + 1, key.length());
        }
        IRemoteCommandShell theCmd = null;
        IRemoteCommandShell[] cmds = this.getShells();
        int i = 0;
        while (i < cmds.length && theCmd == null) {
            IRemoteCommandShell cmd = cmds[i];
            if (cmd != null && cmd.getId().equals(cmdKey)) {
                theCmd = cmd;
            }
            ++i;
        }
        if (theCmd != null && outKey != null) {
            int outIndex = Integer.parseInt(outKey);
            return theCmd.getOutputAt(outIndex);
        }
        return theCmd;
    }

    protected void saveShellState(List cmdShells) {
        StringBuffer shellBuffer = new StringBuffer();
        boolean gotShell = false;
        int i = 0;
        while (i < cmdShells.size() && !gotShell) {
            IRemoteCommandShell cmd = (IRemoteCommandShell)cmdShells.get(i);
            if (cmd.isActive()) {
                Object context = cmd.getContext();
                if (context instanceof IRemoteFile) {
                    IRemoteFile pwdf = (IRemoteFile)context;
                    String pwd = pwdf.getAbsolutePath();
                    shellBuffer.append(pwd);
                    gotShell = true;
                } else {
                    shellBuffer.append(cmd.getType());
                    gotShell = true;
                }
            }
            ++i;
        }
        this.setRemoteAttribute(COMMAND_SHELLS_MEMENTO, shellBuffer.toString());
    }

    protected void internalRemoveShell(Object command) throws InvocationTargetException, InterruptedException {
        if (command instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)command;
            if (cmdShell.isActive()) {
                this.internalCancelShell(null, command);
            }
            if (this._defaultShell == command) {
                this._defaultShell = null;
            }
            this._cmdShells.remove(command);
            Display.getDefault().asyncExec((Runnable)new RefreshRemovedShell(this, cmdShell));
        }
    }

    public IRemoteCommandShell[] restoreShellState(Shell shellWindow) {
        this.shell = shellWindow;
        IRemoteCommandShell[] results = null;
        String shellStr = this.getRemoteAttribute(COMMAND_SHELLS_MEMENTO);
        int numShells = 0;
        if (shellStr != null && shellStr.length() > 0) {
            StringTokenizer tok = new StringTokenizer(shellStr, "|");
            results = new IRemoteCommandShell[tok.countTokens()];
            while (tok.hasMoreTokens()) {
                String context = tok.nextToken();
                if (context == null || context.length() <= 0) continue;
                try {
                    IRemoteCommandShell rmtCmd;
                    results[numShells] = rmtCmd = this.internalRunShell(null, context);
                    ++numShells;
                }
                catch (Exception exception) {}
            }
        }
        Display.getDefault().asyncExec((Runnable)new Refresh(this));
        return results;
    }

    public void cancelAllShells() {
        int i = this._cmdShells.size() - 1;
        while (i >= 0) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)this._cmdShells.get(i);
            try {
                this.internalRemoveShell(cmdShell);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            --i;
        }
        this._cmdShells.clear();
        this._defaultShell = null;
        Display.getDefault().asyncExec((Runnable)new Refresh(this));
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 4: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 3: 
            case 5: {
                this.saveShellState(this._cmdShells);
                if (this.getShells().length <= 0) break;
                Display.getDefault().asyncExec((Runnable)new CancelAllShells());
                break;
            }
        }
    }

    public List getEnvVars() {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        return this.envVars;
    }

    public Object[] runCommand(String command, Object context, boolean interpretOutput) throws Exception {
        if (this.isConnected()) {
            return this.internalRunCommand(null, command, context, interpretOutput);
        }
        try {
            RunCommandJob job = new RunCommandJob(command, context, interpretOutput);
            IStatus status = this.scheduleJob(job, null, true);
            if (status.isOK()) {
                return job.getOutputs();
            }
        }
        catch (InterruptedException exc) {
            if (this.shell == null) {
                throw exc;
            }
            this.showOperationCancelledMessage(this.shell);
        }
        return null;
    }

    public IRemoteCommandShell runShell(Object context) throws Exception {
        IRemoteCommandShell cmdShell = null;
        if (this.isConnected()) {
            cmdShell = this.internalRunShell(null, context);
        } else {
            try {
                RunShellJob job = new RunShellJob(context);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    return (IRemoteCommandShell)job.getOutputs()[0];
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        }
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, (Object)this));
        return cmdShell;
    }

    public Object[] runCommand(String command, Object context) throws Exception {
        return this.runCommand(command, context, true);
    }

    public void sendCommandToShell(String input, Object commandObject) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Display display = Display.getCurrent();
            if (display != null) {
                this.internalSendCommandToShell((IProgressMonitor)new NullProgressMonitor(), input, commandObject);
            } else {
                try {
                    SendCommandToShellJob job = new SendCommandToShellJob(input, commandObject);
                    IStatus status = this.scheduleJob(job, null, true);
                    if (status.isOK()) {
                        return;
                    }
                }
                catch (InterruptedException exc) {
                    if (this.shell == null) {
                        throw exc;
                    }
                    this.showOperationCancelledMessage(this.shell);
                }
            }
        } else {
            SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.sendCommandToShell: isConnected() returning false!");
        }
    }

    public void cancelShell(Object commandObject) throws Exception {
        if (this.isConnected()) {
            this.internalCancelShell(null, commandObject);
        } else {
            boolean ok = true;
            if (!this.isConnected()) {
                ok = this.promptForPassword();
            }
            if (ok) {
                try {
                    CancelShellJob job = new CancelShellJob(commandObject);
                    this.scheduleJob(job, null, false);
                }
                catch (InterruptedException exc) {
                    if (this.shell == null) {
                        throw exc;
                    }
                    this.showOperationCancelledMessage(this.shell);
                }
            } else {
                SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.cancelShell: isConnected() returning false!");
            }
        }
    }

    public void removeShell(Object commandObject) throws Exception {
        if (this.isConnected()) {
            this.internalRemoveShell(commandObject);
        } else {
            boolean ok = true;
            if (!this.isConnected()) {
                ok = this.promptForPassword();
            }
            if (ok) {
                try {
                    RemoveShellJob job = new RemoveShellJob(commandObject);
                    this.scheduleJob(job, null, false);
                }
                catch (InterruptedException exc) {
                    if (this.shell == null) {
                        throw exc;
                    }
                    this.showOperationCancelledMessage(this.shell);
                }
            } else {
                SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.removeShell: isConnected() returning false!");
            }
        }
    }

    protected Object[] internalRunCommand(IProgressMonitor monitor, String cmd, Object context) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected Object[] internalRunCommand(IProgressMonitor monitor, String cmd, Object context, boolean interpretOutput) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected IRemoteCommandShell internalRunShell(IProgressMonitor monitor, Object context) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected void internalCancelShell(IProgressMonitor monitor, Object command) throws InvocationTargetException, InterruptedException {
    }

    protected void internalSendCommandToShell(IProgressMonitor monitor, String cmd, Object command) throws InvocationTargetException, InterruptedException {
    }

    static /* synthetic */ String access$0(String string) {
        return SubSystem.getRunningMessage((String)string);
    }

    public class Refresh
    implements Runnable {
        private RemoteCmdSubSystem _ss;

        public Refresh(RemoteCmdSubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 82, (Object)this._ss));
        }
    }

    public class RefreshRemovedShell
    implements Runnable {
        private RemoteCmdSubSystem _ss;
        private IRemoteCommandShell _cmdShell;

        public RefreshRemovedShell(RemoteCmdSubSystem ss, IRemoteCommandShell cmdShell) {
            this._ss = ss;
            this._cmdShell = cmdShell;
        }

        public void run() {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._cmdShell, 141, null));
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 82, (Object)this._ss));
        }
    }

    private class CancelAllShells
    implements Runnable {
        private CancelAllShells() {
        }

        public void run() {
            RemoteCmdSubSystem.this.cancelAllShells();
        }
    }

    public class RefreshSubSystem
    implements Runnable {
        RemoteCmdSubSystem _ss;

        public RefreshSubSystem(RemoteCmdSubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            RSEUIPlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 141, (Object)this._ss));
        }
    }

    protected class RunCommandJob
    extends SubSystem.SubSystemOperationJob {
        protected String _cmd;
        protected Object _runContext;
        protected boolean _runInterpret;

        public RunCommandJob(String cmd, Object runContext, boolean runInterpret) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Run_command_message);
            this._cmd = cmd;
            this._runContext = runContext;
            this._runInterpret = runInterpret;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = RemoteCmdSubSystem.access$0(this._cmd);
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage((String)"RSEG1056").makeSubstitution((Object)RemoteCmdSubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = RemoteCmdSubSystem.this.internalRunCommand(mon, this._cmd, this._runContext, this._runInterpret);
        }
    }

    protected class RunShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public RunShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Run_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage((String)"RSEG1056").makeSubstitution((Object)RemoteCmdSubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = new Object[]{RemoteCmdSubSystem.this.internalRunShell(mon, this._runContext)};
        }
    }

    protected class CancelShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public CancelShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Cancel_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage((String)"RSEG1056").makeSubstitution((Object)RemoteCmdSubSystem.this.getHostName()).getLevelOneText());
            }
            RemoteCmdSubSystem.this.internalCancelShell(mon, this._runContext);
        }
    }

    protected class SendCommandToShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;
        protected String _cmd;

        public SendCommandToShellJob(String cmd, Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Send_command_to_Shell_message);
            this._cmd = cmd;
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = RemoteCmdSubSystem.access$0(this._cmd);
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage((String)"RSEG1056").makeSubstitution((Object)RemoteCmdSubSystem.this.getHostName()).getLevelOneText());
            }
            RemoteCmdSubSystem.this.internalSendCommandToShell(mon, this._cmd, this._runContext);
        }
    }

    protected class RemoveShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public RemoveShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Remove_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage((String)"RSEG1056").makeSubstitution((Object)RemoteCmdSubSystem.this.getHostName()).getLevelOneText());
            }
            RemoteCmdSubSystem.this.internalRemoveShell(this._runContext);
        }
    }
}

