/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.Vector;

public class SystemStringTokenizer {
    private Vector tokens;
    private int nextToken;

    public SystemStringTokenizer(String inputString, String delimiter) {
        this.tokens = SystemStringTokenizer.tokenize(inputString, delimiter);
        this.nextToken = 0;
    }

    public int countTokens() {
        return this.tokens.size();
    }

    public boolean hasMoreTokens() {
        return this.nextToken < this.tokens.size();
    }

    public String nextToken() {
        if (this.nextToken < this.tokens.size()) {
            return (String)this.tokens.elementAt(this.nextToken++);
        }
        return null;
    }

    public static Vector tokenize(String inputString, String delimiter) {
        Vector<String> v = new Vector<String>();
        StringBuffer token = new StringBuffer();
        String lastToken = null;
        int inpLen = inputString.length();
        int delimLen = delimiter.length();
        char delimChar1 = delimiter.charAt(0);
        int idx = 0;
        while (idx < inpLen) {
            int remLen = inpLen - idx;
            char currChar = inputString.charAt(idx);
            if (currChar == delimChar1 && remLen >= delimLen && inputString.substring(idx, idx + delimLen).equals(delimiter)) {
                lastToken = token.toString();
                v.addElement(lastToken);
                token.setLength(0);
                idx += delimLen - 1;
            } else {
                token.append(currChar);
            }
            ++idx;
        }
        if (token.length() > 0) {
            lastToken = token.toString();
            v.addElement(lastToken);
        }
        return v;
    }
}

