/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.internal.subsystems;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.MessageBox;
import org.osgi.framework.Bundle;

public class SubSystemConfigurationProxy
implements ISubSystemConfigurationProxy {
    private String name;
    private String description;
    private String id;
    private String types;
    private String vendor;
    private String category;
    private int priority;
    private String[] systemTypes;
    private List typesArray;
    private boolean allTypes = false;
    private ImageDescriptor image;
    private ImageDescriptor liveImage;
    private IConfigurationElement element = null;
    private ISubSystemConfiguration object = null;
    private boolean firstSubSystemQuery = true;

    public SubSystemConfigurationProxy(IConfigurationElement element) {
        this.element = element;
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name").trim();
        this.description = element.getAttribute("description").trim();
        this.types = element.getAttribute("systemTypes");
        this.vendor = element.getAttribute("vendor");
        this.category = element.getAttribute("category");
        this.priority = Integer.MAX_VALUE;
        String priorityStr = element.getAttribute("priority");
        try {
            if (priorityStr != null) {
                this.priority = Integer.parseInt(priorityStr);
            }
        }
        catch (NumberFormatException e) {
            this.priority = Integer.MAX_VALUE;
            SystemBasePlugin.logError("Exception reading priority for subsystem configuration " + this.name + " defined in plugin " + element.getDeclaringExtension().getNamespaceIdentifier(), e);
        }
        element.getAttribute("class");
        if (this.vendor == null) {
            this.vendor = "Unknown";
        }
        if (this.category == null) {
            this.category = "Unknown";
        }
        if (this.types == null) {
            this.types = "*";
        }
        this.allTypes = this.types.equals("*");
        this.image = this.getPluginImage(element, element.getAttribute("icon"));
        if (this.image == null) {
            this.image = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionIcon");
        }
        this.liveImage = this.getPluginImage(element, element.getAttribute("iconlive"));
        if (this.liveImage == null) {
            this.liveImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionliveIcon");
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String[] getSystemTypes() {
        if (this.systemTypes == null) {
            if (this.allTypes) {
                this.systemTypes = RSECorePlugin.getDefault().getRegistry().getSystemTypeNames();
            } else {
                StringTokenizer tokens = new StringTokenizer(this.types, ";");
                Vector<String> v = new Vector<String>();
                while (tokens.hasMoreTokens()) {
                    v.addElement(tokens.nextToken());
                }
                this.systemTypes = new String[v.size()];
                int idx = 0;
                while (idx < v.size()) {
                    this.systemTypes[idx] = (String)v.elementAt(idx);
                    ++idx;
                }
            }
        }
        return this.systemTypes;
    }

    public boolean supportsAllSystemTypes() {
        return this.allTypes;
    }

    public String getCategory() {
        return this.category;
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public ImageDescriptor getLiveImage() {
        if (this.liveImage != null) {
            return this.liveImage;
        }
        return this.image;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean appliesToSystemType(String type) {
        if (this.allTypes) {
            return true;
        }
        List typesArray = this.getTypesArray();
        return typesArray.contains(type);
    }

    private List getTypesArray() {
        if (this.typesArray == null) {
            this.typesArray = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(this.types, ";");
            while (tokenizer.hasMoreTokens()) {
                String type = tokenizer.nextToken();
                this.typesArray.add(type);
            }
        }
        return this.typesArray;
    }

    protected ImageDescriptor getPluginImage(IConfigurationElement element, String fileName) {
        URL path = this.getBundle().getEntry("/");
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, fileName);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isSubSystemConfigurationActive() {
        return this.object != null;
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        if (this.firstSubSystemQuery && this.object == null) {
            try {
                String nameSpace = this.element.getDeclaringExtension().getNamespace();
                String extensionType = this.element.getAttribute("class");
                Bundle bundle = Platform.getBundle((String)nameSpace);
                if (bundle.getState() != 1) {
                    Class menuExtension = bundle.loadClass(extensionType);
                    this.object = (ISubSystemConfiguration)menuExtension.getConstructors()[0].newInstance(null);
                }
                this.object.setSubSystemConfigurationProxy((ISubSystemConfigurationProxy)this);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                SystemBasePlugin.logError("Unable to start subsystem factory " + this.id, exc);
                MessageBox mb = new MessageBox(SystemBasePlugin.getActiveWorkbenchShell());
                mb.setText("Unexpected Error");
                String errmsg = "Unable to start subsystem factory " + this.getName() + ". See log file for details";
                mb.setMessage(errmsg);
                mb.open();
            }
            if (this.object != null) {
                try {
                    if (this.object instanceof SubSystemConfiguration) {
                        SubSystemConfiguration ssFactory = (SubSystemConfiguration)this.object;
                        ssFactory.restoreAllFilterPoolManagersForAllProfiles();
                    }
                }
                catch (Exception exc) {
                    SystemBasePlugin.logError("Error restoring subsystem for factory " + this.getName(), exc);
                }
            }
            this.firstSubSystemQuery = false;
        }
        return this.object;
    }

    public void reset() {
        if (this.object != null) {
            this.object.reset();
        }
    }

    public void restore() {
        if (this.object != null) {
            try {
                if (this.object instanceof SubSystemConfiguration) {
                    SubSystemConfiguration ssFactory = (SubSystemConfiguration)this.object;
                    ssFactory.restoreAllFilterPoolManagersForAllProfiles();
                }
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error restoring subsystem for factory " + this.getName(), exc);
            }
        }
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    protected Bundle getBundle() {
        String nameSpace = this.element.getDeclaringExtension().getNamespace();
        return Platform.getBundle((String)nameSpace);
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return ((String)o).equals(this.id);
        }
        if (o instanceof SubSystemConfigurationProxy) {
            return ((SubSystemConfigurationProxy)o).getId().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.valueOf(this.id) + "." + this.name;
    }
}

