/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.model.ISystemPromptableObject;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.view.ISystemViewRunnableObject;
import org.eclipse.swt.widgets.Shell;

public class SystemNewConnectionPromptObject
implements ISystemPromptableObject,
ISystemViewRunnableObject,
IAdaptable {
    private Object parent;
    private String[] systemTypes;
    private ISystemPromptableObject[] children;
    private SystemNewConnectionAction action = null;
    private boolean systemTypesSet = false;
    private String newConnText;
    private boolean isRootPrompt = false;
    static /* synthetic */ Class class$0;

    public SystemNewConnectionPromptObject() {
        this.systemTypes = RSECorePlugin.getDefault().getRegistry().getSystemTypeNames();
        this.isRootPrompt = true;
    }

    public SystemNewConnectionPromptObject(SystemNewConnectionPromptObject parent, String systemType) {
        this.parent = parent;
        this.systemTypes = new String[]{systemType};
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
        this.systemTypesSet = true;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public ISystemPromptableObject[] getChildren() {
        block4: {
            block3: {
                if (!this.hasChildren()) {
                    return null;
                }
                if (this.children != null) break block3;
                this.children = new ISystemPromptableObject[this.systemTypes.length];
                int idx = 0;
                while (idx < this.children.length) {
                    this.children[idx] = new SystemNewConnectionPromptObject(this, this.systemTypes[idx]);
                    ++idx;
                }
                break block4;
            }
            String[] typeNames = RSECorePlugin.getDefault().getRegistry().getSystemTypeNames();
            if (typeNames.length == this.systemTypes.length) break block4;
            this.systemTypes = typeNames;
            this.children = new ISystemPromptableObject[this.systemTypes.length];
            int idx = 0;
            while (idx < this.children.length) {
                this.children[idx] = new SystemNewConnectionPromptObject(this, this.systemTypes[idx]);
                ++idx;
            }
        }
        return this.children;
    }

    public boolean hasChildren() {
        return this.systemTypes.length != 1 || this.isRootPrompt;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.hasChildren()) {
            return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newconnection_wizIcon");
        }
        IRSESystemType sysType = RSECorePlugin.getDefault().getRegistry().getSystemType(this.systemTypes[0]);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.IRSESystemType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RSESystemTypeAdapter adapter = (RSESystemTypeAdapter)sysType.getAdapter((Class)clazz);
        return adapter.getImageDescriptor(sysType);
    }

    public String getText() {
        if (this.newConnText == null) {
            this.newConnText = this.hasChildren() || this.systemTypesSet ? (this.hasChildren() ? SystemResources.RESID_NEWCONN_PROMPT_LABEL : String.valueOf(SystemResources.RESID_NEWCONN_PROMPT_LABEL) + "...") : String.valueOf(this.systemTypes[0]) + "...";
        }
        return this.newConnText;
    }

    public String getType() {
        if (this.hasChildren()) {
            return SystemResources.RESID_NEWCONN_EXPANDABLEPROMPT_VALUE;
        }
        return SystemResources.RESID_NEWCONN_PROMPT_VALUE;
    }

    public Object[] run(Shell shell) {
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
        }
        if (this.systemTypes != null) {
            this.action.restrictSystemTypes(this.systemTypes);
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {
            return new Object[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, null)};
        }
        IHost newConnection = (IHost)this.action.getValue();
        SystemMessageObject result = null;
        result = newConnection != null ? new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1108"), 4, null) : new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, null);
        return new Object[]{result};
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }
}

