/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.ui.actions.ISystemDialogAction;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.ISystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemWizardDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemBaseDialogAction
extends SystemBaseAction
implements ISystemDialogAction {
    protected Object value;
    protected boolean processAll;
    protected boolean needsProgressMonitor;
    protected boolean needsProgressMonitorSet;
    protected boolean cancelled;
    protected String dlgHelpId;

    protected SystemBaseDialogAction(String text, ImageDescriptor image, Shell shell) {
        super(text, image, shell);
    }

    protected SystemBaseDialogAction(String text, String tooltip, ImageDescriptor image, Shell shell) {
        super(text, tooltip, image, shell);
    }

    protected SystemBaseDialogAction(String text, String tooltip, String description, ImageDescriptor image, Shell shell) {
        super(text, tooltip, description, image, shell);
    }

    public String getDialogHelpContextId() {
        return this.dlgHelpId;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean getNeedsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    protected boolean wasNeedsProgressMonitorSet() {
        return this.needsProgressMonitorSet;
    }

    protected boolean getProcessAllSelections() {
        return this.processAll;
    }

    public boolean wasCancelled() {
        if (this.cancelled) {
            return true;
        }
        return this.value == null;
    }

    public void setDialogHelp(String id) {
        this.dlgHelpId = id;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setNeedsProgressMonitor(boolean needs) {
        this.needsProgressMonitor = needs;
        this.needsProgressMonitorSet = true;
    }

    public void setProcessAllSelections(boolean all) {
        this.processAll = all;
    }

    public void run() {
        Shell shell = this.getShell();
        if (shell == null) {
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Warning: shell is null!");
        }
        Object currentSelection = null;
        currentSelection = !this.getProcessAllSelections() ? this.getFirstSelection() : this.getSelection();
        boolean cancelled = false;
        do {
            Dialog dlg;
            if ((dlg = this.createDialog(this.getShell())) == null) {
                return;
            }
            dlg.setBlockOnOpen(true);
            Object dialogInputValue = currentSelection;
            if (this.getValue() != null) {
                dialogInputValue = this.getValue();
            }
            if (dialogInputValue != null && dlg instanceof ISystemPromptDialog) {
                ((ISystemPromptDialog)dlg).setInputObject(dialogInputValue);
            }
            if (this.dlgHelpId != null) {
                if (dlg instanceof SystemPromptDialog) {
                    ((SystemPromptDialog)dlg).setHelp(this.dlgHelpId);
                } else if (dlg instanceof SystemWizardDialog) {
                    ((SystemWizardDialog)dlg).setHelp(this.dlgHelpId);
                }
            }
            if (dlg instanceof SystemPromptDialog && this.needsProgressMonitorSet) {
                ((SystemPromptDialog)dlg).setNeedsProgressMonitor(this.needsProgressMonitor);
            }
            dlg.open();
            if (dlg instanceof SystemWizardDialog) {
                if (((SystemWizardDialog)dlg).wasCancelled()) {
                    cancelled = true;
                }
            } else if (dlg instanceof SystemPromptDialog && ((SystemPromptDialog)dlg).wasCancelled()) {
                cancelled = true;
            }
            if (!cancelled) {
                this.setValue(this.getDialogValue(dlg));
                if (currentSelection != null && !this.getProcessAllSelections()) {
                    currentSelection = this.getNextSelection();
                    continue;
                }
                if (currentSelection == null) continue;
                currentSelection = null;
                continue;
            }
            this.setValue(null);
        } while (!cancelled && currentSelection != null);
    }

    protected abstract Dialog createDialog(Shell var1);

    protected abstract Object getDialogValue(Dialog var1);
}

