/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemIconConstants;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemDeleteDialog;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SystemCommonDeleteAction
extends SystemBaseDialogAction
implements ISystemIconConstants {
    private String promptLabel;

    public SystemCommonDeleteAction(Shell parent, ISystemDeleteTarget deleteTarget) {
        super(SystemResources.ACTION_DELETE_LABEL, SystemResources.ACTION_DELETE_TOOLTIP, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), parent);
        this.setSelectionProvider(deleteTarget);
        this.allowOnMultipleSelection(true);
        this.setProcessAllSelections(true);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0021");
    }

    public SystemCommonDeleteAction(Shell parent) {
        this(parent, null);
    }

    public void setPromptLabel(String text) {
        this.promptLabel = text;
    }

    private ISystemDeleteTarget getDeleteTarget() {
        return (ISystemDeleteTarget)this.getSelectionProvider();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ISystemDeleteTarget deleteTarget = this.getDeleteTarget();
        if (deleteTarget == null) {
            return true;
        }
        return deleteTarget.showDelete() && this.getDeleteTarget().canDelete();
    }

    protected Dialog createDialog(Shell shell) {
        Object firstSelection;
        SystemDeleteDialog dlg = new SystemDeleteDialog(shell);
        if (this.promptLabel != null) {
            dlg.setPromptLabel(this.promptLabel);
        }
        if (this.getRemoteAdapter(firstSelection = this.getFirstSelection()) != null) {
            String warningMsg = null;
            String warningTip = null;
            warningMsg = SystemResources.RESID_DELETE_WARNING_LABEL;
            warningTip = SystemResources.RESID_DELETE_WARNING_TOOLTIP;
            dlg.setWarningMessage(warningMsg, warningTip);
        }
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        if (!((SystemDeleteDialog)dlg).wasCancelled() && this.getDeleteTarget() != null) {
            ISystemDeleteTarget target = this.getDeleteTarget();
            DeleteRunnable delRunnable = new DeleteRunnable(target);
            IRunnableContext runnableContext = this.getRunnableContext(dlg.getShell());
            try {
                runnableContext.run(false, true, (IRunnableWithProgress)delRunnable);
            }
            catch (Exception exception) {}
            RSEUIPlugin.getTheSystemRegistry().clearRunnableContext();
            this.setEnabled(target.canDelete());
        }
        return null;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistry().setRunnableContext(shell, irc);
        return irc;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public class DeleteRunnable
    implements IRunnableWithProgress {
        private ISystemDeleteTarget _target;

        public DeleteRunnable(ISystemDeleteTarget target) {
            this._target = target;
        }

        public void run(IProgressMonitor monitor) {
            this._target.doDelete(monitor);
        }
    }
}

