/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class SystemCopyToClipboardAction
extends SystemBaseAction
implements IValidatorRemoteSelection {
    private IStructuredSelection _selection;
    private Clipboard _clipboard;
    static /* synthetic */ Class class$0;

    public SystemCopyToClipboardAction(Shell shell, Clipboard clipboard) {
        super(SystemResources.ACTION_COPY_LABEL, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"), shell);
        this._clipboard = clipboard;
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0116");
    }

    public void run() {
        if (this._selection != null) {
            this.copySelectionToClipboard(this._selection);
        }
    }

    private void copySelectionToClipboard(IStructuredSelection ss) {
        Iterator iterator = ss.iterator();
        StringBuffer textStream = new StringBuffer("");
        StringBuffer dataStream = new StringBuffer("");
        ArrayList fileNames = new ArrayList();
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        while (iterator.hasNext()) {
            ISystemViewElementAdapter adapter;
            Object dragObject = iterator.next();
            if (!(dragObject instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)dragObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            String text = adapter.getAlternateText(dragObject);
            textStream.append(this.getTextTransferPrepend(dragObject, adapter));
            textStream.append(text);
            textStream.append(this.getTextTransferAppend(dragObject, adapter));
            if (!adapter.canDrag(dragObject)) continue;
            ISubSystem subSystem = adapter.getSubSystem(dragObject);
            String subSystemId = registry.getAbsoluteNameForSubSystem(subSystem);
            dataStream.append(subSystemId);
            dataStream.append(":");
            String objectId = adapter.getAbsoluteName(dragObject);
            dataStream.append(objectId);
            if (!iterator.hasNext()) continue;
            dataStream.append("|");
        }
        PluginTransferData data = new PluginTransferData("org.eclipse.rse.ui.view.DropActions", dataStream.toString().getBytes());
        if (fileNames.size() == 0) {
            this._clipboard.setContents(new Object[]{data, textStream.toString()}, new Transfer[]{PluginTransfer.getInstance(), TextTransfer.getInstance()});
        } else {
            String[] ft = new String[fileNames.size()];
            int i = 0;
            while (i < ft.length) {
                ft[i] = (String)fileNames.get(i);
                ++i;
            }
            this._clipboard.setContents(new Object[]{data, ft, textStream.toString()}, new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
        }
    }

    protected String getTextTransferPrepend(Object obj, ISystemViewElementAdapter adapter) {
        return "";
    }

    protected String getTextTransferAppend(Object obj, ISystemViewElementAdapter adapter) {
        return System.getProperty("line.separator");
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        return null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof IAdaptable) {
                ISystemViewElementAdapter va;
                IAdaptable adaptable = (IAdaptable)selectedObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((va = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                    enable = va.canDrag(selectedObject);
                    continue;
                }
                enable = false;
                continue;
            }
            enable = false;
        }
        if (enable) {
            this._selection = selection;
        }
        return enable;
    }
}

