/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemSortableSelection;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemMoveUpConnectionAction
extends SystemBaseAction {
    private ISystemProfile prevProfile = null;

    public SystemMoveUpConnectionAction(Shell parent) {
        super(SystemResources.ACTION_MOVEUP_LABEL, SystemResources.ACTION_MOVEUP_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.upIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.reorder");
        this.setHelp("org.eclipse.rse.ui.actn0001");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
        this.prevProfile = null;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof IHost) {
                IHost conn = (IHost)selectedObject;
                if (this.prevProfile == null) {
                    this.prevProfile = conn.getSystemProfile();
                } else {
                    boolean bl = enable = this.prevProfile == conn.getSystemProfile();
                }
                if (!enable) continue;
                enable = sr.getHostPosition(conn) > 0;
                this.prevProfile = conn.getSystemProfile();
                continue;
            }
            enable = false;
        }
        return enable;
    }

    public void run() {
        SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
        SystemSortableSelection[] sortableArray = SystemSortableSelection.makeSortableArray(this.getSelection());
        IHost conn = null;
        int idx = 0;
        while (idx < sortableArray.length) {
            conn = (IHost)sortableArray[idx].getSelectedObject();
            sortableArray[idx].setPosition(sr.getHostPosition(conn));
            ++idx;
        }
        SystemSortableSelection.sortArray(sortableArray);
        IHost[] conns = (IHost[])SystemSortableSelection.getSortedObjects(sortableArray, new IHost[sortableArray.length]);
        sr.moveHosts(this.prevProfile.getName(), conns, -1);
    }
}

