/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.model.ISystemPromptableObject;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenInNewWindowAction;

public class SystemOpenExplorerPerspectiveAction
extends SystemBaseAction {
    private IWorkbenchWindow window;
    private IPerspectiveRegistry reg;
    private IPerspectiveDescriptor desc = null;

    public SystemOpenExplorerPerspectiveAction(Shell parent, IWorkbenchWindow currentWorkbenchWindow) {
        super(SystemResources.ACTION_OPENEXPLORER_DIFFPERSP2_LABEL, SystemResources.ACTION_OPENEXPLORER_DIFFPERSP2_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.system_perspIcon"), parent);
        this.window = currentWorkbenchWindow;
        this.reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        this.desc = this.reg.findPerspectiveWithId("org.eclipse.rse.ui.view.SystemPerspective");
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.open");
        this.setHelp("org.eclipse.rse.ui.actn0016");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Object selected = selection.getFirstElement();
        if (selected instanceof ISystemFilterReference) {
            if (((ISystemFilterReference)selected).getReferencedFilter().isPromptable()) {
                enable = false;
            }
        } else if (selected instanceof ISystemPromptableObject) {
            enable = false;
        }
        return enable;
    }

    public void run() {
        OpenInNewWindowAction workbenchOpenAction = new OpenInNewWindowAction(this.window, this.getPageInput());
        workbenchOpenAction.run();
    }

    public void setPageInput(IAdaptable input) {
    }

    public IAdaptable getPageInput() {
        Object firstSel = this.getFirstSelection();
        if (firstSel != null && firstSel instanceof IAdaptable) {
            return (IAdaptable)firstSel;
        }
        return null;
    }
}

