/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterStringReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.SystemFilterSimple;
import org.eclipse.rse.internal.model.SystemNewConnectionPromptObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemSelectRemoteObjectAPIProviderCaller;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectRemoteObjectAPIProviderImpl
extends SystemAbstractAPIProvider
implements ISystemViewInputProvider {
    protected ISubSystem subsystem = null;
    protected String filterString = null;
    protected ISystemViewElementAdapter subsystemAdapter = null;
    protected boolean listConnectionsMode = false;
    protected boolean showNewConnectionPrompt = false;
    protected boolean singleConnectionMode = false;
    protected String subsystemFactoryId;
    protected String subsystemFactoryCategory;
    protected String filterSuffix;
    protected String[] systemTypes;
    protected String preSelectFilterChild;
    protected Object preSelectFilterChildObject;
    protected ISystemFilter[] quickFilters;
    protected IHost[] inputConnections;
    protected SystemNewConnectionPromptObject connPrompt = null;
    protected Object[] connPromptAsArray;
    protected ISystemSelectRemoteObjectAPIProviderCaller caller;
    protected boolean multiConnections = false;

    public SystemSelectRemoteObjectAPIProviderImpl(String factoryId, String factoryCategory, boolean showNewConnectionPrompt, String[] systemTypes) {
        this.subsystemFactoryId = factoryId;
        this.subsystemFactoryCategory = factoryCategory;
        this.systemTypes = systemTypes;
        this.showNewConnectionPrompt = showNewConnectionPrompt;
        this.listConnectionsMode = true;
    }

    public void setCaller(ISystemSelectRemoteObjectAPIProviderCaller caller) {
        this.caller = caller;
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public SystemSelectRemoteObjectAPIProviderImpl(ISubSystem subsystem) {
        this.setSubSystem(subsystem);
    }

    public SystemSelectRemoteObjectAPIProviderImpl() {
    }

    public void setSystemConnection(IHost connection, boolean onlyMode) {
        this.inputConnections = new IHost[]{connection};
        this.singleConnectionMode = onlyMode;
        if (onlyMode) {
            this.multiConnections = false;
        }
    }

    public void setSubSystem(ISubSystem subsystem) {
        this.subsystem = subsystem;
        this.subsystemAdapter = subsystem != null ? this.getAdapter(subsystem) : null;
    }

    public void setFilterString(String string) {
        this.filterString = string;
        this.filterSuffix = null;
        if (string == null) {
            return;
        }
        if (string.endsWith(",")) {
            int idx = string.indexOf(47);
            if (idx == -1) {
                idx = string.indexOf(92);
            }
            if (idx == -1) {
                this.filterSuffix = string;
            }
        }
        if (this.filterSuffix != null) {
            this.filterString = null;
        }
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "*** FILTER SUFFIX = '" + this.filterSuffix + "' ***");
    }

    public void setQuickFilters(ISystemFilter[] filters) {
        this.quickFilters = filters;
    }

    public void setPreSelectFilterChild(String name) {
        this.preSelectFilterChild = name;
    }

    public String getPreSelectFilterChild() {
        return this.preSelectFilterChild;
    }

    public void setPreSelectFilterChildObject(Object obj) {
        this.preSelectFilterChildObject = obj;
    }

    public Object getPreSelectFilterChildObject() {
        return this.preSelectFilterChildObject;
    }

    public String decorateFilterString(Object selectedObject, String inputFilterString) {
        if (inputFilterString == null) {
            return inputFilterString;
        }
        if (this.filterSuffix != null && inputFilterString.indexOf(this.filterSuffix) == -1) {
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "*** INPUT FILTER = '" + inputFilterString + "' ***");
            String result = inputFilterString;
            result = this.filterSuffix.equals(" /nf") ? String.valueOf(inputFilterString) + this.filterSuffix : inputFilterString;
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "*** ADORNED FILTER = '" + result + "' ***");
            return result;
        }
        return inputFilterString;
    }

    public boolean filtersNeedDecoration(Object selectedObject) {
        ISubSystemConfiguration ssf = this.getSubSystemConfiguration(selectedObject);
        if (ssf == null) {
            return false;
        }
        return false;
    }

    private ISubSystemConfiguration getSubSystemConfiguration(Object selectedObject) {
        if (selectedObject instanceof ISystemFilterReference) {
            ISubSystem ss = (ISubSystem)((ISystemFilterReference)selectedObject).getProvider();
            return ss.getSubSystemConfiguration();
        }
        if (selectedObject instanceof ISystemFilterStringReference) {
            ISubSystem ss = (ISubSystem)((ISystemFilterStringReference)selectedObject).getProvider();
            return ss.getSubSystemConfiguration();
        }
        return null;
    }

    public Object[] getSystemViewRoots() {
        if (this.listConnectionsMode) {
            return this.getConnections();
        }
        if (this.subsystemAdapter == null) {
            return this.emptyList;
        }
        Object[] children = null;
        children = this.filterString == null ? this.subsystemAdapter.getChildren(this.subsystem) : this.resolveFilterString(this.subsystem, this.filterString);
        return this.checkForNull(children, true);
    }

    public boolean hasSystemViewRoots() {
        if (this.listConnectionsMode) {
            return true;
        }
        boolean hasroots = false;
        hasroots = this.subsystemAdapter == null ? false : (this.filterString != null ? true : this.subsystemAdapter.hasChildren(this.subsystem));
        return hasroots;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        if (!this.listConnectionsMode) {
            return null;
        }
        Object[] children = null;
        ISubSystem[] subsystems = this.getSubSystems(selectedConnection);
        if (subsystems != null && subsystems.length > 0) {
            ISubSystem subsystem = subsystems[0];
            if (subsystems.length > 1) {
                SystemBasePlugin.logWarning(String.valueOf(this.getClass().getName()) + ": More than one subsystem meeting criteria. SSFID = " + this.subsystemFactoryId + ", SSFCat = " + this.subsystemFactoryCategory);
            }
            if (this.quickFilters != null) {
                if (this.multiConnections) {
                    children = new ISystemFilter[this.quickFilters.length];
                    int idx = 0;
                    while (idx < this.quickFilters.length) {
                        SystemFilterSimple quickFilter = (SystemFilterSimple)this.quickFilters[idx];
                        children[idx] = new SystemFilterSimple(quickFilter.getName());
                        quickFilter.clone((ISystemFilter)children[idx]);
                        ((SystemFilterSimple)((Object)children[idx])).setParent(subsystem);
                        ++idx;
                    }
                } else {
                    int idx = 0;
                    while (idx < this.quickFilters.length) {
                        if (this.quickFilters[idx] instanceof SystemFilterSimple) {
                            ((SystemFilterSimple)this.quickFilters[idx]).setParent(subsystem);
                        }
                        ++idx;
                    }
                    children = this.quickFilters;
                }
            } else {
                children = this.filterString == null || this.filterSuffix != null ? subsystem.getChildren() : this.resolveFilterString(subsystem, this.filterString);
            }
        }
        return this.checkForNull(children, true);
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return true;
    }

    public boolean showActionBar() {
        return false;
    }

    public boolean showButtonBar() {
        return false;
    }

    public boolean showActions() {
        return true;
    }

    public boolean showingConnections() {
        return this.listConnectionsMode;
    }

    protected Object[] getConnections() {
        if (this.singleConnectionMode && !this.showNewConnectionPrompt) {
            return this.inputConnections;
        }
        if (this.connPrompt == null && this.showNewConnectionPrompt) {
            this.connPrompt = new SystemNewConnectionPromptObject();
            this.connPromptAsArray = new Object[1];
            this.connPromptAsArray[0] = this.connPrompt;
        }
        if (this.connPrompt != null && this.systemTypes != null) {
            this.connPrompt.setSystemTypes(this.systemTypes);
        }
        IHost[] conns = null;
        conns = this.singleConnectionMode ? this.inputConnections : (this.systemTypes != null ? this.sr.getHostsBySystemTypes(this.systemTypes) : (this.subsystemFactoryId != null ? this.sr.getHostsBySubSystemConfigurationId(this.subsystemFactoryId) : (this.subsystemFactoryCategory != null ? this.sr.getHostsBySubSystemConfigurationCategory(this.subsystemFactoryCategory) : this.sr.getHosts())));
        Object[] children = null;
        if (this.showNewConnectionPrompt) {
            if (conns == null || conns.length == 0) {
                children = this.connPromptAsArray;
            } else {
                this.multiConnections = conns.length > 1;
                children = new Object[1 + conns.length];
                children[0] = this.connPrompt;
                int idx = 0;
                while (idx < conns.length) {
                    children[idx + 1] = conns[idx];
                    ++idx;
                }
            }
        } else {
            children = conns;
            this.multiConnections = conns != null && conns.length > 1;
        }
        return this.checkForNull(children, false);
    }

    protected ISubSystem[] getSubSystems(IHost selectedConnection) {
        ISubSystem[] subsystems = null;
        subsystems = this.subsystemFactoryId != null ? this.sr.getSubSystems(this.subsystemFactoryId, selectedConnection) : (this.subsystemFactoryCategory != null ? this.sr.getSubSystemsBySubSystemConfigurationCategory(this.subsystemFactoryCategory, selectedConnection) : this.sr.getSubSystems(selectedConnection));
        return subsystems;
    }

    protected Object[] resolveFilterString(ISubSystem subsystem, String filterString) {
        Object[] children = null;
        try {
            children = subsystem.resolveFilterString(filterString);
        }
        catch (InterruptedException interruptedException) {
            if (this.canceledObject == null) {
                children = this.getCancelledMessageObject();
            }
        }
        catch (Exception exc) {
            children = this.getFailedMessageObject();
            SystemBasePlugin.logError("Error in SystemTestFilterStringAPIProviderImpl#getSystemViewRoots()", exc);
        }
        return children;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter(o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public ISystemFilter createFilterByPrompting(ISystemFilter filterPrompt, Shell shell) throws Exception {
        if (this.caller != null) {
            return this.caller.createFilterByPrompting(filterPrompt, shell);
        }
        return null;
    }
}

