/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SystemTeamViewLabelProvider
extends LabelProvider {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    private WorkbenchLabelProvider aWorkbenchLabelProvider = new WorkbenchLabelProvider();
    private Viewer viewer;
    private Map imageTable = new Hashtable(40);
    static /* synthetic */ Class class$0;

    public SystemTeamViewLabelProvider(Viewer viewer) {
        this.viewer = viewer;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor;
        Image image = null;
        if (element instanceof ISystemProfile) {
            ISystemProfile profile = (ISystemProfile)element;
            if (RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager().isSystemProfileActive(profile.getName())) {
                return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.systemprofile_activeIcon");
            }
            return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.systemprofileIcon");
        }
        if (element instanceof IProject) {
            Image projectImage = this.aWorkbenchLabelProvider.getImage(element);
            return projectImage;
        }
        ISystemViewElementAdapter adapter = this.getSystemViewAdapter(element);
        if (adapter != null && (descriptor = adapter.getImageDescriptor(element)) != null) {
            return this.getImageFromImageDescriptor(descriptor);
        }
        image = this.aWorkbenchLabelProvider.getImage(element);
        if (image != null) {
            return image;
        }
        return super.getImage(element);
    }

    private Image getImageFromImageDescriptor(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.imageTable.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageTable.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        ISystemViewElementAdapter adapter = this.getSystemViewAdapter(element);
        if (adapter != null) {
            return adapter.getText(element);
        }
        if (element instanceof IProject) {
            return ((IProject)element).getName();
        }
        String text = this.aWorkbenchLabelProvider.getText(element);
        if (text.length() > 0) {
            return text;
        }
        return super.getText(element);
    }

    public void dispose() {
        Collection imageValues;
        if (this.imageTable != null && (imageValues = this.imageTable.values()) != null) {
            Iterator images = imageValues.iterator();
            if (images != null) {
                while (images.hasNext()) {
                    ((Image)images.next()).dispose();
                }
            }
            this.imageTable = null;
        }
    }

    protected ISystemViewElementAdapter getSystemViewAdapter(Object o) {
        ISystemViewElementAdapter adapter = null;
        if (o == null) {
            SystemBasePlugin.logWarning("ERROR: null passed to getAdapter in SystemTeamViewLabelProvider");
            return null;
        }
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemViewElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        } else {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
        }
        if (adapter != null && this.viewer != null) {
            Shell shell = null;
            if (this.viewer instanceof ISystemResourceChangeListener) {
                shell = ((ISystemResourceChangeListener)this.viewer).getShell();
            } else if (this.viewer != null) {
                shell = this.viewer.getControl().getShell();
            }
            if (shell != null) {
                adapter.setShell(shell);
            }
            adapter.setViewer(this.viewer);
            if (this.viewer.getInput() instanceof ISystemViewInputProvider) {
                ISystemViewInputProvider inputProvider = (ISystemViewInputProvider)this.viewer.getInput();
                adapter.setInput(inputProvider);
            }
        } else if (this.viewer == null) {
            SystemBasePlugin.logWarning("VIEWER IS NULL FOR SystemTeamViewLabelProvider");
        }
        return adapter;
    }
}

