/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.ui.view.SystemViewConnectionSelectionInputProvider;
import org.eclipse.rse.ui.view.SystemViewForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemSelectConnectionForm
extends SystemBaseForm
implements ISelectionChangedListener {
    protected static final int PROMPT_WIDTH = 200;
    protected Label verbageLabel;
    protected Label spacer1;
    protected Label spacer2;
    protected Text nameEntryValue;
    protected SystemViewForm tree;
    protected SystemPropertySheetForm ps;
    protected Composite outerParent;
    protected Composite ps_composite;
    protected String verbage = null;
    protected String[] systemTypes = null;
    protected IHost defaultConn;
    protected boolean allowNew = true;
    protected boolean multipleSelectionMode;
    protected boolean showPropertySheet = false;
    protected Vector listeners = new Vector();
    protected IHost[] outputConnections = null;
    protected IHost outputConnection = null;
    protected boolean initDone;
    protected boolean contentsCreated;
    protected int autoExpandDepth = 0;
    protected Object previousSelection = null;

    public SystemSelectConnectionForm(Shell shell, ISystemMessageLine msgLine) {
        super(shell, msgLine);
        this.verbage = SystemResources.RESID_SELECTCONNECTION_VERBAGE;
    }

    public void setDefaultConnection(IHost conn) {
        this.defaultConn = conn;
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.allowNew = show;
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(String systemType) {
        this.systemTypes = new String[1];
        this.systemTypes[0] = systemType;
    }

    public void setMessage(String message) {
        this.verbage = message;
        if (this.verbageLabel != null) {
            this.verbageLabel.setText(message);
        }
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
    }

    public void addSelectionChangedListener(ISelectionChangedListener l) {
        if (this.tree != null) {
            this.tree.addSelectionChangedListener(l);
        } else {
            this.listeners.addElement(l);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        if (this.tree != null) {
            this.tree.removeSelectionChangedListener(l);
        } else {
            this.listeners.removeElement(l);
        }
    }

    public IHost[] getSelectedConnections() {
        return this.outputConnections;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    public boolean getMultipleSelectionMode() {
        return this.multipleSelectionMode;
    }

    public Control getInitialFocusControl() {
        return this.tree.getTreeControl();
    }

    public boolean toggleShowPropertySheet(Shell shell, Control contents) {
        ISelection s;
        Point windowSize = shell.getSize();
        Point oldSize = contents.computeSize(-1, -1);
        if (this.showPropertySheet) {
            this.ps.dispose();
            this.spacer1.dispose();
            this.spacer2.dispose();
            this.ps_composite.dispose();
            this.ps = null;
            this.spacer2 = null;
            this.spacer1 = null;
            this.ps_composite = null;
            ((GridLayout)this.outerParent.getLayout()).numColumns = 1;
        } else {
            ((GridLayout)this.outerParent.getLayout()).numColumns = 2;
            this.createPropertySheet(this.outerParent, shell);
        }
        Point newSize = contents.computeSize(-1, -1);
        shell.setSize(new Point(windowSize.x + (newSize.x - oldSize.x), windowSize.y));
        if (this.ps != null && (s = this.tree.getSelection()) != null) {
            this.ps.selectionChanged(s);
        }
        this.showPropertySheet = !this.showPropertySheet;
        return this.showPropertySheet;
    }

    private void createPropertySheet(Composite outerParent, Shell shell) {
        this.ps_composite = SystemWidgetHelpers.createFlushComposite(outerParent, 1);
        ((GridData)this.ps_composite.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.ps_composite.getLayoutData()).verticalAlignment = 4;
        this.spacer1 = SystemWidgetHelpers.createLabel(this.ps_composite, "", 1);
        this.spacer2 = SystemWidgetHelpers.createLabel(this.ps_composite, "", 1);
        this.ps = new SystemPropertySheetForm(shell, this.ps_composite, 2048, this.getMessageLine());
    }

    public void dispose() {
        if (this.tree != null) {
            this.tree.removeSelectionChangedListener(this);
            int i = 0;
            while (i < this.listeners.size()) {
                this.tree.removeSelectionChangedListener((ISelectionChangedListener)this.listeners.get(i));
                ++i;
            }
        }
    }

    public Control createContents(Composite parent) {
        this.contentsCreated = true;
        this.outerParent = parent;
        this.outerParent = SystemWidgetHelpers.createComposite(parent, this.showPropertySheet ? 2 : 1);
        int gridColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createFlushComposite(this.outerParent, gridColumns);
        if (this.showPropertySheet) {
            this.createPropertySheet(this.outerParent, this.getShell());
        }
        this.verbageLabel = SystemWidgetHelpers.createVerbiage(composite_prompts, this.verbage, gridColumns, false, 200);
        SystemWidgetHelpers.createLabel(composite_prompts, "", gridColumns);
        Composite nameComposite = composite_prompts;
        int nameSpan = gridColumns;
        this.nameEntryValue = SystemWidgetHelpers.createReadonlyTextField(nameComposite);
        ((GridData)this.nameEntryValue.getLayoutData()).horizontalSpan = nameSpan;
        SystemViewConnectionSelectionInputProvider inputProvider = new SystemViewConnectionSelectionInputProvider();
        inputProvider.setShowNewConnectionPrompt(this.allowNew);
        inputProvider.setSystemTypes(this.systemTypes);
        this.tree = new SystemViewForm(this.getShell(), composite_prompts, 0, inputProvider, !this.multipleSelectionMode, this.getMessageLine(), gridColumns, 1);
        ((GridData)this.tree.getLayoutData()).widthHint = 200;
        if (!this.initDone) {
            this.doInitializeFields();
        }
        this.tree.addSelectionChangedListener(this);
        if (this.listeners.size() > 0) {
            int idx = 0;
            while (idx < this.listeners.size()) {
                this.tree.addSelectionChangedListener((ISelectionChangedListener)this.listeners.elementAt(idx));
                ++idx;
            }
        }
        if (this.defaultConn != null) {
            this.tree.select(this.defaultConn, true);
        }
        return composite_prompts;
    }

    public boolean verify() {
        this.getMessageLine().clearErrorMessage();
        this.outputConnection = this.internalGetConnection();
        return true;
    }

    private IHost internalGetConnection() {
        Object o = this.tree.getSystemView().getRootParent();
        if (o instanceof IHost) {
            return (IHost)o;
        }
        return null;
    }

    protected void setNameText(String text) {
        this.nameEntryValue.setText(text);
    }

    private void doInitializeFields() {
        this.initDone = true;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        ISelection selection = e.getSelection();
        if (this.ps != null) {
            this.ps.selectionChanged(selection);
        }
        this.outputConnections = null;
        Object[] outputObjects = this.getSelections(selection);
        if (outputObjects != null && outputObjects.length > 0 && outputObjects[0] instanceof IHost) {
            this.outputConnections = new IHost[outputObjects.length];
            int idx = 0;
            while (idx < this.outputConnections.length) {
                this.outputConnections[idx] = (IHost)outputObjects[idx];
                ++idx;
            }
        }
        if (this.outputConnections != null && this.outputConnections.length > 0) {
            this.setNameText(this.outputConnections[0].getAliasName());
            this.setPageComplete(true);
        } else {
            this.setNameText("");
            this.setPageComplete(false);
        }
    }

    protected Object getFirstSelection(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Iterator selectionIterator = sSelection.iterator();
            if (selectionIterator.hasNext()) {
                return selectionIterator.next();
            }
            return null;
        }
        return null;
    }

    protected Object[] getSelections(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Object[] selectedObjects = new Object[sSelection.size()];
            Iterator selectionIterator = sSelection.iterator();
            int idx = 0;
            while (selectionIterator.hasNext()) {
                selectedObjects[idx++] = selectionIterator.next();
            }
            return selectedObjects;
        }
        return null;
    }
}

