/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPerspectiveHelpers;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemNewConnectionWizardPage;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter;
import org.eclipse.rse.model.DummyHost;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemStartHere;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizard;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizardDefaultDelegateMainPage;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizardDelegate;
import org.eclipse.rse.ui.wizards.SystemNewConnectionWizardRenameProfilePage;

public class RSEDefaultNewConnectionWizardDelegate
extends RSENewConnectionWizardDelegate {
    private RSENewConnectionWizardDefaultDelegateMainPage mainPage;
    private SystemNewConnectionWizardRenameProfilePage rnmProfilePage;
    private ISystemNewConnectionWizardPage[] subsystemFactorySuppliedWizardPages;
    private Hashtable ssfWizardPagesPerSystemType = new Hashtable();
    private String defaultUserId;
    private String defaultConnectionName;
    private String defaultHostName;
    private String[] activeProfileNames = null;
    private int privateProfileIndex = -1;
    private ISystemProfile privateProfile = null;
    private IHost currentlySelectedConnection = null;
    private String[] restrictSystemTypesTo;
    private static String lastProfile = null;
    private boolean showProfilePageInitially = true;
    private IHost _dummyHost;
    static /* synthetic */ Class class$0;

    public void init(RSENewConnectionWizard wizard, IRSESystemType systemType) {
        super.init(wizard, systemType);
        this.restrictSystemType(systemType.getName());
        this.activeProfileNames = SystemStartHere.getSystemProfileManager().getActiveSystemProfileNames();
        this.systemTypeSelected(systemType.getName(), true);
    }

    public void restrictSystemType(String systemType) {
        this.restrictSystemTypesTo = new String[1];
        this.restrictSystemTypesTo[0] = systemType;
        if (this.mainPage != null) {
            this.mainPage.restrictSystemTypes(this.restrictSystemTypesTo);
        }
    }

    public void restrictSystemTypes(String[] systemTypes) {
        this.restrictSystemTypesTo = systemTypes;
        if (this.mainPage != null) {
            this.mainPage.restrictSystemTypes(systemTypes);
        }
    }

    public IHost getDummyHost() {
        if (this._dummyHost == null) {
            this._dummyHost = new DummyHost(this.mainPage.getHostName(), this.mainPage.getSystemType());
        }
        return this._dummyHost;
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage(this.restrictSystemTypesTo);
            this.mainPage.setConnectionNameValidators(SystemConnectionForm.getConnectionNameValidators());
            this.mainPage.setCurrentlySelectedConnection(this.currentlySelectedConnection);
            if (this.defaultUserId != null) {
                this.mainPage.setUserId(this.defaultUserId);
            }
            if (this.defaultConnectionName != null) {
                this.mainPage.setConnectionName(this.defaultConnectionName);
            }
            if (this.defaultHostName != null) {
                this.mainPage.setHostName(this.defaultHostName);
            }
            if (this.restrictSystemTypesTo != null) {
                this.mainPage.restrictSystemTypes(this.restrictSystemTypesTo);
            }
            SystemStartHere.getSystemProfileManager().getDefaultPrivateSystemProfile();
            this.showProfilePageInitially = RSEUIPlugin.getDefault().getShowProfilePageInitially();
            this.mainPage.setProfileNames(this.activeProfileNames);
            if (this.currentlySelectedConnection == null) {
                if (lastProfile == null && this.activeProfileNames != null) {
                    String defaultTeamName = "Team";
                    int idx = 0;
                    while (lastProfile == null && idx < this.activeProfileNames.length) {
                        if (!this.activeProfileNames[idx].equals(defaultTeamName)) {
                            lastProfile = this.activeProfileNames[idx];
                        }
                        ++idx;
                    }
                    if (lastProfile == null && this.activeProfileNames.length > 0) {
                        lastProfile = this.activeProfileNames[0];
                    }
                }
                if (lastProfile != null) {
                    this.mainPage.setProfileNamePreSelection(lastProfile);
                }
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("New connection: Error in createPages: ", exc);
        }
    }

    protected RSENewConnectionWizardDefaultDelegateMainPage createMainPage(String[] restrictSystemTypesTo) {
        String pageTitle = this.getPageTitle();
        this.mainPage = new RSENewConnectionWizardDefaultDelegateMainPage(this.getWizard(), pageTitle, SystemResources.RESID_NEWCONN_PAGE1_DESCRIPTION);
        this.getWizard().setOutputObject(null);
        return this.mainPage;
    }

    public String getPageTitle() {
        String pageTitle = null;
        if (this.restrictSystemTypesTo == null || this.restrictSystemTypesTo.length != 1) {
            pageTitle = SystemResources.RESID_NEWCONN_PAGE1_TITLE;
        } else {
            String onlySystemType = this.restrictSystemTypesTo[0];
            if (onlySystemType.equals("Local")) {
                pageTitle = SystemResources.RESID_NEWCONN_PAGE1_LOCAL_TITLE;
            } else {
                pageTitle = SystemResources.RESID_NEWCONN_PAGE1_REMOTE_TITLE;
                pageTitle = SystemMessage.sub((String)pageTitle, (String)"&1", (String)onlySystemType);
            }
        }
        return pageTitle;
    }

    public void setCurrentlySelectedConnection(IHost conn) {
        this.currentlySelectedConnection = conn;
    }

    public void setUserId(String userId) {
        this.defaultUserId = userId;
        if (this.mainPage != null) {
            this.mainPage.setUserId(userId);
        }
    }

    public void setConnectionName(String name) {
        this.defaultConnectionName = name;
        if (this.mainPage != null) {
            this.mainPage.setConnectionName(name);
        }
    }

    public void setHostName(String name) {
        this.defaultHostName = name;
        if (this.mainPage != null) {
            this.mainPage.setHostName(name);
        }
    }

    public boolean performFinish() {
        boolean ok = this.mainPage.performFinish();
        if (!ok) {
            this.getWizard().setPageError((IWizardPage)this.mainPage);
        } else if (ok && this.hasAdditionalPages()) {
            int idx = 0;
            while (ok && idx < this.subsystemFactorySuppliedWizardPages.length) {
                ok = this.subsystemFactorySuppliedWizardPages[idx].performFinish();
                if (!ok) {
                    this.getWizard().setPageError((IWizardPage)this.subsystemFactorySuppliedWizardPages[idx]);
                }
                ++idx;
            }
        }
        if (ok) {
            String msg;
            boolean cursorSet = true;
            this.getWizard().setBusyCursor(true);
            SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            if (this.privateProfile != null) {
                try {
                    String newName = this.activeProfileNames[this.privateProfileIndex];
                    sr.renameSystemProfile(this.privateProfile, newName);
                }
                catch (SystemMessageException exc) {
                    SystemMessageDialog.displayMessage(this.getWizard().getShell(), exc);
                    ok = false;
                }
                catch (Exception exc) {
                    this.getWizard().setBusyCursor(false);
                    cursorSet = false;
                    msg = "Exception renaming profile ";
                    SystemBasePlugin.logError(msg, exc);
                    SystemMessageDialog.displayExceptionMessage(this.getWizard().getShell(), exc);
                    ok = false;
                }
            }
            if (ok) {
                try {
                    String sysType = this.mainPage.getSystemType();
                    IHost conn = sr.createHost(this.mainPage.getProfileName(), sysType, this.mainPage.getConnectionName(), this.mainPage.getHostName(), this.mainPage.getConnectionDescription(), this.mainPage.getDefaultUserId(), this.mainPage.getDefaultUserIdLocation(), this.subsystemFactorySuppliedWizardPages);
                    this.getWizard().setBusyCursor(false);
                    cursorSet = false;
                    if (conn != null && SystemPerspectiveHelpers.isRSEPerspectiveActive()) {
                        if (sysType.equals("iSeries")) {
                            ISubSystem[] objSubSystems = sr.getSubSystemsBySubSystemConfigurationCategory("nativefiles", conn);
                            if (objSubSystems != null && objSubSystems.length > 0) {
                                sr.expandSubSystem(objSubSystems[0]);
                            } else {
                                sr.expandHost(conn);
                            }
                        } else {
                            sr.expandHost(conn);
                        }
                    }
                    lastProfile = this.mainPage.getProfileName();
                    this.getWizard().setOutputObject(conn);
                }
                catch (Exception exc) {
                    if (cursorSet) {
                        this.getWizard().setBusyCursor(false);
                    }
                    cursorSet = false;
                    msg = "Exception creating connection ";
                    SystemBasePlugin.logError(msg, exc);
                    SystemMessageDialog.displayExceptionMessage(this.getWizard().getShell(), exc);
                    ok = false;
                }
            }
            if (cursorSet) {
                this.getWizard().setBusyCursor(false);
            }
            return ok;
        }
        return ok;
    }

    protected void setNewPrivateProfileName(String newName) {
        this.activeProfileNames[this.privateProfileIndex] = newName;
        if (this.mainPage != null) {
            this.mainPage.setProfileNames(this.activeProfileNames);
            this.mainPage.setProfileNamePreSelection(newName);
        }
    }

    public IWizardPage getMainPage() {
        if (this.mainPage == null) {
            this.addPages();
        }
        return this.mainPage;
    }

    public SystemConnectionForm getMainPageForm() {
        return this.mainPage.getForm();
    }

    public void systemTypeSelected(String systemType, boolean duringInitialization) {
        this.subsystemFactorySuppliedWizardPages = this.getAdditionalWizardPages(systemType);
        if (!duringInitialization) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected ISystemNewConnectionWizardPage[] getAdditionalWizardPages(String systemType) {
        this.subsystemFactorySuppliedWizardPages = (ISystemNewConnectionWizardPage[])this.ssfWizardPagesPerSystemType.get(systemType);
        if (this.subsystemFactorySuppliedWizardPages == null) {
            Vector<ISystemNewConnectionWizardPage> additionalPages = new Vector<ISystemNewConnectionWizardPage>();
            SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
            ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType, true);
            int idx = 0;
            while (idx < factories.length) {
                ISubSystemConfigurationAdapter adapter;
                ISystemNewConnectionWizardPage[] pages;
                ISubSystemConfiguration iSubSystemConfiguration = factories[idx];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((pages = (adapter = (ISubSystemConfigurationAdapter)iSubSystemConfiguration.getAdapter((Class)clazz)).getNewConnectionWizardPages(factories[idx], (IWizard)this.getWizard())) != null) {
                    int widx = 0;
                    while (widx < pages.length) {
                        additionalPages.addElement(pages[widx]);
                        ++widx;
                    }
                }
                ++idx;
            }
            this.subsystemFactorySuppliedWizardPages = new ISystemNewConnectionWizardPage[additionalPages.size()];
            idx = 0;
            while (idx < this.subsystemFactorySuppliedWizardPages.length) {
                this.subsystemFactorySuppliedWizardPages[idx] = (ISystemNewConnectionWizardPage)additionalPages.elementAt(idx);
                ++idx;
            }
            this.ssfWizardPagesPerSystemType.put(systemType, this.subsystemFactorySuppliedWizardPages);
        }
        return this.subsystemFactorySuppliedWizardPages;
    }

    protected boolean hasAdditionalPages() {
        return this.subsystemFactorySuppliedWizardPages != null && this.subsystemFactorySuppliedWizardPages.length > 0;
    }

    protected ISystemNewConnectionWizardPage getFirstAdditionalPage() {
        if (this.subsystemFactorySuppliedWizardPages != null && this.subsystemFactorySuppliedWizardPages.length > 0) {
            RSENewConnectionWizardDefaultDelegateMainPage previousPage = this.mainPage;
            int idx = 0;
            while (idx < this.subsystemFactorySuppliedWizardPages.length) {
                ((IWizardPage)this.subsystemFactorySuppliedWizardPages[idx]).setPreviousPage((IWizardPage)previousPage);
                previousPage = (IWizardPage)this.subsystemFactorySuppliedWizardPages[idx];
                ++idx;
            }
            return this.subsystemFactorySuppliedWizardPages[0];
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (!this.hasAdditionalPages() || page == this.rnmProfilePage) {
            return null;
        }
        int index = this.getAdditionalPageIndex(page);
        if (index == this.subsystemFactorySuppliedWizardPages.length - 1) {
            return null;
        }
        return (IWizardPage)this.subsystemFactorySuppliedWizardPages[index + 1];
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    private int getAdditionalPageIndex(IWizardPage page) {
        int idx = 0;
        while (idx < this.subsystemFactorySuppliedWizardPages.length) {
            if (page == this.subsystemFactorySuppliedWizardPages[idx]) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public boolean canFinish() {
        boolean ok = this.mainPage.isPageComplete();
        if (ok && this.hasAdditionalPages()) {
            int idx = 0;
            while (ok && idx < this.subsystemFactorySuppliedWizardPages.length) {
                ok = this.subsystemFactorySuppliedWizardPages[idx].isPageComplete();
                ++idx;
            }
        }
        return ok;
    }

    public void systemTypeChanged(IRSESystemType systemType) {
        this.setSystemType(systemType);
        this.restrictSystemType(systemType.getName());
        this.getMainPage().setTitle(this.getPageTitle());
        this.subsystemFactorySuppliedWizardPages = this.getAdditionalWizardPages(systemType.getName());
    }
}

