/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.rse.ui.wizards.IRSENewConnectionWizardDelegate;
import org.eclipse.rse.ui.wizards.ISystemNewConnectionWizardMainPage;
import org.eclipse.rse.ui.wizards.RSEDefaultNewConnectionWizardDelegate;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RSENewConnectionWizardDefaultDelegateMainPage
extends AbstractSystemWizardPage
implements ISystemNewConnectionWizardMainPage,
ISystemMessageLine,
ISystemConnectionFormCaller {
    protected String[] restrictSystemTypesTo;
    protected SystemConnectionForm form;
    protected String parentHelpId = "org.eclipse.rse.ui.wncc0000";
    protected RSEDefaultNewConnectionWizardDelegate delegate;

    public RSENewConnectionWizardDefaultDelegateMainPage(Wizard wizard, String title, String description) {
        super((IWizard)wizard, "NewConnection", title, description);
        this.setHelp(this.parentHelpId);
        this.delegate = this.delegate;
        this.form = this.getForm();
    }

    public void restrictSystemType(String systemType) {
        this.restrictSystemTypesTo = new String[1];
        this.restrictSystemTypesTo[0] = systemType;
        this.form.restrictSystemTypes(this.restrictSystemTypesTo);
    }

    public void restrictSystemTypes(String[] systemTypes) {
        this.restrictSystemTypesTo = systemTypes;
        this.form.restrictSystemTypes(this.restrictSystemTypesTo);
    }

    private RSEDefaultNewConnectionWizardDelegate getOurWizardDelegate() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof RSENewConnectionWizard) {
            IRSENewConnectionWizardDelegate delegate = ((RSENewConnectionWizard)wizard).getDelegate();
            if (delegate instanceof RSEDefaultNewConnectionWizardDelegate) {
                return (RSEDefaultNewConnectionWizardDelegate)delegate;
            }
            return null;
        }
        return null;
    }

    protected SystemConnectionForm getForm() {
        if (this.form == null) {
            this.form = new SystemConnectionForm(this, this);
        }
        return this.form;
    }

    public void setConnectionNameValidators(ISystemValidator[] v) {
        this.form.setConnectionNameValidators(v);
    }

    public void setHostNameValidator(ISystemValidator v) {
        this.form.setHostNameValidator(v);
    }

    public void setUserIdValidator(ISystemValidator v) {
        this.form.setUserIdValidator(v);
    }

    public void setUserId(String userId) {
        this.form.setUserId(userId);
    }

    public void setProfileNames(String[] names) {
        this.form.setProfileNames(names);
    }

    public void setProfileNamePreSelection(String name) {
        this.form.setProfileNamePreSelection(name);
    }

    public void setCurrentlySelectedConnection(IHost connection) {
        this.form.setCurrentlySelectedConnection(connection);
    }

    public void setConnectionName(String name) {
        this.form.setConnectionName(name);
    }

    public void setHostName(String name) {
        this.form.setHostName(name);
    }

    public Control createContents(Composite parent) {
        return this.form.createContents(parent, false, this.parentHelpId);
    }

    protected Control getInitialFocusControl() {
        return this.form.getInitialFocusControl();
    }

    public boolean performFinish() {
        return this.form.verify(true);
    }

    public String getConnectionName() {
        return this.form.getConnectionName();
    }

    public String getHostName() {
        return this.form.getHostName();
    }

    public String getDefaultUserId() {
        return this.form.getDefaultUserId();
    }

    public int getDefaultUserIdLocation() {
        return this.form.getUserIdLocation();
    }

    public String getConnectionDescription() {
        return this.form.getConnectionDescription();
    }

    public String getProfileName() {
        return this.form.getProfileName();
    }

    public Object getLayoutData() {
        return null;
    }

    public void setLayoutData(Object gridData) {
    }

    public boolean isPageComplete() {
        if (this.form != null) {
            return this.form.isPageComplete() && this.form.isConnectionUnique();
        }
        return false;
    }

    public IWizardPage getNextPage() {
        RSEDefaultNewConnectionWizardDelegate newConnWizardDelegate = this.getOurWizardDelegate();
        if (newConnWizardDelegate != null) {
            return (IWizardPage)newConnWizardDelegate.getFirstAdditionalPage();
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        RSEDefaultNewConnectionWizardDelegate newConnWizardDelegate = this.getOurWizardDelegate();
        if (newConnWizardDelegate != null) {
            return this.isPageComplete() && newConnWizardDelegate.hasAdditionalPages() && this.form.isConnectionUnique();
        }
        return super.canFlipToNextPage();
    }

    public void systemTypeSelected(String systemType, boolean duringInitialization) {
        RSEDefaultNewConnectionWizardDelegate newConnWizardDelegate = this.getOurWizardDelegate();
        if (newConnWizardDelegate != null) {
            newConnWizardDelegate.systemTypeSelected(systemType, duringInitialization);
        }
    }

    public String getSystemType() {
        RSEDefaultNewConnectionWizardDelegate newConnWizardDelegate = this.getOurWizardDelegate();
        return newConnWizardDelegate.getSystemType().getName();
    }
}

