/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.widgets;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityPlugin;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.internal.dstore.security.util.GridUtil;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateForm
extends SystemBaseForm {
    private Text _pathField;
    private Text _aliasField;
    private String _aliasStr;
    private String _pathStr;
    private ArrayList listenerList = new ArrayList();
    private Button _browseButton;
    public Shell _shell;

    public CertificateForm(Shell shell, ISystemMessageLine msgLine) {
        super(shell, msgLine);
        this._shell = shell;
    }

    public Control getInitialFocusControl() {
        return this._pathField;
    }

    public Control createContents(Composite c) {
        Composite nameGroup = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData data = GridUtil.createFill();
        data.widthHint = 400;
        nameGroup.setLayoutData((Object)data);
        nameGroup.setLayout((Layout)layout);
        Label lblPath = new Label(nameGroup, 0);
        lblPath.setText(UniversalSecurityPlugin.getString(UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_FILE));
        this._pathField = new Text(nameGroup, 2048);
        this._pathField.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._pathField.setText("");
        this._browseButton = new Button(nameGroup, 8);
        this._browseButton.setText(UniversalSecurityPlugin.getString(UniversalSecurityProperties.RESID_SECURITY_BROWSE));
        this._browseButton.addListener(13, (Listener)this);
        Label lblName = new Label(nameGroup, 0);
        lblName.setText(UniversalSecurityPlugin.getString(UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_ALIAS));
        this._aliasField = new Text(nameGroup, 2048);
        this._aliasField.setText("");
        this._aliasField.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._aliasField.addListener(24, (Listener)this);
        this._pathField.addListener(24, (Listener)this);
        return this._pathField;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._browseButton) {
            this.showFileDialog();
            this.NotifyListeners(event);
        }
        if (event.widget == this._aliasField || event.widget == this._pathField) {
            this._pathStr = this._pathField.getText();
            this._aliasStr = this._aliasField.getText();
            this.NotifyListeners(event);
        }
    }

    public void NotifyListeners(Event event) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ((Listener)this.listenerList.get(i)).handleEvent(event);
            ++i;
        }
    }

    public boolean validateDialog() {
        return this._aliasField.getText().trim().length() > 0 && this._pathField.getText().trim().length() > 0;
    }

    private void showFileDialog() {
        String currentSource = this._pathField.getText();
        FileDialog dlg = new FileDialog(this._shell, 4096);
        dlg.setFileName(currentSource);
        dlg.setFilterExtensions(new String[]{"*.cer", "*.*"});
        String source = dlg.open();
        if (source != null) {
            this._pathField.setText(source);
            File f = new File(source);
            String alias = f.getName();
            int dotIndex = alias.indexOf(46);
            if (dotIndex > 0) {
                alias = alias.substring(0, dotIndex);
            }
            this._aliasField.setText(alias);
        }
    }

    public Certificate loadCertificate(KeyStore ks) throws IOException, CertificateException, KeyStoreException {
        Certificate fCertificate = DStoreKeyStore.loadCertificate((String)this.getPath());
        DStoreKeyStore.addCertificateToKeyStore((KeyStore)ks, (Certificate)fCertificate, (String)this.getAliasName());
        return fCertificate;
    }

    public void registerListener(Listener listener) {
        this.listenerList.add(listener);
    }

    public String getAliasName() {
        return this._aliasStr;
    }

    public String getPath() {
        return this._pathStr;
    }
}

