/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.ISystemAddFileListener;
import org.eclipse.rse.files.ui.dialogs.SystemSelectRemoteFileOrFolderDialog;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectRemoteFileAction
extends SystemBaseDialogAction {
    private IRSESystemType[] systemTypes;
    private IHost systemConnection;
    private IHost outputConnection;
    private IHost rootFolderConnection;
    private IRemoteFile preSelection;
    private String rootFolderAbsPath;
    private String fileTypes;
    private String message;
    private String treeTip;
    private String dlgTitle;
    private String addLabel;
    private String addToolTipText;
    private int expandDepth = 0;
    private boolean showNewConnectionPrompt = true;
    private boolean restrictFolders = false;
    private boolean showPropertySheet = false;
    private boolean showPropertySheetDetailsButtonInitialState;
    private boolean showPropertySheetDetailsButton = false;
    private boolean multipleSelectionMode = false;
    private boolean onlyConnection = false;
    private boolean allowFolderSelection = true;
    private ISystemAddFileListener addButtonCallback = null;
    private IValidatorRemoteSelection selectionValidator;
    private List viewerFilters = new ArrayList();

    public SystemSelectRemoteFileAction(Shell shell) {
        this(shell, FileResources.ACTION_SELECT_FILE_LABEL, FileResources.ACTION_SELECT_FILE_TOOLTIP);
    }

    public SystemSelectRemoteFileAction(Shell shell, String label, String tooltip) {
        super(label, tooltip, null, shell);
        super.setNeedsProgressMonitor(true);
    }

    public void setHost(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = true;
    }

    public void setDefaultConnection(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = false;
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(IRSESystemType systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new IRSESystemType[]{systemType});
        }
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public void setAutoExpandDepth(int depth) {
        this.expandDepth = depth;
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        this.rootFolderConnection = connection;
        this.rootFolderAbsPath = folderAbsolutePath;
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.setRootFolder(rootFolder.getSystemConnection(), rootFolder.getAbsolutePath());
    }

    public void setPreSelection(IRemoteFile selection) {
        this.preSelection = selection;
    }

    public void setFileTypes(String[] fileTypes) {
        this.fileTypes = fileTypes != null ? RemoteFileFilterString.getTypesString((String[])fileTypes) : null;
    }

    public void setFileTypes(String fileTypes) {
        this.fileTypes = fileTypes;
    }

    public void setRestrictFolders(boolean restrict) {
        this.restrictFolders = restrict;
    }

    public void enableAddMode(ISystemAddFileListener caller) {
        this.addButtonCallback = caller;
    }

    public void enableAddMode(ISystemAddFileListener caller, String addLabel, String addToolTipText) {
        this.enableAddMode(caller);
        this.addLabel = addLabel;
        this.addToolTipText = addToolTipText;
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        this.setShowPropertySheet(show);
        if (show) {
            this.showPropertySheetDetailsButton = true;
            this.showPropertySheetDetailsButtonInitialState = initialState;
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.treeTip = tip;
    }

    public IRemoteFile getSelectedFile() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return ((IRemoteFile[])o)[0];
        }
        if (o instanceof IRemoteFile) {
            return (IRemoteFile)o;
        }
        return null;
    }

    public IRemoteFile[] getSelectedFiles() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return (IRemoteFile[])o;
        }
        if (o instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)o};
        }
        return new IRemoteFile[0];
    }

    public Object[] getSelectedObjects() {
        Object remoteObject = this.getValue();
        if (remoteObject == null) {
            return null;
        }
        if (remoteObject instanceof Object[]) {
            return (Object[])remoteObject;
        }
        if (remoteObject instanceof IRemoteFile[]) {
            return (Object[])remoteObject;
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    protected Dialog createDialog(Shell shell) {
        SystemSelectRemoteFileOrFolderDialog dlg = null;
        dlg = this.dlgTitle == null ? new SystemSelectRemoteFileOrFolderDialog(shell, true) : new SystemSelectRemoteFileOrFolderDialog(shell, this.dlgTitle, true);
        dlg.setShowNewConnectionPrompt(this.showNewConnectionPrompt);
        dlg.setMultipleSelectionMode(this.multipleSelectionMode);
        if (this.restrictFolders) {
            dlg.setRestrictFolders(true);
        }
        if (this.message != null) {
            dlg.setMessage(this.message);
        }
        if (this.treeTip != null) {
            dlg.setSelectionTreeToolTipText(this.treeTip);
        }
        if (this.systemConnection != null) {
            if (this.onlyConnection) {
                dlg.setSystemConnection(this.systemConnection);
            } else {
                dlg.setDefaultConnection(this.systemConnection);
            }
        }
        if (this.systemTypes != null) {
            dlg.setSystemTypes(this.systemTypes);
        }
        if (this.expandDepth != 0) {
            dlg.setAutoExpandDepth(this.expandDepth);
        }
        if (this.fileTypes != null) {
            dlg.setFileTypes(this.fileTypes);
        }
        if (this.preSelection != null) {
            dlg.setPreSelection(this.preSelection);
        } else if (this.rootFolderConnection != null) {
            dlg.setRootFolder(this.rootFolderConnection, this.rootFolderAbsPath);
        }
        if (this.showPropertySheet) {
            if (this.showPropertySheetDetailsButton) {
                dlg.setShowPropertySheet(true, this.showPropertySheetDetailsButtonInitialState);
            } else {
                dlg.setShowPropertySheet(true);
            }
        }
        if (this.addButtonCallback != null) {
            if (this.addLabel != null || this.addToolTipText != null) {
                dlg.enableAddMode(this.addButtonCallback, this.addLabel, this.addToolTipText);
            } else {
                dlg.enableAddMode(this.addButtonCallback);
            }
        }
        if (this.selectionValidator != null) {
            dlg.setSelectionValidator(this.selectionValidator);
        }
        if (!this.allowFolderSelection) {
            dlg.setAllowFolderSelection(this.allowFolderSelection);
        }
        if (this.viewerFilters != null) {
            Iterator iter = this.viewerFilters.iterator();
            while (iter.hasNext()) {
                ViewerFilter filter = (ViewerFilter)iter.next();
                dlg.addViewerFilter(filter);
            }
        }
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemSelectRemoteFileOrFolderDialog ourDlg = (SystemSelectRemoteFileOrFolderDialog)dlg;
        Object outputObject = null;
        this.outputConnection = null;
        if (!ourDlg.wasCancelled()) {
            this.outputConnection = ourDlg.getSelectedConnection();
            outputObject = this.multipleSelectionMode ? ourDlg.getSelectedObjects() : ourDlg.getSelectedObject();
        }
        return outputObject;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.viewerFilters.add(filter);
    }

    public void setAllowFolderSelection(boolean allow) {
        this.allowFolderSelection = allow;
    }
}

