/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.internal.files.ui.actions.SystemEditFileAction;
import org.eclipse.rse.internal.files.ui.actions.SystemEditFilesAction;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemSeparatorAction;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemCreateEditActions {
    protected IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public void create(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (selection.size() <= 0) {
            return;
        }
        this.createForAnySelection(menu, selection, shell, menuGroup);
        if (selection.size() != 1) {
            return;
        }
        this.createForSingleSelection(menu, selection.getFirstElement(), shell, menuGroup);
    }

    public void createForAnySelection(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        String label = SystemResources.ACTION_CASCADING_OPEN_LABEL;
        String tooltip = SystemResources.ACTION_CASCADING_OPEN_TOOLTIP;
        SystemEditFilesAction action = new SystemEditFilesAction(label, tooltip, shell);
        menu.add("group.open", (IAction)action);
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    public void createForSingleSelection(SystemMenuManager menu, Object element, Shell shell, String menuGroup) {
        IRemoteFile remoteFile = null;
        if (element == null || !(element instanceof IRemoteFile)) {
            return;
        }
        remoteFile = (IRemoteFile)element;
        IEditorDescriptor defaultEditor = this.getDefaultTextEditor();
        IEditorDescriptor preferredEditor = this.getPreferredEditor(remoteFile);
        IEditorDescriptor[] editors = this.registry.getEditors(remoteFile.getName());
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createEditAction(menu, shell, remoteFile, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            SystemSeparatorAction sep = new SystemSeparatorAction(shell);
            menu.add("group.openwith", (IAction)sep);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createEditAction(menu, shell, remoteFile, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createEditAction(menu, shell, remoteFile, descriptor, preferredEditor);
    }

    private void createEditAction(SystemMenuManager menu, Shell shell, IRemoteFile remoteFile, IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        String editorId = descriptor.getId();
        String label = descriptor.getLabel();
        ImageDescriptor image = this.getImageDescriptor(remoteFile, descriptor);
        SystemEditFileAction action = new SystemEditFileAction(label, label, image, 8, shell, editorId);
        boolean isPreferred = preferredEditor != null && editorId.equals(preferredEditor.getId());
        action.setChecked(isPreferred);
        menu.add("group.openwith", (IAction)action);
    }

    private IEditorDescriptor getPreferredEditor(IRemoteFile remoteFile) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null) {
            return this.registry.getDefaultEditor(remoteFile.getName());
        }
        return IDE.getDefaultEditor((IFile)localFile);
    }

    private IFile getLocalResource(IRemoteFile remoteFile) {
        return (IFile)UniversalFileTransferUtility.getTempFileFor(remoteFile);
    }

    private ImageDescriptor getImageDescriptor(IRemoteFile remoteFile, IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(remoteFile.getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc != null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(remoteFile.getName());
        }
        return imageDesc;
    }
}

