/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.internal.services.files.ftp.FTPHostFile;
import org.eclipse.rse.internal.services.files.ftp.FTPServiceResources;
import org.eclipse.rse.internal.services.files.ftp.IFTPService;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigFactory;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigProxy;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileCancelledException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.services.files.RemoteFolderNotEmptyException;

public class FTPService
extends AbstractFileService
implements IFileService,
IFTPService {
    private FTPClient _ftpClient;
    private FTPFile[] _ftpFiles;
    private Mutex _commandMutex = new Mutex();
    private String _userHome;
    private transient String _hostName;
    private transient String _userId;
    private transient String _password;
    private transient int _portNumber;
    private OutputStream _ftpLoggingOutputStream;
    private IPropertySet _ftpPropertySet;
    private Exception _exception;
    private boolean _isBinaryFileType = true;
    private boolean _isPassiveDataConnectionMode = false;
    private IFTPClientConfigFactory _entryParserFactory;
    private IFTPClientConfigProxy _clientConfigProxy;

    public void setPropertySet(IPropertySet ftpPropertySet) {
        this._ftpPropertySet = ftpPropertySet;
    }

    public String getName() {
        return FTPServiceResources.FTP_File_Service_Name;
    }

    public String getDescription() {
        return FTPServiceResources.FTP_File_Service_Description;
    }

    public void setHostName(String hostname) {
        this._hostName = hostname;
    }

    public void setPortNumber(int portNumber) {
        this._portNumber = portNumber;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setLoggingStream(OutputStream ftpLoggingOutputStream) {
        this._ftpLoggingOutputStream = ftpLoggingOutputStream;
    }

    public void setFTPClientConfigFactory(IFTPClientConfigFactory entryParserFactory) {
        this._entryParserFactory = entryParserFactory;
    }

    public void connect() throws RemoteFileSecurityException, IOException {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
        }
        if (this._ftpLoggingOutputStream != null) {
            this._ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
        }
        if (this._portNumber == 0) {
            this._ftpClient.connect(this._hostName);
        } else {
            this._ftpClient.connect(this._hostName, this._portNumber);
        }
        int userReply = this._ftpClient.user(this._userId);
        if (FTPReply.isPositiveIntermediate((int)userReply)) {
            String newLine = System.getProperty("line.separator");
            this._ftpClient.registerSpyStream(null);
            this._ftpLoggingOutputStream.write(("PASS ******" + newLine).getBytes());
            int passReply = this._ftpClient.pass(this._password);
            this._ftpLoggingOutputStream.write((String.valueOf(this._ftpClient.getReplyString()) + newLine).getBytes());
            if (this._ftpLoggingOutputStream != null) {
                this._ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
            }
            if (!FTPReply.isPositiveCompletion((int)passReply)) {
                String lastMessage = this._ftpClient.getReplyString();
                this.disconnect();
                throw new RemoteFileSecurityException(new Exception(lastMessage));
            }
        } else if (!FTPReply.isPositiveCompletion((int)userReply)) {
            String lastMessage = this._ftpClient.getReplyString();
            this.disconnect();
            throw new RemoteFileSecurityException(new Exception(lastMessage));
        }
        String systemName = this._ftpClient.getSystemName();
        this._ftpClient.setParserFactory((FTPFileEntryParserFactory)this._entryParserFactory);
        this._clientConfigProxy = this._entryParserFactory.getFTPClientConfig(this._ftpPropertySet.getPropertyValue("parser"), systemName);
        if (this._clientConfigProxy != null) {
            this._ftpClient.configure(this._clientConfigProxy.getFTPClientConfig());
        } else {
            this._ftpClient.configure(new FTPClientConfig("UNIX"));
        }
        if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true")) {
            this._ftpClient.enterLocalPassiveMode();
            this._isPassiveDataConnectionMode = true;
        } else {
            this._ftpClient.enterLocalActiveMode();
            this._isPassiveDataConnectionMode = false;
        }
        this._ftpClient.setFileType(2);
        this._isBinaryFileType = true;
        this._userHome = this._ftpClient.printWorkingDirectory();
        if (this._userHome.indexOf(58) != -1 && this._userHome.indexOf(93) != -1) {
            this._userHome = this._userHome.replaceAll(":\\[", "/");
            this._userHome = String.valueOf('/') + this._userHome.substring(0, this._userHome.lastIndexOf(93));
        }
    }

    public void disconnect() {
        try {
            this.getFTPClient().logout();
            this._ftpClient = null;
        }
        catch (IOException iOException) {
            this._ftpClient = null;
        }
    }

    public FTPClient getFTPClient() {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
        }
        if (this._hostName != null) {
            try {
                this._ftpClient.sendNoOp();
            }
            catch (IOException iOException) {
                try {
                    this.connect();
                }
                catch (Exception exception) {}
            }
        }
        this.setDataConnectionMode();
        return this._ftpClient;
    }

    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        FTPHostFile file = null;
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    this._ftpClient = this.getFTPClient();
                    if (!this._ftpClient.changeWorkingDirectory(remoteParent)) {
                        throw new RemoteFileIOException(new Exception(this._ftpClient.getReplyString()));
                    }
                    if (!this.listFiles(monitor)) {
                        throw new RemoteFileCancelledException();
                    }
                    int i = 0;
                    while (i < this._ftpFiles.length) {
                        FTPHostFile tempFile = new FTPHostFile(remoteParent, this._ftpFiles[i]);
                        if (tempFile.getName().equalsIgnoreCase(fileName)) {
                            file = tempFile;
                            break;
                        }
                        ++i;
                    }
                    if (file == null) {
                        file = new FTPHostFile(remoteParent, fileName, false, false, 0L, 0L, false);
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return file;
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this._ftpClient != null) {
            isConnected = this._ftpClient.isConnected();
        }
        return isConnected;
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        ArrayList<FTPHostFile> results = new ArrayList<FTPHostFile>();
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    if (fileFilter == null) {
                        fileFilter = "*";
                    }
                    NamePatternMatcher filematcher = null;
                    if (fileFilter.endsWith(",")) {
                        String[] types = fileFilter.split(",");
                        filematcher = new FileTypeMatcher(types, true);
                    } else {
                        filematcher = new NamePatternMatcher(fileFilter, true, true);
                    }
                    this._ftpClient = this.getFTPClient();
                    if (!this._ftpClient.changeWorkingDirectory(parentPath)) {
                        throw new RemoteFileIOException(new Exception(this._ftpClient.getReplyString()));
                    }
                    if (!this.listFiles(monitor)) {
                        throw new RemoteFileCancelledException();
                    }
                    int i = 0;
                    while (i < this._ftpFiles.length) {
                        FTPHostFile f = new FTPHostFile(parentPath, this._ftpFiles[i]);
                        if ((filematcher.matches(f.getName()) || f.isDirectory()) && !f.getName().equals(".") && !f.getName().equals("..")) {
                            results.add(f);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private char getSeparator() {
        int separator = 47;
        if (this._userHome.indexOf(92) != -1 && this._userHome.indexOf(47) == -1) {
            separator = 92;
        }
        return (char)separator;
    }

    public boolean upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue = true;
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    int readCount;
                    MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
                    FTPClient ftpClient = this.getFTPClient();
                    ftpClient.changeWorkingDirectory(remoteParent);
                    this.setFileType(isBinary);
                    FileInputStream input = new FileInputStream(localFile);
                    OutputStream output = ftpClient.storeFileStream(remoteFile);
                    progressMonitor.init(0, localFile.getName(), remoteFile, localFile.length());
                    long bytes = 0L;
                    byte[] buffer = new byte[4096];
                    while ((readCount = input.read(buffer)) > 0) {
                        bytes += (long)readCount;
                        output.write(buffer, 0, readCount);
                        progressMonitor.count(readCount);
                        if (monitor == null || !monitor.isCanceled()) continue;
                        retValue = false;
                        break;
                    }
                    input.close();
                    output.flush();
                    output.close();
                    ftpClient.completePendingCommand();
                    if (!retValue) {
                        ftpClient.deleteFile(remoteFile);
                    }
                    progressMonitor.end();
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return retValue;
    }

    public boolean upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue = true;
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("ftpup", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                retValue = false;
                break;
            }
            bos.close();
            if (retValue) {
                this.setFileType(isBinary);
                retValue = this.upload(tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding, monitor);
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return retValue;
    }

    public boolean download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue = true;
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        IHostFile remoteHostFile = this.getFile(remoteParent, remoteFile, null);
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
                    FileOutputStream output = null;
                    InputStream input = null;
                    ftpClient.changeWorkingDirectory(remoteParent);
                    this.setFileType(isBinary);
                    if (!localFile.exists()) {
                        File localParentFile = localFile.getParentFile();
                        if (!localParentFile.exists()) {
                            localParentFile.mkdirs();
                        }
                        localFile.createNewFile();
                    }
                    output = new FileOutputStream(localFile);
                    input = ftpClient.retrieveFileStream(remoteFile);
                    if (remoteHostFile != null && input != null) {
                        int readCount;
                        progressMonitor.init(0, remoteFile, localFile.getName(), remoteHostFile.getSize());
                        byte[] buffer = new byte[4096];
                        while ((readCount = input.read(buffer)) > 0) {
                            ((OutputStream)output).write(buffer, 0, readCount);
                            progressMonitor.count(readCount);
                            if (monitor == null || !monitor.isCanceled()) continue;
                            retValue = false;
                            break;
                        }
                        progressMonitor.end();
                        output.flush();
                        input.close();
                        ((OutputStream)output).close();
                        ftpClient.completePendingCommand();
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return retValue;
    }

    public IHostFile getUserHome() {
        return new FTPHostFile("", this._userHome, true, true, 0L, 0L, true);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        IHostFile[] hostFile = this._userHome.startsWith("/") ? new IHostFile[]{new FTPHostFile(null, "/", true, true, 0L, 0L, true)} : new IHostFile[]{new FTPHostFile(null, this._userHome, true, true, 0L, 0L, true)};
        return hostFile;
    }

    public boolean delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        boolean hasSucceeded = false;
        FTPClient ftpClient = this.getFTPClient();
        MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
        progressMonitor.init(String.valueOf(FTPServiceResources.FTP_File_Service_Deleting_Task) + fileName, 1);
        boolean isFile = this.getFile(remoteParent, fileName, null).isFile();
        try {
            hasSucceeded = FTPReply.isPositiveCompletion((int)ftpClient.cwd(remoteParent));
            if (hasSucceeded) {
                hasSucceeded = isFile ? ftpClient.deleteFile(fileName) : ftpClient.removeDirectory(fileName);
            }
            if (!hasSucceeded) {
                throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + fileName + ")");
            }
            progressMonitor.worked(1);
        }
        catch (Exception e) {
            if (isFile) {
                throw new RemoteFileIOException(e);
            }
            throw new RemoteFolderNotEmptyException(e);
        }
        return hasSucceeded;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        boolean success = false;
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    if (!ftpClient.changeWorkingDirectory(remoteParent)) {
                        throw new RemoteFileIOException(new Exception(ftpClient.getReplyString()));
                    }
                    String source = remoteParent.endsWith(String.valueOf(this.getSeparator())) ? String.valueOf(remoteParent) + oldName : String.valueOf(remoteParent) + this.getSeparator() + oldName;
                    success = ftpClient.rename(source, newName);
                    if (!success) {
                        throw new Exception(ftpClient.getReplyString());
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return success;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) {
        boolean hasSucceeded = false;
        oldFile.renameTo(newName);
        return hasSucceeded;
    }

    public boolean move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        boolean success = false;
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    String source = srcParent.endsWith(String.valueOf(this.getSeparator())) ? String.valueOf(srcParent) + srcName : String.valueOf(srcParent) + this.getSeparator() + srcName;
                    String target = tgtParent.endsWith(String.valueOf(this.getSeparator())) ? String.valueOf(tgtParent) + tgtName : String.valueOf(tgtParent) + this.getSeparator() + tgtName;
                    success = ftpClient.rename(source, target);
                    if (!success) {
                        throw new Exception(ftpClient.getReplyString());
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return success;
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    if (!ftpClient.changeWorkingDirectory(remoteParent)) {
                        throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + remoteParent + ")");
                    }
                    if (!ftpClient.makeDirectory(folderName)) {
                        throw new RemoteFileIOException(new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + folderName + ")"));
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileSecurityException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return this.getFile(remoteParent, folderName, monitor);
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        try {
            File tempFile = File.createTempFile("ftp", "temp");
            tempFile.deleteOnExit();
            boolean success = this.upload(tempFile, remoteParent, fileName, this._isBinaryFileType, null, null, monitor);
            if (!success) {
                throw new RemoteFileIOException(new Exception(this.getFTPClient().getReplyString()));
            }
        }
        catch (Exception e) {
            throw new RemoteFileSecurityException(e);
        }
        return this.getFile(remoteParent, fileName, monitor);
    }

    public boolean copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        throw new RemoteFileIOException(new Exception(FTPServiceResources.FTP_File_Service_Copy_Not_Supported));
    }

    public boolean copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        boolean hasSucceeded = false;
        int i = 0;
        while (i < srcNames.length) {
            hasSucceeded = this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            if (!hasSucceeded) break;
            ++i;
        }
        return hasSucceeded;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean listFiles(IProgressMonitor monitor) throws Exception {
        boolean result = true;
        this._exception = null;
        Thread listThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FTPService.this._ftpFiles = null;
                    if (FTPService.this._clientConfigProxy != null) {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles(FTPService.this._clientConfigProxy.getListCommandModifiers());
                    } else {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles();
                    }
                }
                catch (IOException e) {
                    FTPService.this._exception = e;
                }
            }
        });
        if (monitor == null) {
            listThread.start();
            listThread.join();
            if (this._exception == null) return result;
            throw new RemoteFileIOException(this._exception);
        }
        if (monitor.isCanceled()) return false;
        listThread.start();
        while (!monitor.isCanceled() && listThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!monitor.isCanceled()) return result;
        if (!listThread.isAlive()) return result;
        Thread killThread = listThread;
        listThread = null;
        killThread.interrupt();
        this._ftpClient.completePendingCommand();
        throw new RemoteFileIOException(this._exception);
    }

    public boolean setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        return false;
    }

    public boolean setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        boolean result = false;
        int permissions = 0;
        FTPHostFile file = (FTPHostFile)this.getFile(parent, name, monitor);
        int userPermissions = file.getUserPermissions();
        int groupPermissions = file.getGroupPermissions();
        int otherPermissions = file.getOtherPermissions();
        userPermissions = readOnly ? (userPermissions &= 5) : (userPermissions |= 2);
        permissions = userPermissions * 100 + groupPermissions * 10 + otherPermissions;
        try {
            result = this._ftpClient.sendSiteCommand("CHMOD " + permissions + " " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        FTPClient ftpClient = this.getFTPClient();
        FTPBufferedInputStream stream = null;
        try {
            this.setFileType(isBinary);
            stream = new FTPBufferedInputStream(ftpClient.retrieveFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        FTPClient ftpClient = this.getFTPClient();
        FTPBufferedOutputStream stream = null;
        try {
            ftpClient.changeWorkingDirectory(remoteParent);
            this.setFileType(isBinary);
            stream = new FTPBufferedOutputStream(ftpClient.storeFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    private void setDataConnectionMode() {
        if (this._ftpPropertySet != null) {
            if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true") && !this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalPassiveMode();
                this._isPassiveDataConnectionMode = true;
            } else if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("false") && this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalActiveMode();
                this._isPassiveDataConnectionMode = false;
            }
        }
    }

    private void setFileType(boolean isBinaryFileType) throws IOException {
        if (!isBinaryFileType && this._isBinaryFileType) {
            this._ftpClient.setFileType(0);
            this._isBinaryFileType = isBinaryFileType;
        } else if (isBinaryFileType && !this._isBinaryFileType) {
            this._ftpClient.setFileType(2);
            this._isBinaryFileType = isBinaryFileType;
        }
    }

    private class FTPBufferedInputStream
    extends BufferedInputStream {
        private FTPClient client;

        public FTPBufferedInputStream(InputStream in, FTPClient client) {
            super(in);
            this.client = client;
        }

        public FTPBufferedInputStream(InputStream in, int size, FTPClient client) {
            super(in, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
        }
    }

    private class FTPBufferedOutputStream
    extends BufferedOutputStream {
        private FTPClient client;

        public FTPBufferedOutputStream(OutputStream out, FTPClient client) {
            super(out);
            this.client = client;
        }

        public FTPBufferedOutputStream(OutputStream out, int size, FTPClient client) {
            super(out, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
        }
    }

    private class MyProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public void init(String label, int max) {
            this.fMonitor.beginTask(label, max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(FTPServiceResources.FTP_File_Service_Monitor_Format, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void worked(int work) {
            this.fMonitor.worked(work);
        }

        public void end() {
            this.fMonitor.done();
        }
    }
}

