/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.util;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorFileFilterString
extends ValidatorUniqueString {
    protected SystemMessage msg_Invalid;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();
    protected boolean isFileName;
    protected boolean isFolderName;
    private ValidatorFileName fileNameValidator;
    private ValidatorFolderName folderNameValidator;
    private IRemoteFileSubSystemConfiguration ssConfiguration;

    public ValidatorFileFilterString(IRemoteFileSubSystemConfiguration ssConfig, Vector existingList) {
        super((Collection)existingList, ssConfig.isCaseSensitive());
        this.ssConfiguration = ssConfig;
        this.init();
    }

    public ValidatorFileFilterString(IRemoteFileSubSystemConfiguration ssConfig, String[] existingList) {
        super(existingList, ssConfig.isCaseSensitive());
        this.ssConfiguration = ssConfig;
        this.init();
    }

    public ValidatorFileFilterString(IRemoteFileSubSystemConfiguration ssConfig) {
        super(new String[0], ssConfig.isCaseSensitive());
        this.ssConfiguration = ssConfig;
        this.init();
    }

    private void init() {
        this.setErrorMessages(RSEUIPlugin.getPluginMessage((String)"RSEG1006"), RSEUIPlugin.getPluginMessage((String)"RSEF1007"), RSEUIPlugin.getPluginMessage((String)"RSEF1008"));
        this.isFolderName = true;
        this.isFileName = true;
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    public void setIsFileName(boolean is) {
        this.isFileName = is;
    }

    public void setIsFolderName(boolean is) {
        this.isFolderName = is;
    }

    public SystemMessage isSyntaxOk(String newText) {
        boolean ok = NamePatternMatcher.verifyPattern((String)newText, (boolean)true);
        if (!ok) {
            return this.msg_Invalid;
        }
        String tempText = newText;
        if (this.isFileName || this.isFolderName) {
            tempText = newText.replace('*', 'A');
        }
        if (this.isFileName) {
            return this.getFileNameValidator().isSyntaxOk(tempText);
        }
        if (this.isFolderName) {
            return this.getFolderNameValidator().isSyntaxOk(tempText);
        }
        return null;
    }

    protected ValidatorFileName getFileNameValidator() {
        if (this.fileNameValidator == null) {
            this.fileNameValidator = this.ssConfiguration.getFileNameValidator();
        }
        return this.fileNameValidator;
    }

    protected ValidatorFolderName getFolderNameValidator() {
        if (this.folderNameValidator == null) {
            this.folderNameValidator = this.ssConfiguration.getFolderNameValidator();
        }
        return this.folderNameValidator;
    }

    protected boolean isCaseSensitive(IRemoteFileSubSystemConfiguration ssConfig) {
        return ssConfig.isUnixStyle();
    }

    public int getMaximumNameLength() {
        return -1;
    }

    public String toString() {
        return "ValidatorFileFilterString class";
    }
}

