/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.ftp.connectorservice;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.services.files.ftp.FTPService;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigFactory;
import org.eclipse.rse.internal.subsystems.files.ftp.FTPSubsystemResources;
import org.eclipse.rse.internal.subsystems.files.ftp.parser.FTPClientConfigFactory;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class FTPConnectorService
extends StandardConnectorService {
    protected FTPService _ftpService = new FTPService();
    private IPropertySet _propertySet = this.getPropertySet("FTP Settings");

    public FTPConnectorService(IHost host, int port) {
        super(FTPSubsystemResources.RESID_FTP_CONNECTORSERVICE_NAME, FTPSubsystemResources.RESID_FTP_CONNECTORSERVICE_DESCRIPTION, host, port);
        if (this._propertySet == null) {
            this._propertySet = this.createPropertySet("FTP Settings");
            this._propertySet.addProperty("passive", "false", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            String[] keys = FTPClientConfigFactory.getParserFactory().getKeySet();
            Object[] keysArray = new String[keys.length + 1];
            System.arraycopy(keys, 0, keysArray, 0, keys.length);
            keysArray[keysArray.length - 1] = "AUTO";
            Arrays.sort(keysArray);
            this._propertySet.addProperty("parser", "AUTO", PropertyType.getEnumPropertyType((String[])keysArray));
        }
        if (this._propertySet instanceof ILabeledObject) {
            String label = FTPSubsystemResources.RESID_FTP_SETTINGS_LABEL;
            ((ILabeledObject)this._propertySet).setLabel(label);
        }
    }

    protected void internalConnect(IProgressMonitor monitor) throws RemoteFileException, IOException {
        this.internalConnect();
    }

    private void internalConnect() throws RemoteFileException, IOException {
        SystemSignonInformation info = this.getSignonInformation();
        this._ftpService.setHostName(info.getHostname());
        this._ftpService.setUserId(info.getUserId());
        this._ftpService.setPassword(info.getPassword());
        this._ftpService.setPortNumber(this.getPort());
        this._ftpService.setLoggingStream(this.getLoggingStream(info.getHostname(), this.getPort()));
        this._ftpService.setPropertySet(this._propertySet);
        this._ftpService.setFTPClientConfigFactory((IFTPClientConfigFactory)FTPClientConfigFactory.getParserFactory());
        this._ftpService.connect();
    }

    private OutputStream getLoggingStream(String hostName, int portNumber) {
        MessageConsole messageConsole = null;
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i].getName().equals("FTP log: " + hostName + ":" + portNumber)) {
                messageConsole = (MessageConsole)consoles[i];
                break;
            }
            ++i;
        }
        if (messageConsole == null) {
            messageConsole = new MessageConsole("FTP log: " + hostName + ":" + portNumber, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        }
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(messageConsole);
        return messageConsole.newOutputStream();
    }

    public IFileService getFileService() {
        return this._ftpService;
    }

    protected void internalDisconnect(IProgressMonitor monitor) {
        this._ftpService.disconnect();
    }

    public boolean isConnected() {
        return this._ftpService != null && this._ftpService.isConnected();
    }
}

