/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.local;

import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.search.AbstractSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;

public class LocalSearchResultConfiguration
extends AbstractSearchResultConfiguration {
    protected IHostFileToRemoteFileAdapter _fileAdapter;
    protected IRemoteFile _searchObject;
    protected FileServiceSubSystem _fileSubSystem;

    public LocalSearchResultConfiguration(IHostSearchResultSet resultSet, Object searchObject, SystemSearchString string, ISearchService searchService) {
        super(resultSet, searchObject, string, searchService);
        if (searchObject instanceof IRemoteFile) {
            this._searchObject = (IRemoteFile)searchObject;
            this._fileSubSystem = (FileServiceSubSystem)this._searchObject.getParentRemoteFileSubSystem();
            this._fileAdapter = this._fileSubSystem.getHostFileToRemoteFileAdapter();
        }
    }

    public Object[] getResults() {
        Object[] results = super.getResults();
        Object[] convertedResults = new IRemoteFile[results.length];
        int i = 0;
        while (i < results.length) {
            IHostFile fileNode = (IHostFile)results[i];
            if (fileNode != null) {
                IRemoteFile remoteFile = this._fileAdapter.convertToRemoteFile(this._fileSubSystem, this._fileSubSystem.getContextFor(this._searchObject), null, fileNode);
                Object[] contained = this.getContainedResults(fileNode);
                if (contained != null) {
                    int c = 0;
                    while (c < contained.length) {
                        contained[c].setParent((Object)remoteFile);
                        ++c;
                    }
                    remoteFile.setContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), this.getSearchString().getTextString(), contained);
                }
                convertedResults[i] = remoteFile;
            }
            ++i;
        }
        return convertedResults;
    }

    public void cancel() {
        if (this.getStatus() != 0) {
            super.cancel();
            return;
        }
        this.getSearchService().cancelSearch((IHostSearchResultConfiguration)this, null);
    }

    public Object getSearchTarget() {
        try {
            return this._fileSubSystem.getFileService().getFile(this._searchObject.getParentPath(), this._searchObject.getName(), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileServiceSubSystem getFileServiceSubSystem() {
        return this._fileSubSystem;
    }
}

