/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.UpAction;

public class SystemCascadingGoToAction
extends SystemBaseSubMenuAction {
    private boolean actionsMade = false;
    private SystemViewPart fSystemViewPart;
    private BackAction backAction;
    private ForwardAction forwardAction;
    private UpAction upAction;

    public SystemCascadingGoToAction(Shell shell, SystemViewPart systemViewPart) {
        super(SystemResources.ACTION_CASCADING_GOTO_LABEL, SystemResources.ACTION_CASCADING_GOTO_TOOLTIP, shell);
        this.setMenuID("menu.goto");
        this.fSystemViewPart = systemViewPart;
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(false);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.goto");
    }

    public IMenuManager populateSubMenu(IMenuManager gotoMenu) {
        if (!this.actionsMade) {
            this.makeActions();
        }
        gotoMenu.add((IAction)this.backAction);
        gotoMenu.add((IAction)this.forwardAction);
        gotoMenu.add((IAction)this.upAction);
        return gotoMenu;
    }

    protected void makeActions() {
        FrameList frameList = this.fSystemViewPart.getFrameList();
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
        this.actionsMade = true;
    }
}

