/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemAbstractAPIProvider;

public abstract class SystemResourceSelectionInputProvider
extends SystemAbstractAPIProvider {
    private IHost _connection;
    private boolean _onlyConnection = false;
    private boolean _allowNew = true;
    private IRSESystemType[] _systemTypes;
    private String _category = null;

    public SystemResourceSelectionInputProvider(IHost connection) {
        this._connection = connection;
    }

    public SystemResourceSelectionInputProvider() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IHost[] hosts = registry.getHosts();
        if (hosts != null) {
            this._connection = hosts[0];
        }
    }

    public IHost getSystemConnection() {
        return this._connection;
    }

    public boolean allowMultipleConnections() {
        return !this._onlyConnection;
    }

    public void setAllowNewConnection(boolean flag) {
        this._allowNew = flag;
    }

    public boolean allowNewConnection() {
        return this._allowNew;
    }

    public void setSystemConnection(IHost connection, boolean onlyConnection) {
        this._connection = connection;
        this._onlyConnection = onlyConnection;
    }

    public IRSESystemType[] getSystemTypes() {
        return this._systemTypes;
    }

    public void setSystemTypes(IRSESystemType[] types) {
        this._systemTypes = types;
    }

    public Object[] getSystemViewRoots() {
        if (this._connection == null) {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            this._connection = registry.getHosts()[0];
        }
        return this.getConnectionChildren(this._connection);
    }

    public boolean hasSystemViewRoots() {
        return false;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        if (selectedConnection != null) {
            return this.getSubSystem(selectedConnection).getChildren();
        }
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        if (selectedConnection != null) {
            return this.getSubSystem(selectedConnection).hasChildren();
        }
        return false;
    }

    protected abstract ISubSystem getSubSystem(IHost var1);

    public void setCategory(String category) {
        this._category = category;
    }

    public String getCategory() {
        return this._category;
    }
}

