/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IRemoteObjectIdentifier;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonSelectAllAction;
import org.eclipse.rse.internal.ui.actions.SystemOpenExplorerPerspectiveAction;
import org.eclipse.rse.internal.ui.actions.SystemShowInTableAction;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.internal.ui.view.SystemInheritableTextCellEditor;
import org.eclipse.rse.internal.ui.view.SystemTableTreeViewProvider;
import org.eclipse.rse.internal.ui.view.SystemTableViewColumnManager;
import org.eclipse.rse.internal.ui.view.SystemTableViewFilter;
import org.eclipse.rse.internal.ui.view.SystemTableViewSorter;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewDataDragAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewDataDropAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemSelectAllTarget;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTableTreeView
extends TreeViewer
implements IMenuListener,
ISystemDeleteTarget,
ISystemRenameTarget,
ISystemSelectAllTarget,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
ISystemShellProvider,
ISelectionChangedListener,
ISelectionProvider {
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            ISystemViewElementAdapter adapter = SystemTableTreeView.this.getViewAdapter(element);
            adapter.setPropertySourceInput(element);
            Object value = adapter.getPropertyValue(property);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = true;
            return modifiable;
        }

        public void modify(Object element, String property, Object value) {
            Object obj;
            ISystemViewElementAdapter adapter;
            if (element instanceof TableItem && value != null && (adapter = SystemTableTreeView.this.getViewAdapter(obj = ((TableItem)element).getData())) != null) {
                adapter.setPropertyValue(property, value);
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)SystemTableTreeView.this, SystemTableTreeView.this.getSelection());
                SystemTableTreeView.this.fireSelectionChanged(event);
            }
        }
    };
    private Object _objectInput;
    private TableLayout _layout;
    protected SystemTableTreeViewProvider _provider;
    private HeaderSelectionListener _columnSelectionListener;
    private SystemTableViewColumnManager _columnManager;
    private MenuManager _menuManager;
    private int _charWidth = 3;
    private SystemTableViewFilter _filter;
    private IPropertyDescriptor[] _uniqueDescriptors;
    protected SystemRefreshAction _refreshAction;
    protected PropertyDialogAction _propertyDialogAction;
    protected SystemOpenExplorerPerspectiveAction _openToPerspectiveAction;
    protected SystemShowInTableAction _showInTableAction;
    protected SystemCommonDeleteAction _deleteAction;
    protected SystemCommonRenameAction _renameAction;
    protected SystemCommonSelectAllAction _selectAllAction;
    protected boolean _selectionShowRefreshAction;
    protected boolean _selectionShowOpenViewActions;
    protected boolean _selectionShowDeleteAction;
    protected boolean _selectionShowRenameAction;
    protected boolean _selectionEnableDeleteAction;
    protected boolean _selectionEnableRenameAction;
    protected boolean _selectionIsRemoteObject = true;
    protected boolean _selectionFlagsUpdated = false;
    private int[] _lastWidths = null;
    private ISystemMessageLine _messageLine;
    protected boolean menuListenerAdded = false;
    private static final int LEFT_BUTTON = 1;
    private int mouseButtonPressed = 1;
    private Image _upI;
    private Image _downI;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected Composite getTableTree() {
        return this.getTree();
    }

    public SystemTableTreeView(Tree tableTree, ISystemMessageLine msgLine) {
        super(tableTree);
        this._messageLine = msgLine;
        this._layout = new TableLayout();
        this._columnManager = new SystemTableViewColumnManager((Viewer)this);
        this._provider = new SystemTableTreeViewProvider(this._columnManager);
        this._columnSelectionListener = new HeaderSelectionListener();
        this.setContentProvider((IContentProvider)this._provider);
        this.setLabelProvider((IBaseLabelProvider)this._provider);
        this._filter = new SystemTableViewFilter();
        this.addFilter(this._filter);
        this._charWidth = tableTree.getFont().getFontData()[0].getHeight() / 2;
        this.computeLayout();
        this._menuManager = new MenuManager("#PopupMenu");
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener((IMenuListener)this);
        Menu menu = this._menuManager.createContextMenu((Control)tableTree);
        tableTree.setMenu(menu);
        this.addSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.addSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        this.initDragAndDrop();
        tableTree.setVisible(false);
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemTableTreeView.this.handleKeyPressed(e);
            }
        });
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemTableTreeView.this.mouseButtonPressed = e.button;
            }
        });
    }

    public Layout getLayout() {
        return this._layout;
    }

    public void setViewFilters(String[] filter) {
        if (this._filter.getFilters() != filter) {
            this._filter.setFilters(filter);
            this.refresh();
        }
    }

    public String[] getViewFilters() {
        return this._filter.getFilters();
    }

    public Menu getContextMenu() {
        return this.getTableTree().getMenu();
    }

    public MenuManager getContextMenuManager() {
        return this._menuManager;
    }

    public void inputChanged(Object newObject, Object oldObject) {
        if (newObject instanceof IAdaptable) {
            this.getTableTree().setVisible(true);
            this._objectInput = newObject;
            SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
            provider.getChildren(this._objectInput);
            this.computeLayout();
            this.setViewFilters(null);
            super.inputChanged(newObject, oldObject);
        } else if (newObject == null) {
            this.getTableTree().setVisible(false);
            this._objectInput = null;
            this.computeLayout();
            this.setViewFilters(null);
        }
    }

    public Object getInput() {
        return this._objectInput;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object obj) {
        return SystemAdapterHelpers.getViewAdapter(obj, (Viewer)this);
    }

    public SystemTableViewColumnManager getColumnManager() {
        return this._columnManager;
    }

    private IPropertyDescriptor[] getCustomDescriptors(ISystemViewElementAdapter adapter) {
        return this._columnManager.getVisibleDescriptors(adapter);
    }

    public IPropertyDescriptor[] getUniqueDescriptors() {
        return this._uniqueDescriptors;
    }

    public IPropertyDescriptor[] getVisibleDescriptors(Object object) {
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(object);
        return this.getVisibleDescriptors(children);
    }

    private IPropertyDescriptor[] getVisibleDescriptors(Object[] children) {
        if (children != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            ISystemViewElementAdapter adapter = this.getViewAdapter(child);
            adapter.setPropertySourceInput(child);
            return this.getCustomDescriptors(adapter);
        }
        return new IPropertyDescriptor[0];
    }

    public IPropertyDescriptor getNameDescriptor(Object object) {
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(object);
        return this.getNameDescriptor(children);
    }

    private IPropertyDescriptor getNameDescriptor(Object[] children) {
        if (children != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            return this.getViewAdapter(child).getPropertyDescriptors()[0];
        }
        return null;
    }

    private ArrayList getFormatsIn() {
        ArrayList results = new ArrayList();
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(this._objectInput);
        if (children != null && children.length > 0) {
            Object adapter;
            IAdaptable child = (IAdaptable)children[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = child.getAdapter((Class)clazz)) instanceof ISystemViewElementAdapter) {
                ISystemViewElementAdapter ad = (ISystemViewElementAdapter)adapter;
                ad.setPropertySourceInput(child);
                IPropertyDescriptor[] descriptors = ad.getUniquePropertyDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    IPropertyDescriptor descriptor = descriptors[i];
                    try {
                        Object key = descriptor.getId();
                        Object propertyValue = ad.getPropertyValue(key, false);
                        results.add(propertyValue.getClass());
                    }
                    catch (Exception exception) {
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        results.add(clazz2);
                    }
                    ++i;
                }
            }
        }
        return results;
    }

    protected void computeLayout() {
        this.computeLayout(false);
    }

    private boolean sameDescriptors(IPropertyDescriptor[] descriptors1, IPropertyDescriptor[] descriptors2) {
        if (descriptors1 == null || descriptors2 == null) {
            return false;
        }
        if (descriptors1.length == descriptors2.length) {
            boolean same = true;
            int i = 0;
            while (i < descriptors1.length && same) {
                same = descriptors1[i] == descriptors2[i];
                ++i;
            }
            return same;
        }
        return false;
    }

    private CellEditor getCellEditor(Tree parent, IPropertyDescriptor descriptor) {
        CellEditor editor = descriptor.createPropertyEditor((Composite)parent);
        if (editor instanceof SystemInheritableTextCellEditor) {
            ((SystemInheritableTextCellEditor)editor).getInheritableEntryField().setAllowEditingOfInheritedText(true);
        }
        return editor;
    }

    public void computeLayout(boolean force) {
        if (this._objectInput == null) {
            return;
        }
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        if (provider == null) {
            return;
        }
        Object[] children = provider.getChildren(this._objectInput);
        if (children == null || children.length == 0 || children.length == 1 && children[0] instanceof PendingUpdateAdapter) {
            return;
        }
        IPropertyDescriptor[] descriptors = this.getVisibleDescriptors(children);
        IPropertyDescriptor nameDescriptor = this.getNameDescriptor(children);
        int n = descriptors.length;
        if (nameDescriptor != null) {
            ++n;
        }
        if (n == 0) {
            return;
        }
        if (this.sameDescriptors(descriptors, this._uniqueDescriptors) && !force) {
            this.setLastColumnWidths(this.getCurrentColumnWidths());
            return;
        }
        this._uniqueDescriptors = descriptors;
        Tree tree = this.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        TreeColumn[] columns = tree.getColumns();
        int numColumns = columns.length;
        CellEditor[] editors = new CellEditor[n];
        String[] headings = new String[n];
        String[] propertyIds = new String[n];
        ArrayList formats = this.getFormatsIn();
        this._layout = new TableLayout();
        int i = 0;
        while (i < n) {
            String name = null;
            String propertyId = null;
            CellEditor editor = null;
            int alignment = 16384;
            int weight = 100;
            if (i == 0) {
                name = SystemPropertyResources.RESID_PROPERTY_NAME_LABEL;
                if (nameDescriptor != null) {
                    propertyId = (String)nameDescriptor.getId();
                    editor = this.getCellEditor(tree, nameDescriptor);
                    weight = 200;
                }
            } else {
                IPropertyDescriptor descriptor = descriptors[i - 1];
                Class format = (Class)formats.get(i - 1);
                name = descriptor.getDisplayName();
                propertyId = (String)descriptor.getId();
                editor = this.getCellEditor(tree, descriptor);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (format != clazz) {
                    alignment = 131072;
                }
            }
            TreeColumn tc = null;
            if (i >= numColumns) {
                tc = new TreeColumn(tree, alignment, i);
                tc.addSelectionListener((SelectionListener)this._columnSelectionListener);
            } else {
                tc = columns[i];
                tc.setAlignment(alignment);
            }
            this._layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight));
            tc.setText(name);
            headings[i] = name;
            editors[i] = editor;
            propertyIds[i] = propertyId;
            ++i;
        }
        this.setColumnProperties(propertyIds);
        this.setCellEditors(editors);
        this.setCellModifier(this.cellModifier);
        i = n;
        while (i < numColumns) {
            columns[i].dispose();
            columns[i] = null;
            ++i;
        }
        columns = tree.getColumns();
        numColumns = columns.length;
        Rectangle clientA = tree.getClientArea();
        int totalWidth = clientA.width - 5;
        if (totalWidth <= 0) {
            totalWidth = 500;
        }
        int[] lastWidths = this.getLastColumnWidths();
        if (numColumns > 1) {
            if (lastWidths != null && lastWidths.length == numColumns) {
                this.setCurrentColumnWidths(lastWidths);
            } else if (totalWidth > 0) {
                int averageWidth = totalWidth / numColumns;
                int firstWidth = Math.max(averageWidth, 150);
                averageWidth = (totalWidth - firstWidth) / (numColumns - 1);
                averageWidth = Math.max(averageWidth, 80);
                columns[0].setWidth(firstWidth);
                int i2 = 1;
                while (i2 < numColumns) {
                    columns[i2].setWidth(averageWidth);
                    ++i2;
                }
                this.setLastColumnWidths(this.getCurrentColumnWidths());
            }
            tree.setHeaderVisible(true);
        } else if (numColumns == 1) {
            int maxWidth;
            int width = totalWidth;
            if (lastWidths != null && lastWidths.length == 1) {
                int n2 = width = totalWidth > lastWidths[0] ? totalWidth : lastWidths[0];
            }
            if ((maxWidth = provider.getMaxCharsInColumnZero() * this._charWidth) > width) {
                width = maxWidth;
            }
            if (width > 0) {
                columns[0].setWidth(width);
            }
            tree.setHeaderVisible(false);
        }
    }

    public int[] getCurrentColumnWidths() {
        return new int[0];
    }

    public void setCurrentColumnWidths(int[] widths) {
    }

    public int[] getLastColumnWidths() {
        return this._lastWidths;
    }

    public void setLastColumnWidths(int[] widths) {
        this._lastWidths = widths;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] dragtransfers = new Transfer[]{PluginTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance(), EditorInputTransfer.getInstance()};
        Transfer[] droptransfers = new Transfer[]{PluginTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance(), EditorInputTransfer.getInstance()};
        this.addDragSupport(ops, dragtransfers, (DragSourceListener)new SystemViewDataDragAdapter(this));
        this.addDropSupport(ops | 0x10, droptransfers, (DropTargetListener)new SystemViewDataDropAdapter((StructuredViewer)this));
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        SystemTableTreeViewProvider provider;
        try {
            Tree tree = this.getTree();
            boolean isDisposed = tree.isDisposed();
            if (isDisposed) {
                this.dispose();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean madeChange = false;
        Object parent = event.getParent();
        Object child = event.getSource();
        int eventType = event.getType();
        switch (eventType) {
            case 86: 
            case 87: {
                Widget w = this.findItem(child);
                if (w == null) break;
                this.updateItem(w, child);
                break;
            }
            case 50: 
            case 53: {
                SystemTableTreeViewProvider provider2;
                boolean addingConnection = child instanceof IHost;
                if (!(this._objectInput instanceof ISystemRegistry) || !addingConnection || (provider2 = (SystemTableTreeViewProvider)this.getContentProvider()) == null) break;
                if (!madeChange) {
                    provider2.flushCache();
                    madeChange = true;
                }
                this.computeLayout();
                this.internalRefresh(this._objectInput);
                break;
            }
            case 82: {
                Widget w = this.findItem(parent);
                if (w == null) break;
                SystemTableTreeViewProvider provider2 = (SystemTableTreeViewProvider)this.getContentProvider();
                if (!madeChange) {
                    provider2.flushCache();
                    madeChange = true;
                }
                this.internalRefresh(parent);
                break;
            }
        }
        if ((child == this._objectInput || parent == this._objectInput) && (provider = (SystemTableTreeViewProvider)this.getContentProvider()) != null) {
            if (!madeChange) {
                madeChange = true;
            }
            this.computeLayout();
            try {
                this.internalRefresh(this._objectInput);
            }
            catch (Exception e) {
                SystemBasePlugin.logError(e.getMessage());
            }
        }
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        boolean madeChange = false;
        int eventType = event.getEventType();
        Object remoteResourceParent = event.getResourceParent();
        Object remoteResource = event.getResource();
        Vector remoteResourceNames = null;
        if (remoteResource instanceof Vector) {
            remoteResourceNames = (Vector)remoteResource;
            remoteResource = remoteResourceNames.elementAt(0);
        }
        String remoteResourceParentName = this.getRemoteResourceAbsoluteName(remoteResourceParent);
        String remoteResourceName = this.getRemoteResourceAbsoluteName(remoteResource);
        if (remoteResourceName == null) {
            return;
        }
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        switch (eventType) {
            case 4: {
                Widget w;
                if (remoteResourceParent != this.getInput() || (w = this.findItem(remoteResource)) == null) break;
                this.updateItem(w, remoteResource);
                break;
            }
            case 1: {
                String inputResourceName = this.getRemoteResourceAbsoluteName(this.getInput());
                if (remoteResourceParentName == null || !remoteResourceParentName.equals(inputResourceName)) break;
                if (provider == null) {
                    return;
                }
                if (!madeChange) {
                    provider.flushCache();
                    madeChange = true;
                }
                this.refresh();
                break;
            }
            case 2: {
                Object dchild = remoteResource;
                ISystemViewElementAdapter dadapt = this.getViewAdapter(dchild);
                if (dadapt == null) break;
                ISubSystem dSubSystem = dadapt.getSubSystem(dchild);
                String dkey = dadapt.getAbsoluteName(dchild);
                if (provider == null) break;
                Object[] children = provider.getChildren(this._objectInput);
                int i = 0;
                while (i < children.length) {
                    String ekey;
                    ISystemViewElementAdapter eadapt;
                    ISubSystem eSubSystem;
                    Object existingChild = children[i];
                    if (existingChild != null && dSubSystem == (eSubSystem = (eadapt = this.getViewAdapter(existingChild)).getSubSystem(existingChild)) && (ekey = eadapt.getAbsoluteName(existingChild)).equals(dkey) && !madeChange) {
                        provider.flushCache();
                        madeChange = true;
                        this.refresh();
                    }
                    ++i;
                }
                break;
            }
            case 8: {
                Object[] previousResults;
                String oldName = event.getOldName();
                Object child = event.getResource();
                if (provider == null || (previousResults = provider.getCache()) == null) break;
                int i = 0;
                while (i < previousResults.length) {
                    Object previousResult = previousResults[i];
                    if (previousResult == child) {
                        Widget widget = this.findItem(previousResult);
                        if (widget != null) {
                            widget.setData(child);
                            this.updateItem(widget, child);
                            return;
                        }
                    } else {
                        String previousName = this.getViewAdapter(previousResult).getAbsoluteName(previousResult);
                        if (previousName != null && previousName.equals(oldName)) {
                            provider.flushCache();
                            this.internalRefresh(this._objectInput);
                            return;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else {
            IRemoteObjectIdentifier ra = this.getRemoteObjectIdentifier(remoteResource);
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this._selectionFlagsUpdated = false;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object firstSelection = sel.getFirstElement();
        if (firstSelection == null) {
            return;
        }
        this._selectionFlagsUpdated = false;
        ISystemViewElementAdapter adapter = this.getViewAdapter(firstSelection);
        if (adapter != null) {
            this.displayMessage(adapter.getStatusLineText(firstSelection));
            if (this.mouseButtonPressed == 1) {
                adapter.selectionChanged(firstSelection);
            }
        } else {
            this.clearMessage();
        }
    }

    public void dispose() {
        this.removeAsListener();
        Composite tree = this.getTableTree();
        boolean isDisposed = tree.isDisposed();
        if (!isDisposed) {
            tree.dispose();
        }
    }

    public void displayMessage(String msg) {
        if (this._messageLine != null) {
            this._messageLine.setMessage(msg);
        }
    }

    public ISystemViewElementAdapter getViewAdapterForContents() {
        Object[] children;
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        if (provider != null && (children = provider.getChildren(this.getInput())) != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            return this.getViewAdapter(child);
        }
        return null;
    }

    public void clearMessage() {
        if (this._messageLine != null) {
            this._messageLine.clearMessage();
        }
    }

    public void removeAsListener() {
        this.removeSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.removeSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
    }

    protected PropertyDialogAction getPropertyDialogAction() {
        if (this._propertyDialogAction == null) {
            this._propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this);
        }
        this._propertyDialogAction.selectionChanged(this.getSelection());
        return this._propertyDialogAction;
    }

    protected IAction getSelectAllAction() {
        if (this._selectAllAction == null) {
            this._selectAllAction = new SystemCommonSelectAllAction(this.getShell(), this, this);
        }
        return this._selectAllAction;
    }

    protected IAction getRenameAction() {
        if (this._renameAction == null) {
            this._renameAction = new SystemCommonRenameAction(this.getShell(), this);
        }
        return this._renameAction;
    }

    protected IAction getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = new SystemCommonDeleteAction(this.getShell(), this);
        }
        return this._deleteAction;
    }

    protected IAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = new SystemRefreshAction(this.getShell());
        }
        return this._refreshAction;
    }

    protected SystemOpenExplorerPerspectiveAction getOpenToPerspectiveAction() {
        if (this._openToPerspectiveAction == null) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchWindow win = desktop.getActiveWorkbenchWindow();
            this._openToPerspectiveAction = new SystemOpenExplorerPerspectiveAction(this.getShell(), win);
        }
        return this._openToPerspectiveAction;
    }

    protected SystemShowInTableAction getShowInTableAction() {
        if (this._showInTableAction == null) {
            this._showInTableAction = new SystemShowInTableAction(this.getShell());
        }
        return this._showInTableAction;
    }

    public Shell getShell() {
        return this.getTableTree().getShell();
    }

    public boolean showDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowDeleteAction;
    }

    public boolean canDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableDeleteAction;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        boolean ok = true;
        boolean anyOk = false;
        Vector deletedVector = new Vector();
        try {
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getViewAdapter(element);
                ok = adapter.doDelete(this.getShell(), element, monitor);
                if (!ok) continue;
                anyOk = true;
                deletedVector.addElement(element);
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1063").makeSubstitution(element, (Object)msg));
            ok = false;
        }
        if (anyOk) {
            Object[] deleted = new Object[deletedVector.size()];
            int idx = 0;
            while (idx < deleted.length) {
                deleted[idx] = deletedVector.elementAt(idx);
                ++idx;
            }
            if (this._selectionIsRemoteObject) {
                sr.fireRemoteResourceChangeEvent(2, deletedVector, null, null, null, (Object)this);
            } else {
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(deleted, 60, this.getInput()));
            }
        }
        return ok;
    }

    public boolean showRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowRenameAction;
    }

    public boolean canRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableRenameAction;
    }

    protected Object getParentForContent(Object element) {
        return this._objectInput;
    }

    public boolean doRename(String[] newNames) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        ISystemRemoteElementAdapter remoteAdapter = null;
        String oldFullName = null;
        boolean ok = true;
        try {
            int nameIdx = 0;
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getViewAdapter(element);
                Object parentElement = this.getParentForContent(element);
                remoteAdapter = this.getRemoteAdapter(element);
                if (remoteAdapter != null) {
                    oldFullName = remoteAdapter.getAbsoluteName(element);
                }
                if (!(ok = adapter.doRename(this.getShell(), element, newNames[nameIdx++]))) continue;
                if (remoteAdapter != null) {
                    sr.fireRemoteResourceChangeEvent(8, element, parentElement, remoteAdapter.getSubSystem(element), oldFullName, (Object)this);
                    continue;
                }
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(element, 65, parentElement));
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1064").makeSubstitution(element, (Object)exc), exc);
            ok = false;
        }
        return ok;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        ISystemRemoteElementAdapter adapter = null;
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        } else {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz);
        }
        if (adapter != null && adapter instanceof ISystemViewElementAdapter) {
            ((ISystemViewElementAdapter)((Object)adapter)).setViewer((Viewer)this);
        }
        return adapter;
    }

    protected IRemoteObjectIdentifier getRemoteObjectIdentifier(Object o) {
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.rse.core.subsystems.IRemoteObjectIdentifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IRemoteObjectIdentifier)iAdaptable.getAdapter((Class)clazz);
    }

    public boolean enableSelectAll(IStructuredSelection selection) {
        return true;
    }

    public void doSelectAll(IStructuredSelection selection) {
        Composite tree = this.getTableTree();
        Tree theTree = (Tree)tree;
        theTree.setSelection(theTree.getItems());
        TreeItem[] items = theTree.getItems();
        Object[] objects = new Object[items.length];
        int idx = 0;
        while (idx < items.length) {
            objects[idx] = items[idx].getData();
            ++idx;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(objects)));
    }

    public void menuAboutToShow(IMenuManager manager) {
        Menu m;
        SystemView.createStandardGroups(manager);
        if (!this.menuListenerAdded && manager instanceof MenuManager && (m = ((MenuManager)manager).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            if (this._messageLine != null) {
                ml.setShowToolTipText(true, this._messageLine);
            }
            m.addMenuListener((MenuListener)ml);
        }
        this.fillContextMenu(manager);
    }

    public ISelection getSelection() {
        ISelection selection = super.getSelection();
        if (selection == null || selection.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this._objectInput != null) {
                list.add(this._objectInput);
                selection = new StructuredSelection(list);
            }
        }
        return selection;
    }

    public void fillContextMenu(IMenuManager menu) {
        PropertyDialogAction pdAction;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        boolean allSelectionsFromSameParent = true;
        int selectionCount = selection.size();
        if (selectionCount == 0) {
            return;
        }
        if (selectionCount == 1) {
            selection.getFirstElement();
            this.getInput();
        }
        if (selectionCount > 1 && !(allSelectionsFromSameParent = this.sameParent()) && this.selectionHasAncestryRelationship()) {
            SystemView.createStandardGroups(menu);
            return;
        }
        SystemView.createStandardGroups(menu);
        if (this.canRename() && this.showRename()) {
            menu.appendToGroup("group.reorganize", this.getRenameAction());
        }
        SystemMenuManager ourMenu = new SystemMenuManager(menu);
        Iterator elements = selection.iterator();
        Hashtable adapters = new Hashtable();
        while (elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getViewAdapter(element);
            adapters.put(adapter, element);
        }
        Enumeration uniqueAdapters = adapters.keys();
        Shell shell = this.getShell();
        while (uniqueAdapters.hasMoreElements()) {
            ISystemViewElementAdapter nextAdapter = (ISystemViewElementAdapter)uniqueAdapters.nextElement();
            nextAdapter.addActions(ourMenu, selection, shell, "group.adapters");
            if (!(nextAdapter instanceof AbstractSystemViewAdapter)) continue;
            AbstractSystemViewAdapter aVA = (AbstractSystemViewAdapter)nextAdapter;
            aVA.addCommonRemoteActions(ourMenu, selection, shell, "group.adapters");
            aVA.addDynamicPopupMenuActions(ourMenu, selection, shell, "additions");
        }
        IContributionItem[] items = menu.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                item.setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            }
            ++idx;
        }
        if (this.canDelete() && this.showDelete()) {
            menu.appendToGroup("group.reorganize", this.getDeleteAction());
            ((ISystemAction)this.getDeleteAction()).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            menu.add((IContributionItem)new Separator());
        }
        if ((pdAction = this.getPropertyDialogAction()).isApplicableForSelection()) {
            menu.appendToGroup("group.properties", (IAction)pdAction);
        }
        if (!this._selectionIsRemoteObject) {
            SystemOpenExplorerPerspectiveAction openToPerspectiveAction = this.getOpenToPerspectiveAction();
            SystemShowInTableAction showInTableAction = this.getShowInTableAction();
            openToPerspectiveAction.setSelection((ISelection)selection);
            showInTableAction.setSelection((ISelection)selection);
            menu.appendToGroup("group.open", (IAction)openToPerspectiveAction);
            menu.appendToGroup("group.open", (IAction)showInTableAction);
        }
    }

    public boolean sameParent() {
        boolean same = true;
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return true;
        }
        TreeItem prevParent = null;
        TreeItem currParent = null;
        int idx = 0;
        while (idx < items.length) {
            currParent = items[idx].getParentItem();
            if (idx > 0 && currParent != prevParent) {
                same = false;
                break;
            }
            prevParent = currParent;
            ++idx;
        }
        return same;
    }

    private boolean selectionHasAncestryRelationship() {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        int idx = 0;
        while (idx < items.length) {
            TreeItem item = items[idx];
            int c = 0;
            while (c < items.length) {
                if (item != items[c] && this.isAncestorOf(item, items[c], false)) {
                    return true;
                }
                ++c;
            }
            ++idx;
        }
        return false;
    }

    private boolean isAncestorOf(TreeItem container, TreeItem item, boolean direct) {
        TreeItem parent;
        TreeItem[] children = null;
        children = !direct ? ((parent = container.getParentItem()) != null ? parent.getItems() : this.getTree().getItems()) : container.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem child = children[i];
            if (child == item && direct) {
                return true;
            }
            if (child.getItemCount() > 0 && this.isAncestorOf(child, item, true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void scanSelections() {
        this._selectionShowRefreshAction = true;
        this._selectionShowOpenViewActions = true;
        this._selectionShowDeleteAction = true;
        this._selectionShowRenameAction = true;
        this._selectionEnableDeleteAction = true;
        this._selectionEnableRenameAction = true;
        this._selectionIsRemoteObject = true;
        this._selectionFlagsUpdated = true;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getViewAdapter(element);
            if (this._selectionShowRefreshAction) {
                this._selectionShowRefreshAction = adapter.showRefresh(element);
            }
            if (this._selectionShowOpenViewActions) {
                this._selectionShowOpenViewActions = adapter.showOpenViewActions(element);
            }
            if (this._selectionShowDeleteAction) {
                this._selectionShowDeleteAction = adapter.showDelete(element);
            }
            if (this._selectionShowRenameAction) {
                this._selectionShowRenameAction = adapter.showRename(element);
            }
            if (this._selectionEnableDeleteAction) {
                boolean bl = this._selectionEnableDeleteAction = this._selectionShowDeleteAction && adapter.canDelete(element);
            }
            if (this._selectionEnableRenameAction) {
                boolean bl = this._selectionEnableRenameAction = this._selectionShowRenameAction && adapter.canRename(element);
            }
            if (!this._selectionIsRemoteObject) continue;
            boolean bl = this._selectionIsRemoteObject = this.getRemoteAdapter(element) != null;
        }
    }

    public void positionTo(String name) {
        ArrayList<TreeItem> selectedItems = new ArrayList<TreeItem>();
        Tree tree = this.getTree();
        TreeItem topItem = null;
        int i = 0;
        while (i < tree.getItemCount()) {
            ISystemViewElementAdapter adapter;
            String itemName;
            TreeItem item = tree.getItem(i);
            Object data = item.getData();
            if (data instanceof IAdaptable && StringCompare.compare((String)name, (String)(itemName = (adapter = this.getViewAdapter(data)).getName(data)), (boolean)false)) {
                if (topItem == null) {
                    topItem = item;
                }
                selectedItems.add(item);
            }
            ++i;
        }
        if (selectedItems.size() > 0) {
            TreeItem[] tItems = new TreeItem[selectedItems.size()];
            int i2 = 0;
            while (i2 < selectedItems.size()) {
                tItems[i2] = (TreeItem)selectedItems.get(i2);
                ++i2;
            }
            tree.setSelection(tItems);
            tree.setTopItem(topItem);
            this.setSelection(this.getSelection(), true);
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.scanSelections();
            if (this.showDelete() && this.canDelete()) {
                SystemCommonDeleteAction dltAction = (SystemCommonDeleteAction)this.getDeleteAction();
                dltAction.setShell(this.getShell());
                dltAction.setSelection(this.getSelection());
                dltAction.setViewer((Viewer)this);
                dltAction.run();
            }
        }
    }

    protected void createChildren(final Widget widget) {
        if (widget instanceof TreeItem) {
            Object data;
            final Item[] tis = this.getChildren(widget);
            if (tis != null && tis.length > 0 && (data = tis[0].getData()) != null) {
                return;
            }
            BusyIndicator.showWhile((Display)widget.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IContextObject parentElement;
                    Object[] children;
                    Object d;
                    if (tis != null) {
                        int i = 0;
                        while (i < tis.length) {
                            if (tis[i].getData() != null) {
                                SystemTableTreeView.this.disassociate(tis[i]);
                                Assert.isTrue((tis[i].getData() == null ? 1 : 0) != 0, (String)"Second or later child is non -null");
                            }
                            tis[i].dispose();
                            ++i;
                        }
                    }
                    if ((d = widget.getData()) != null && (children = SystemTableTreeView.this.getSortedChildren(parentElement = SystemTableTreeView.this.getContextObject((TreeItem)widget))) != null) {
                        int i = 0;
                        while (i < children.length) {
                            SystemTableTreeView.this.createTreeItem(widget, children[i], -1);
                            ++i;
                        }
                    }
                }
            });
        } else {
            super.createChildren(widget);
        }
    }

    public ISystemFilterReference getContainingFilterReference(TreeItem item) {
        Object data = item.getData();
        if (data instanceof ISystemFilterReference) {
            return (ISystemFilterReference)data;
        }
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            return this.getContainingFilterReference(parent);
        }
        Object input = this.getInput();
        if (input instanceof ISystemFilterReference) {
            return (ISystemFilterReference)input;
        }
        return null;
    }

    public ISubSystem getContainingSubSystem(TreeItem item) {
        Object data = item.getData();
        if (data instanceof ISubSystem) {
            return (ISubSystem)data;
        }
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            return this.getContainingSubSystem(parent);
        }
        Object input = this.getInput();
        if (input instanceof ISubSystem) {
            return (ISubSystem)input;
        }
        return null;
    }

    public IContextObject getContextObject(TreeItem item) {
        Object data = item.getData();
        ISystemFilterReference filterReference = this.getContainingFilterReference(item);
        if (filterReference != null) {
            return new ContextObject(data, filterReference.getSubSystem(), filterReference);
        }
        ISubSystem subSystem = this.getContainingSubSystem(item);
        if (subSystem != null) {
            return new ContextObject(data, subSystem);
        }
        return new ContextObject(data);
    }

    public void add(Object parentElementOrTreePath, Object[] childElements) {
        Assert.isNotNull((Object)parentElementOrTreePath);
        this.assertElementsNotNull(childElements);
        if (parentElementOrTreePath instanceof IContextObject) {
            parentElementOrTreePath = ((IContextObject)parentElementOrTreePath).getModelObject();
        }
        super.add(parentElementOrTreePath, childElements);
    }

    private class HeaderSelectionListener
    extends SelectionAdapter {
        public HeaderSelectionListener() {
            SystemTableTreeView.this._upI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.upIcon");
            SystemTableTreeView.this._downI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.downIcon");
        }

        public void widgetSelected(SelectionEvent e) {
            Tree table = SystemTableTreeView.this.getTree();
            if (!table.isDisposed()) {
                TreeColumn tcolumn = (TreeColumn)e.widget;
                int column = table.indexOf(tcolumn);
                SystemTableViewSorter oldSorter = (SystemTableViewSorter)SystemTableTreeView.this.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    if (tcolumn.getImage() == SystemTableTreeView.this._upI) {
                        tcolumn.setImage(SystemTableTreeView.this._downI);
                    } else {
                        tcolumn.setImage(SystemTableTreeView.this._upI);
                    }
                } else {
                    SystemTableTreeView.this.setSorter(new SystemTableViewSorter(column, (StructuredViewer)SystemTableTreeView.this, SystemTableTreeView.this._columnManager));
                    tcolumn.setImage(SystemTableTreeView.this._downI);
                }
                TreeColumn[] allColumns = table.getColumns();
                int i = 0;
                while (i < allColumns.length) {
                    if (i != column && allColumns[i].getImage() != null) {
                        allColumns[i].setImage(null);
                    }
                    ++i;
                }
                SystemTableTreeView.this.refresh();
            }
        }
    }
}

