/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemClearAllPasswordsAction;
import org.eclipse.rse.internal.ui.actions.SystemConnectAllSubSystemsAction;
import org.eclipse.rse.internal.ui.actions.SystemCopyConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemDisconnectAllSubSystemsAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveDownConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveUpConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemWorkOfflineAction;
import org.eclipse.rse.internal.ui.view.SystemInheritablePropertyData;
import org.eclipse.rse.internal.ui.view.SystemInheritableTextPropertyDescriptor;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SystemViewConnectionAdapter
extends AbstractSystemViewAdapter {
    private SystemNewConnectionAction anotherConnectionAction = null;
    private SystemMoveUpConnectionAction upAction = null;
    private SystemMoveDownConnectionAction downAction = null;
    private SystemDisconnectAllSubSystemsAction disconnectAction = null;
    private SystemConnectAllSubSystemsAction connectAction = null;
    private SystemClearAllPasswordsAction clearPasswordAction = null;
    private SystemCopyConnectionAction copyAction = null;
    private SystemMoveConnectionAction moveAction = null;
    private SystemWorkOfflineAction offlineAction = null;
    private SystemInheritablePropertyData userIdData = new SystemInheritablePropertyData();
    private String translatedType = null;
    private String translatedHostname = null;
    private String translatedDescription = null;
    private String original_hostName;
    private String original_description;
    private SystemInheritablePropertyData original_userIdData = new SystemInheritablePropertyData();
    private boolean changed_hostName;
    private boolean changed_description;
    private boolean changed_userId;
    private boolean actionsCreated = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    private IRSESystemType getSystemTypeForHost(IHost host) {
        if (host != null) {
            return host.getSystemType();
        }
        return null;
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        RSESystemTypeAdapter sysTypeAdapter;
        Object object;
        IHost host;
        IRSESystemType sysType;
        if (!this.actionsCreated) {
            this.createActions();
        }
        if ((sysType = this.getSystemTypeForHost(host = (IHost)selection.getFirstElement())) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = sysType.getAdapter((Class)clazz);
        } else {
            object = null;
        }
        Object adapter = object;
        RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.anotherConnectionAction.getClass())) {
            menu.add(menuGroup, this.anotherConnectionAction);
        }
        menu.appendToGroup("group.new", (IContributionItem)new GroupMarker("group.new.noncascade"));
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.copyAction.getClass())) {
            menu.add(menuGroup, this.copyAction);
        }
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.moveAction.getClass())) {
            menu.add(menuGroup, this.moveAction);
        }
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.upAction.getClass())) {
            menu.add(menuGroup, this.upAction);
        }
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.downAction.getClass())) {
            menu.add(menuGroup, this.downAction);
        }
        this.addConnectOrDisconnectAction(menu, menuGroup, selection);
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.clearPasswordAction.getClass())) {
            menu.add(menuGroup, this.clearPasswordAction);
        }
        if (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.offlineAction.getClass())) {
            menu.add(menuGroup, this.offlineAction);
        }
    }

    private void addConnectOrDisconnectAction(SystemMenuManager menu, String menuGroup, IStructuredSelection selection) {
        Object object;
        IHost host = (IHost)selection.getFirstElement();
        IRSESystemType sysType = this.getSystemTypeForHost(host);
        if (sysType != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = sysType.getAdapter((Class)clazz);
        } else {
            object = null;
        }
        Object adapter = object;
        RSESystemTypeAdapter sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
        ISystemRegistry sysReg = RSECorePlugin.getTheSystemRegistry();
        boolean anySupportsConnect = sysReg.isAnySubSystemSupportsConnect(host);
        if (anySupportsConnect) {
            boolean anyConnected = sysReg.isAnySubSystemConnected(host);
            boolean allConnected = sysReg.areAllSubSystemsConnected(host);
            if (!allConnected && (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.connectAction.getClass()))) {
                menu.add(menuGroup, this.connectAction);
            }
            if (anyConnected && (sysTypeAdapter == null || sysTypeAdapter.acceptContextMenuActionContribution(host, this.disconnectAction.getClass()))) {
                menu.add(menuGroup, this.disconnectAction);
            }
        }
    }

    private void createActions() {
        this.anotherConnectionAction = new SystemNewConnectionAction(null, SystemResources.ACTION_ANOTHERCONN_LABEL, SystemResources.ACTION_ANOTHERCONN_TOOLTIP, false, true, null);
        this.anotherConnectionAction.setHelp("org.eclipse.rse.ui.actn0015");
        this.upAction = new SystemMoveUpConnectionAction(null);
        this.downAction = new SystemMoveDownConnectionAction(null);
        this.disconnectAction = new SystemDisconnectAllSubSystemsAction(null);
        this.copyAction = new SystemCopyConnectionAction(null);
        this.moveAction = new SystemMoveConnectionAction(null);
        this.offlineAction = new SystemWorkOfflineAction(null);
        this.connectAction = new SystemConnectAllSubSystemsAction(null);
        this.clearPasswordAction = new SystemClearAllPasswordsAction(null);
        this.actionsCreated = true;
    }

    public boolean showDelete(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                IHost iHost = (IHost)element;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return sysTypeAdapter.acceptContextMenuActionContribution(iHost, clazz);
            }
        }
        return super.showDelete(element);
    }

    public boolean showGenericShowInTableAction(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                boolean accepted = false;
                Class[] classArray = new Class[2];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.rse.internal.ui.actions.SystemShowInTableAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.eclipse.rse.internal.ui.actions.SystemShowInMonitorAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class[] affectedClasses = classArray;
                int i = 0;
                while (i < affectedClasses.length && !accepted) {
                    accepted |= sysTypeAdapter.acceptContextMenuActionContribution((IHost)element, affectedClasses[i]);
                    ++i;
                }
                return accepted;
            }
        }
        return super.showGenericShowInTableAction(element);
    }

    public boolean showOpenViewActions(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                IHost iHost = (IHost)element;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.eclipse.rse.internal.ui.actions.SystemOpenExplorerPerspectiveAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return sysTypeAdapter.acceptContextMenuActionContribution(iHost, clazz);
            }
        }
        return super.showOpenViewActions(element);
    }

    public boolean showProperties(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                IHost iHost = (IHost)element;
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("org.eclipse.ui.dialogs.PropertyDialogAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return sysTypeAdapter.acceptContextMenuActionContribution(iHost, clazz);
            }
        }
        return super.showProperties(element);
    }

    public boolean showRefresh(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                IHost iHost = (IHost)element;
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("org.eclipse.rse.ui.actions.SystemRefreshAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return sysTypeAdapter.acceptContextMenuActionContribution(iHost, clazz);
            }
        }
        return super.showRefresh(element);
    }

    public boolean showRename(Object element) {
        if (element instanceof IHost) {
            RSESystemTypeAdapter sysTypeAdapter;
            Object object;
            IRSESystemType sysType = this.getSystemTypeForHost((IHost)element);
            if (sysType != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = sysType.getAdapter((Class)clazz);
            } else {
                object = null;
            }
            Object adapter = object;
            RSESystemTypeAdapter rSESystemTypeAdapter = sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
            if (sysTypeAdapter != null) {
                IHost iHost = (IHost)element;
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return sysTypeAdapter.acceptContextMenuActionContribution(iHost, clazz);
            }
        }
        return super.showRename(element);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IHost connection = (IHost)element;
        boolean anyConnected = RSECorePlugin.getTheSystemRegistry().isAnySubSystemConnected(connection);
        ImageDescriptor descriptor = null;
        IRSESystemType systemType = this.getSystemTypeForHost(connection);
        if (systemType != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RSESystemTypeAdapter sysTypeAdapter = (RSESystemTypeAdapter)systemType.getAdapter((Class)clazz);
            descriptor = anyConnected ? sysTypeAdapter.getLiveImageDescriptor(systemType) : sysTypeAdapter.getImageDescriptor(systemType);
        } else {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor;
    }

    public String getText(Object element) {
        IHost conn = (IHost)element;
        boolean qualifyNames = RSECorePlugin.getTheSystemRegistry().getQualifiedHostNames();
        if (!qualifyNames) {
            return conn.getAliasName();
        }
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getName(Object element) {
        IHost conn = (IHost)element;
        return conn.getAliasName();
    }

    public String getAbsoluteName(Object element) {
        IHost conn = (IHost)element;
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_CONNECTION_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public String getStatusLineText(Object element) {
        IHost conn = (IHost)element;
        if (this.translatedHostname == null) {
            this.translatedHostname = SystemViewResources.RESID_PROPERTY_HOSTNAME_LABEL;
        }
        if (this.translatedDescription == null) {
            this.translatedDescription = SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_LABEL;
        }
        String statusText = String.valueOf(this.getType(element)) + ": " + conn.getAliasName() + "  -  " + this.translatedHostname + ": " + conn.getHostName();
        String text = conn.getDescription();
        if (text == null || text.length() == 0) {
            return statusText;
        }
        return String.valueOf(statusText) + "  -  " + this.translatedDescription + ": " + text;
    }

    public Object getParent(Object element) {
        return RSECorePlugin.getTheSystemRegistry();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        IHost conn = (IHost)element;
        ISystemViewInputProvider input = this.getInput();
        if (input != null) {
            Object[] children = input.getConnectionChildren(conn);
            if (children != null) {
                Vector<Object> v = new Vector<Object>();
                boolean someSkipped = false;
                int idx = 0;
                while (idx < children.length) {
                    if (children[idx] instanceof ISubSystem && ((ISubSystem)children[idx]).isHidden()) {
                        someSkipped = true;
                    } else {
                        v.addElement(children[idx]);
                    }
                    ++idx;
                }
                if (someSkipped) {
                    children = new Object[v.size()];
                    idx = 0;
                    while (idx < children.length) {
                        children[idx] = v.elementAt(idx);
                        ++idx;
                    }
                }
            }
            return children;
        }
        System.out.println("SystemViewConnection.getChildren(): adapter has no input!");
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        IHost conn = (IHost)element;
        return this.getInput().hasConnectionChildren(conn);
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[6];
            int idx = -1;
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.profile", SystemViewResources.RESID_PROPERTY_PROFILE_LABEL, SystemViewResources.RESID_PROPERTY_PROFILE_TOOLTIP);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.systemType", SystemViewResources.RESID_PROPERTY_SYSTEMTYPE_LABEL, SystemViewResources.RESID_PROPERTY_SYSTEMTYPE_TOOLTIP);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.connected", SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_LABEL, SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_TOOLTIP);
            if (this.translatedHostname == null) {
                this.translatedHostname = SystemViewResources.RESID_PROPERTY_HOSTNAME_LABEL;
            }
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = new TextPropertyDescriptor((Object)"org.eclipse.rse.ui.hostname", this.translatedHostname);
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_HOSTNAME_TOOLTIP);
            SystemInheritableTextPropertyDescriptor userIdDescriptor = new SystemInheritableTextPropertyDescriptor("org.eclipse.rse.ui.defaultuserid", SystemViewResources.RESID_PROPERTY_DEFAULTUSERID_LABEL);
            userIdDescriptor.setToggleButtonToolTipText(SystemResources.RESID_CONNECTION_DEFAULTUSERID_INHERITBUTTON_TIP);
            userIdDescriptor.setEntryFieldToolTipText(SystemResources.RESID_CONNECTION_DEFAULTUSERID_TIP);
            ValidatorSpecialChar userIdValidator = new ValidatorSpecialChar("=;", false, RSEUIPlugin.getPluginMessage("RSEG1026"), RSEUIPlugin.getPluginMessage("RSEG1025"));
            userIdDescriptor.setValidator(userIdValidator);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = userIdDescriptor;
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_DEFAULTUSERID_TOOLTIP);
            if (this.translatedDescription == null) {
                this.translatedDescription = SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_LABEL;
            }
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = new TextPropertyDescriptor((Object)"org.eclipse.rse.ui.description", this.translatedDescription);
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        IHost conn = (IHost)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.systemType")) {
            return conn.getSystemType().getLabel();
        }
        if (name.equals("org.eclipse.rse.ui.hostname")) {
            return conn.getHostName();
        }
        if (name.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.setDefaultUserIdPropertyData(this.userIdData, conn);
            return this.userIdData;
        }
        if (name.equals("org.eclipse.rse.ui.description")) {
            return conn.getDescription();
        }
        if (name.equals("org.eclipse.rse.ui.profile")) {
            return conn.getSystemProfile().getName();
        }
        if (name.equals("org.eclipse.rse.ui.connected")) {
            if (conn.isOffline()) {
                return SystemResources.RESID_OFFLINE_LABEL;
            }
            boolean anyConnected = RSECorePlugin.getTheSystemRegistry().isAnySubSystemConnected(conn);
            if (anyConnected) {
                return SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_CONNECTED_VALUE;
            }
            return SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_DISCONNECTED_VALUE;
        }
        return null;
    }

    private SystemInheritablePropertyData setDefaultUserIdPropertyData(SystemInheritablePropertyData data, IHost conn) {
        String localUserId = conn.getLocalDefaultUserId();
        data.setLocalValue(localUserId);
        String parentUserId = RSEPreferencesManager.getUserId((String)conn.getSystemType().getId());
        data.setInheritedValue(parentUserId);
        data.setIsLocal(localUserId != null && localUserId.length() > 0);
        return data;
    }

    public void setPropertySourceInput(Object propertySourceInput) {
        if (this.propertySourceInput == propertySourceInput) {
            return;
        }
        super.setPropertySourceInput(propertySourceInput);
        IHost conn = (IHost)propertySourceInput;
        this.original_userIdData = this.setDefaultUserIdPropertyData(this.original_userIdData, conn);
        this.original_hostName = conn.getHostName();
        this.original_description = conn.getDescription();
        this.changed_description = false;
        this.changed_hostName = false;
        this.changed_userId = false;
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = (String)propertyObject;
        boolean changed = false;
        if (property.equals("org.eclipse.rse.ui.defaultuserid")) {
            changed = this.changed_userId;
        } else if (property.equals("org.eclipse.rse.ui.hostname")) {
            changed = this.changed_hostName;
        } else if (property.equals("org.eclipse.rse.ui.description")) {
            changed = this.changed_description;
        }
        return changed;
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = (String)propertyObject;
        IHost conn = (IHost)this.propertySourceInput;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (property.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.updateDefaultUserId(conn, this.original_userIdData);
        } else if (property.equals("org.eclipse.rse.ui.hostname")) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), this.original_hostName, conn.getDescription(), conn.getDefaultUserId(), 0);
        } else if (property.equals("org.eclipse.rse.ui.description")) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), this.original_description, conn.getDefaultUserId(), 0);
        }
    }

    private void updateDefaultUserId(IHost conn, SystemInheritablePropertyData data) {
        int whereToUpdate = 2;
        String userId = data.getLocalValue();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), conn.getDescription(), userId, whereToUpdate);
    }

    public void setPropertyValue(Object property, Object value) {
        String name = (String)property;
        IHost conn = (IHost)this.propertySourceInput;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (name.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.updateDefaultUserId(conn, (SystemInheritablePropertyData)value);
            this.changed_userId = true;
        } else if (name.equals("org.eclipse.rse.ui.hostname")) {
            if (!((String)value).equalsIgnoreCase(conn.getHostName())) {
                sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), (String)value, conn.getDescription(), conn.getDefaultUserId(), 0);
                this.changed_hostName = true;
            }
        } else if (name.equals("org.eclipse.rse.ui.description") && !((String)value).equalsIgnoreCase(conn.getDescription())) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), (String)value, conn.getDefaultUserId(), 0);
            this.changed_description = true;
        }
    }

    public boolean canDelete(Object element) {
        if (element instanceof IHost) {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            if (((IHost)element).getSystemType().isLocal()) {
                return true;
            }
            return !sr.isAnySubSystemConnected((IHost)element);
        }
        return true;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) {
        boolean ok = true;
        IHost conn = (IHost)element;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.deleteHost(conn);
        return ok;
    }

    public boolean canRename(Object element) {
        return true;
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        boolean ok = true;
        IHost conn = (IHost)element;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.renameHost(conn, name);
        return ok;
    }

    public ISystemValidator getNameValidator(Object element) {
        IHost conn = (IHost)element;
        return SystemConnectionForm.getConnectionNameValidator(conn.getSystemProfile());
    }

    public String getCanonicalNewName(Object element, String newName) {
        IHost conn = (IHost)element;
        return (String.valueOf(conn.getSystemProfileName()) + "." + newName).toUpperCase();
    }

    public boolean canDrag(Object element) {
        return true;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return element;
    }

    public String getMementoHandle(Object element) {
        IHost conn = (IHost)element;
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getMementoHandleKey(Object element) {
        return "Conn";
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

