/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemTeamViewActiveProfileAction
extends SystemBaseAction {
    public SystemTeamViewActiveProfileAction(Shell parent) {
        super(SystemResources.ACTION_PROFILE_ACTIVATE_LABEL, SystemResources.ACTION_PROFILE_ACTIVATE_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.makeprofileactiveIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.actnactp");
        this.setChecked(false);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ISystemProfile profile = (ISystemProfile)this.getFirstSelection();
        if (profile == null) {
            return false;
        }
        SystemProfileManager mgr = SystemProfileManager.getDefault();
        while (profile != null) {
            this.setChecked(mgr.isSystemProfileActive(profile.getName()));
            profile = (ISystemProfile)this.getNextSelection();
        }
        return true;
    }

    public void run() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = (ISystemProfile)this.getFirstSelection();
        boolean check = this.isChecked();
        while (profile != null) {
            sr.setSystemProfileActive(profile, check);
            profile = (ISystemProfile)this.getNextSelection();
        }
    }
}

