/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemTeamViewMakeActiveProfileAction
extends SystemBaseAction {
    public SystemTeamViewMakeActiveProfileAction(Shell parent) {
        super(SystemResources.ACTION_PROFILE_MAKEACTIVE_LABEL, SystemResources.ACTION_PROFILE_MAKEACTIVE_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.makeprofileactiveIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.ActionMakeActive");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object currsel = this.getFirstSelection();
        if (!(currsel instanceof ISystemProfile)) {
            return false;
        }
        ISystemProfile profile = (ISystemProfile)currsel;
        SystemProfileManager mgr = SystemProfileManager.getDefault();
        boolean allActive = true;
        while (profile != null) {
            if (!mgr.isSystemProfileActive(profile.getName())) {
                allActive = false;
            }
            if ((currsel = this.getNextSelection()) != null && !(currsel instanceof ISystemProfile)) {
                return false;
            }
            profile = (ISystemProfile)currsel;
        }
        return !allActive;
    }

    public void run() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = (ISystemProfile)this.getFirstSelection();
        while (profile != null) {
            sr.setSystemProfileActive(profile, true);
            profile = (ISystemProfile)this.getNextSelection();
        }
    }
}

