/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemTeamViewMakeInActiveProfileAction
extends SystemBaseAction {
    public SystemTeamViewMakeInActiveProfileAction(Shell parent) {
        super(SystemResources.ACTION_PROFILE_MAKEINACTIVE_LABEL, SystemResources.ACTION_PROFILE_MAKEINACTIVE_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.makeprofileinactiveIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.ActionMakeInactive");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object currsel = this.getFirstSelection();
        if (!(currsel instanceof ISystemProfile)) {
            return false;
        }
        ISystemProfile profile = (ISystemProfile)currsel;
        SystemProfileManager mgr = SystemProfileManager.getDefault();
        boolean allInActive = true;
        while (profile != null) {
            if (mgr.isSystemProfileActive(profile.getName())) {
                allInActive = false;
            }
            if ((currsel = this.getNextSelection()) != null && !(currsel instanceof ISystemProfile)) {
                return false;
            }
            profile = (ISystemProfile)currsel;
        }
        return !allInActive;
    }

    public void run() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = (ISystemProfile)this.getFirstSelection();
        while (profile != null) {
            sr.setSystemProfileActive(profile, false);
            profile = (ISystemProfile)this.getNextSelection();
        }
    }
}

