/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class PFMetatdataJob
extends Job {
    private RSEDOM _dom;
    private IRSEPersistenceProvider _provider;

    public PFMetatdataJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        super("Saving Profile");
        String title = MessageFormat.format(RSECoreMessages.SaveRSEDOMJob_SavingProfileJobName, dom.getName());
        this.setName(title);
        this.setRule(new SerializingRule());
        this._dom = dom;
        this._provider = provider;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        boolean saved = this._provider.saveRSEDOM(this._dom, monitor);
        if (!saved) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    public boolean belongsTo(Object family) {
        Object[] families = new Object[]{RSECorePlugin.getThePersistenceManager()};
        int i = 0;
        while (i < families.length) {
            Object object = families[i];
            if (family == object) {
                return true;
            }
            ++i;
        }
        return super.belongsTo(family);
    }

    private class SerializingRule
    implements ISchedulingRule {
        private SerializingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SerializingRule;
        }
    }
}

