/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.internal.efs.Activator;
import org.eclipse.rse.internal.efs.RSEFileStore;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileContext;

public class RSEFileStoreImpl
extends FileStore {
    private RSEFileStore _parent;
    private transient IRemoteFile _remoteFile;

    public RSEFileStoreImpl(RSEFileStore parent) {
        this._parent = parent;
    }

    public IFileStore getChild(String name) {
        return this._parent.getChild(name);
    }

    public String getName() {
        return this._parent.getName();
    }

    public IFileStore getParent() {
        return this._parent.getParent();
    }

    public URI toURI() {
        return this._parent.toURI();
    }

    public static IHost getConnectionFor(String hostNameOrAddr, IProgressMonitor monitor) {
        if (hostNameOrAddr == null) {
            return null;
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = sr.getHosts();
        if (connections.length == 0) {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + 5000L;
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (monitor.isCanceled()) break;
            } while (((connections = sr.getHosts()).length == 0 || RSEFileStoreImpl.getConnectionFor(hostNameOrAddr, monitor) == null) && System.currentTimeMillis() < endTime);
        }
        IHost unconnected = null;
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            if (hostNameOrAddr.equalsIgnoreCase(con.getHostName())) {
                IRemoteFileSubSystem fss = RSEFileStoreImpl.getRemoteFileSubSystem(con);
                if (fss != null && fss.isConnected()) {
                    return con;
                }
                unconnected = con;
            }
            ++i;
        }
        return unconnected;
    }

    public static IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        IRemoteFileSubSystem candidate = null;
        FileServiceSubSystem serviceCandidate = null;
        IRemoteFileSubSystem[] subSys = RemoteFileUtility.getFileSubSystems((IHost)host);
        int i = 0;
        while (i < subSys.length) {
            if (subSys[i] instanceof FileServiceSubSystem) {
                if (subSys[i].isConnected()) {
                    return subSys[i];
                }
                if (serviceCandidate == null) {
                    serviceCandidate = (FileServiceSubSystem)subSys[i];
                }
            } else if (candidate == null) {
                candidate = subSys[i];
            } else if (subSys[i].isConnected() && !candidate.isConnected()) {
                candidate = subSys[i];
            }
            ++i;
        }
        if (candidate != null && candidate.isConnected()) {
            return candidate;
        }
        if (serviceCandidate != null) {
            return serviceCandidate;
        }
        return candidate;
    }

    public static IRemoteFileSubSystem getConnectedFileSubSystem(String hostNameOrAddr, IProgressMonitor monitor) throws CoreException {
        IHost con = RSEFileStoreImpl.getConnectionFor(hostNameOrAddr, monitor);
        if (con == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Connection not found for host: " + hostNameOrAddr));
        }
        IRemoteFileSubSystem subSys = RSEFileStoreImpl.getRemoteFileSubSystem(con);
        if (subSys == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "No file subsystem found on host: " + hostNameOrAddr + " connection " + con.getAliasName()));
        }
        if (!subSys.isConnected()) {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                subSys.connect(monitor, false);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not connect to host: " + hostNameOrAddr + " subsystem " + subSys.getConfigurationId(), (Throwable)e));
            }
        }
        return subSys;
    }

    private IRemoteFile getCachedRemoteFile() {
        return this._remoteFile;
    }

    private void cacheRemoteFile(IRemoteFile remoteFile) {
        this._remoteFile = remoteFile;
    }

    private synchronized IRemoteFile getRemoteFileObject(IProgressMonitor monitor, boolean forceExists) throws CoreException {
        RSEFileStore parentStore;
        IRemoteFile remoteFile = this.getCachedRemoteFile();
        if (remoteFile != null) {
            if (remoteFile.getParentRemoteFileSubSystem().isConnected()) {
                return remoteFile;
            }
            remoteFile = null;
            this.cacheRemoteFile(null);
        }
        if ((parentStore = this._parent.getParentStore()) != null) {
            IRemoteFile parent = parentStore.getImpl().getRemoteFileObject(monitor, forceExists);
            if (parent == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get remote file"));
            }
            try {
                remoteFile = parent.getParentRemoteFileSubSystem().getRemoteFileObject(parent, this._parent.getName(), monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get remote file", (Throwable)e));
            }
        }
        IRemoteFileSubSystem subSys = RSEFileStoreImpl.getConnectedFileSubSystem(this._parent.getHost(), monitor);
        try {
            remoteFile = subSys.getRemoteFileObject(this._parent.getAbsolutePath(), monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get remote file", (Throwable)e));
        }
        this.cacheRemoteFile(remoteFile);
        if (forceExists && (remoteFile == null || !remoteFile.exists())) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "The file store does not exist"));
        }
        return remoteFile;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        String[] names;
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.isStale() && remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) && !(subSys instanceof IFileServiceSubSystem)) {
            Object[] children = remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            names = new String[children.length];
            int i = 0;
            while (i < children.length) {
                names[i] = ((IRemoteFile)children[i]).getName();
                ++i;
            }
        } else {
            try {
                IRemoteFile[] children = null;
                if (subSys instanceof FileServiceSubSystem) {
                    FileServiceSubSystem fileServiceSubSystem = (FileServiceSubSystem)subSys;
                    IHostFile[] results = fileServiceSubSystem.getFileService().getFilesAndFolders(remoteFile.getAbsolutePath(), "*", monitor);
                    IRemoteFileSubSystemConfiguration config = subSys.getParentRemoteFileSubSystemConfiguration();
                    RemoteFileFilterString filterString = new RemoteFileFilterString(config, remoteFile.getAbsolutePath(), "*");
                    filterString.setShowFiles(true);
                    filterString.setShowSubDirs(true);
                    RemoteFileContext context = new RemoteFileContext(subSys, remoteFile, filterString);
                    children = fileServiceSubSystem.getHostFileToRemoteFileAdapter().convertToRemoteFiles(fileServiceSubSystem, (IRemoteFileContext)context, remoteFile, results);
                } else {
                    children = subSys.listFoldersAndFiles(remoteFile, "*", monitor);
                }
                names = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    names[i] = children[i].getName();
                    ++i;
                }
            }
            catch (SystemMessageException systemMessageException) {
                names = new String[]{};
            }
        }
        return names;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo[] infos;
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.isStale() && remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) && !(subSys instanceof IFileServiceSubSystem)) {
            Object[] children = remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            infos = new FileInfo[children.length];
            int i = 0;
            while (i < children.length) {
                IRemoteFile file = (IRemoteFile)children[i];
                FileInfo info = new FileInfo(file.getName());
                if (!file.exists()) {
                    info.setExists(false);
                } else {
                    info.setExists(true);
                    info.setLastModified(file.getLastModified());
                    boolean isDir = file.isDirectory();
                    info.setDirectory(isDir);
                    info.setAttribute(2, !file.canWrite());
                    info.setAttribute(4, file.isExecutable());
                    info.setAttribute(8, file.isArchive());
                    info.setAttribute(16, file.isHidden());
                    if (!isDir) {
                        info.setLength(file.getLength());
                    }
                }
                infos[i] = info;
                ++i;
            }
        } else {
            try {
                IRemoteFile[] children = null;
                if (subSys instanceof FileServiceSubSystem) {
                    FileServiceSubSystem fileServiceSubSystem = (FileServiceSubSystem)subSys;
                    IHostFile[] results = fileServiceSubSystem.getFileService().getFilesAndFolders(remoteFile.getAbsolutePath(), "*", monitor);
                    IRemoteFileSubSystemConfiguration config = subSys.getParentRemoteFileSubSystemConfiguration();
                    RemoteFileFilterString filterString = new RemoteFileFilterString(config, remoteFile.getAbsolutePath(), "*");
                    filterString.setShowFiles(true);
                    filterString.setShowSubDirs(true);
                    RemoteFileContext context = new RemoteFileContext(subSys, remoteFile, filterString);
                    children = fileServiceSubSystem.getHostFileToRemoteFileAdapter().convertToRemoteFiles(fileServiceSubSystem, (IRemoteFileContext)context, remoteFile, results);
                } else {
                    children = subSys.listFoldersAndFiles(remoteFile, "*", monitor);
                }
                infos = new FileInfo[children.length];
                int i = 0;
                while (i < children.length) {
                    IRemoteFile file = children[i];
                    FileInfo info = new FileInfo(file.getName());
                    if (!file.exists()) {
                        info.setExists(false);
                    } else {
                        info.setExists(true);
                        info.setLastModified(file.getLastModified());
                        boolean isDir = file.isDirectory();
                        info.setDirectory(isDir);
                        info.setAttribute(2, !file.canWrite());
                        info.setAttribute(4, file.isExecutable());
                        info.setAttribute(8, file.isArchive());
                        info.setAttribute(16, file.isHidden());
                        if (!isDir) {
                            info.setLength(file.getLength());
                        }
                    }
                    infos[i] = info;
                    ++i;
                }
            }
            catch (SystemMessageException systemMessageException) {
                infos = new FileInfo[]{};
            }
        }
        return infos;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        FileInfo info = new FileInfo(this._parent.getName());
        if (remoteFile == null || !remoteFile.exists()) {
            info.setExists(false);
            return info;
        }
        info.setExists(true);
        info.setLastModified(remoteFile.getLastModified());
        boolean isDir = remoteFile.isDirectory();
        info.setDirectory(isDir);
        info.setAttribute(2, !remoteFile.canWrite());
        info.setAttribute(4, remoteFile.isExecutable());
        info.setAttribute(8, remoteFile.isArchive());
        info.setAttribute(16, remoteFile.isHidden());
        if (!isDir) {
            info.setLength(remoteFile.getLength());
        }
        return info;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, true);
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (remoteFile.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "The file store represents a directory"));
        }
        if (remoteFile.isFile()) {
            try {
                return subSys.getInputStream(remoteFile.getParentPath(), remoteFile.getName(), true, monitor);
            }
            catch (SystemMessageException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get input stream", (Throwable)e));
            }
        }
        return null;
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        if (remoteFile == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get remote file"));
        }
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.exists()) {
            try {
                remoteFile = subSys.createFolder(remoteFile, monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "The directory could not be created", (Throwable)e));
            }
            return this._parent;
        }
        if (remoteFile.isFile()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "A file of that name already exists"));
        }
        return this._parent;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        if (remoteFile == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get remote file"));
        }
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.exists()) {
            try {
                remoteFile = subSys.createFile(remoteFile, monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not create file", (Throwable)e));
            }
        }
        if (remoteFile.isFile()) {
            try {
                return subSys.getOutputStream(remoteFile.getParentPath(), remoteFile.getName(), true, monitor);
            }
            catch (SystemMessageException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get output stream", (Throwable)e));
            }
        }
        if (remoteFile.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "This is a directory"));
        }
        return null;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(monitor, false);
        if (remoteFile == null || !remoteFile.exists()) {
            return;
        }
        IRemoteFileSubSystem subSys = remoteFile.getParentRemoteFileSubSystem();
        try {
            boolean success = subSys.delete(remoteFile, monitor);
            if (!success) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not delete file"));
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not delete file", (Throwable)e));
        }
    }
}

