/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ResourceBundle;

public class ServerLogger {
    private static final String DEBUG_LEVEL = "debug_level";
    private static final String LOG_LOCATION = "log_location";
    private static final int LOG_WARNING = 1;
    private static final int LOG_INFO = 2;
    private static final int LOG_DEBUG = 3;
    private static final String LOG_TO_STDOUT = "Log_To_StdOut";
    private static Object writeLock = new Object();
    private static PrintWriter _logFileStream = null;
    public static final boolean DEBUG = false;
    private static int log_level = 0;

    public ServerLogger(String logPathName) {
        if (_logFileStream == null) {
            boolean logToFile = true;
            try {
                ResourceBundle properties = ResourceBundle.getBundle("rsecomm");
                String debug_level = properties.getString(DEBUG_LEVEL).trim();
                log_level = Integer.parseInt(debug_level);
                String log_location = properties.getString(LOG_LOCATION).trim();
                if (log_location.equalsIgnoreCase(LOG_TO_STDOUT)) {
                    logToFile = false;
                    _logFileStream = new PrintWriter(System.out);
                }
            }
            catch (Exception exception) {}
            if (logToFile) {
                try {
                    File _logFile = new File(logPathName, "rsecomm.log");
                    if (!_logFile.exists()) {
                        _logFile.createNewFile();
                    }
                    _logFileStream = new PrintWriter(new FileOutputStream(_logFile));
                }
                catch (IOException iOException) {
                    System.out.println("Error opening log file " + logPathName + "rsecomm.log");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logInfo(String minerName, String message) {
        if (log_level >= 2 && _logFileStream != null) {
            Object object = writeLock;
            synchronized (object) {
                try {
                    _logFileStream.println(new Date());
                    _logFileStream.println("INFO " + minerName + ": " + message);
                    _logFileStream.println("---------------------------------------------------------------");
                    _logFileStream.flush();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logWarning(String minerName, String message) {
        if (log_level >= 1 && _logFileStream != null) {
            Object object = writeLock;
            synchronized (object) {
                try {
                    _logFileStream.println(new Date());
                    _logFileStream.println("WARNING " + minerName + ": " + message);
                    _logFileStream.println("---------------------------------------------------------------");
                    _logFileStream.flush();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logError(String minerName, String message, Throwable exception) {
        if (_logFileStream != null) {
            Object object = writeLock;
            synchronized (object) {
                try {
                    _logFileStream.println(new Date());
                    _logFileStream.println("ERROR " + minerName + ": " + message);
                    if (exception != null) {
                        exception.printStackTrace(_logFileStream);
                    }
                    _logFileStream.println("---------------------------------------------------------------");
                    _logFileStream.flush();
                }
                catch (Exception exception2) {}
            }
        }
    }

    public static synchronized void logDebugMessage(String minerName, String message) {
    }
}

