/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.services.clientserver.messages.ISystemMessageProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.dstore.IDStoreService;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;

public abstract class AbstractDStoreService
implements IDStoreService {
    protected IDataStoreProvider _dataStoreProvider;
    protected ISystemMessageProvider _msgProvider;
    protected DataElement _minerElement;
    protected DStoreStatusMonitor _statusMonitor;
    protected Map _cmdDescriptorMap;
    protected DataElement _initializeStatus;

    public AbstractDStoreService(IDataStoreProvider dataStoreProvider, ISystemMessageProvider msgProvider) {
        this._dataStoreProvider = dataStoreProvider;
        this._msgProvider = msgProvider;
        this._cmdDescriptorMap = new HashMap();
    }

    public DStoreStatusMonitor getStatusMonitor(DataStore dataStore) {
        if (this._statusMonitor == null || this._statusMonitor.getDataStore() != dataStore) {
            this._statusMonitor = new DStoreStatusMonitor(dataStore);
        }
        return this._statusMonitor;
    }

    public DataStore getDataStore() {
        return this._dataStoreProvider.getDataStore();
    }

    protected DataElement getMinerElement() {
        if (this._minerElement == null || this._minerElement.getDataStore() != this.getDataStore()) {
            this._minerElement = this.getMinerElement(this.getMinerId());
        }
        return this._minerElement;
    }

    protected DataElement getMinerElement(String id) {
        return this.getDataStore().findMinerInformation(id);
    }

    protected DataElement[] dsQueryCommand(DataElement subject, ArrayList args, String command, IProgressMonitor monitor) {
        block4: {
            DataElement queryCmd = this.getCommandDescriptor(subject, command);
            if (queryCmd != null) {
                DataElement status = this.getDataStore().command(queryCmd, args, subject, true);
                try {
                    DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                    smon.waitForUpdate(status, monitor);
                    int resultSize = subject.getNestedSize();
                    this.checkHostJVM();
                    List nested = subject.getNestedData();
                    if (nested != null) {
                        return nested.toArray(new DataElement[resultSize]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block4;
                    monitor.setCanceled(true);
                }
            }
        }
        return new DataElement[0];
    }

    protected DataElement dsStatusCommand(DataElement subject, ArrayList args, String command, IProgressMonitor monitor) {
        DataElement queryCmd = this.getCommandDescriptor(subject, command);
        if (queryCmd != null) {
            DataElement status;
            block3: {
                status = this.getDataStore().command(queryCmd, args, subject, true);
                try {
                    DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                    smon.waitForUpdate(status, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            return status;
        }
        return null;
    }

    protected DataElement[] dsQueryCommand(DataElement subject, String command, IProgressMonitor monitor) {
        block4: {
            DataElement queryCmd = this.getCommandDescriptor(subject, command);
            if (queryCmd != null) {
                DataStore ds = this.getDataStore();
                DataElement status = ds.command(queryCmd, subject, true);
                try {
                    this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                    this.checkHostJVM();
                    List nested = subject.getNestedData();
                    if (nested != null) {
                        return nested.toArray(new DataElement[subject.getNestedSize()]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block4;
                    monitor.setCanceled(true);
                }
            }
        }
        return new DataElement[0];
    }

    protected DataElement dsStatusCommand(DataElement subject, String command, IProgressMonitor monitor) {
        DataElement queryCmd = this.getCommandDescriptor(subject, command);
        if (queryCmd != null) {
            DataElement status;
            block3: {
                DataStore ds = this.getDataStore();
                status = ds.command(queryCmd, subject, true);
                try {
                    this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            return status;
        }
        return null;
    }

    protected DataElement getCommandDescriptor(DataElement subject, String command) {
        DataStore ds = this.getDataStore();
        DataElement cmd = (DataElement)this._cmdDescriptorMap.get(command);
        if (cmd == null || ds != cmd.getDataStore()) {
            cmd = this.getDataStore().localDescriptorQuery(subject.getDescriptor(), command);
            this._cmdDescriptorMap.put(command, cmd);
        }
        return cmd;
    }

    public int getServerVersion() {
        return this.getDataStore().getServerVersion();
    }

    public int getServerMinor() {
        return this.getDataStore().getServerMinor();
    }

    protected void checkHostJVM() {
    }

    public boolean isInitialized() {
        if (this._initializeStatus != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            return smon.determineStatusDone(this._initializeStatus);
        }
        return false;
    }

    protected void waitForInitialize(IProgressMonitor monitor) {
        if (this._initializeStatus != null) {
            block3: {
                DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                try {
                    smon.waitForUpdate(this._initializeStatus, monitor, 100);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            this.getMinerElement();
        }
    }

    public void initService(IProgressMonitor monitor) {
        this.initMiner(monitor);
    }

    public void uninitService(IProgressMonitor monitor) {
        this._initializeStatus = null;
        this._cmdDescriptorMap.clear();
        this._minerElement = null;
        this._statusMonitor = null;
    }

    protected void initMiner(IProgressMonitor monitor) {
        DataElement fsElement = this.getMinerElement();
        if (fsElement == null && this.getServerVersion() >= 8) {
            String minerId = this.getMinerId();
            String message = SystemMessage.sub((String)ServiceResources.DStore_Service_ProgMon_Initializing_Message, (String)"&1", (String)minerId);
            monitor.beginTask(message, -1);
            DataStore ds = this.getDataStore();
            if ((this._minerElement == null || this._minerElement.getDataStore() != ds) && ds != null && this._initializeStatus == null) {
                this._initializeStatus = ds.activateMiner(minerId);
            }
        }
        monitor.done();
    }

    protected abstract String getMinerId();

    public SystemMessage getMessage(String messageID) {
        return this._msgProvider.getMessage(messageID);
    }
}

