/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;

public abstract class AbstractFileService
implements IFileService {
    public static final int FILE_TYPE_FILES_AND_FOLDERS = 0;
    public static final int FILE_TYPE_FILES = 1;
    public static final int FILE_TYPE_FOLDERS = 2;

    public IHostFile[] getFiles(String remoteParent, String fileFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.internalFetch(remoteParent, fileFilter, 1, monitor);
    }

    public IHostFile[] getFolders(String remoteParent, String fileFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.internalFetch(remoteParent, fileFilter, 2, monitor);
    }

    public IHostFile[] getFilesAndFolders(String parentPath, String fileFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.internalFetch(parentPath, fileFilter, 0, monitor);
    }

    protected abstract IHostFile[] internalFetch(String var1, String var2, int var3, IProgressMonitor var4) throws SystemMessageException;

    protected boolean isRightType(int fileType, IHostFile node) {
        switch (fileType) {
            case 0: {
                return true;
            }
            case 1: {
                return node.isFile();
            }
            case 2: {
                return node.isDirectory();
            }
        }
        return true;
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }

    public boolean deleteBatch(String[] remoteParents, String[] fileNames, IProgressMonitor monitor) throws SystemMessageException {
        boolean ok = true;
        int i = 0;
        while (i < remoteParents.length) {
            ok = ok && this.delete(remoteParents[i], fileNames[i], monitor);
            ++i;
        }
        return ok;
    }

    public String getEncoding(IProgressMonitor monitor) throws SystemMessageException {
        return System.getProperty("file.encoding");
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }
}

