/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;

public class HostSearchResultSet
implements IHostSearchResultSet,
IAdaptable {
    protected Vector configurations = new Vector();
    protected String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addSearchConfiguration(IHostSearchResultConfiguration config) {
        this.configurations.add(config);
    }

    public void removeSearchConfiguration(IHostSearchResultConfiguration config) {
        this.configurations.remove(config);
    }

    public Iterator getSearchConfigurations() {
        return this.configurations.iterator();
    }

    public void addResult(IHostSearchResultConfiguration config, Object result) {
        config.addResult(result);
    }

    public void removeResult(IHostSearchResultConfiguration config, Object result) {
        config.removeResult(result);
    }

    public Object[] getResultsForConfiguration(IHostSearchResultConfiguration config) {
        return config.getResults();
    }

    public Object[] getAllResults() {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            list.addAll(Arrays.asList(config.getResults()));
        }
        return list.toArray();
    }

    public void removeAllResults() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            config.removeResults();
        }
    }

    public int getNumOfResults() {
        int resultSize = 0;
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            resultSize += config.getResultsSize();
        }
        return resultSize;
    }

    public void cancel() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            if (config.getStatus() != 0) continue;
            config.cancel();
        }
    }

    public void removeResult(Object result) {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            config.removeResult(result);
        }
    }

    public void removeAndAddResult(Object oldResult, Object newResult) {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            config.removeAndAddResult(oldResult, newResult);
        }
    }

    public void dispose() {
        this.cancel();
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            config.dispose();
        }
        this.configurations.removeAllElements();
    }

    public boolean isCancelled() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            if (config.getStatus() == 2) continue;
            return false;
        }
        return true;
    }

    public boolean isFinished() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            if (config.getStatus() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            if (config.getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isDisconnected() {
        Iterator iter = this.getSearchConfigurations();
        while (iter.hasNext()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
            if (config.getStatus() == 3) continue;
            return false;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

