/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.shells;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.services.shells.HostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public abstract class AbstractHostShellOutputReader
extends Thread
implements IHostShellOutputReader {
    protected List _listeners;
    protected int _waitIncrement = 2;
    protected boolean _keepRunning = true;
    protected List _linesOfOutput;
    protected int _consumerOffset;
    protected IHostShell _hostShell;
    protected boolean _isErrorReader = false;
    protected long _timeOfLastEvent = 0L;
    protected int _sizeAtLastEvent = 0;

    public AbstractHostShellOutputReader(IHostShell hostShell, boolean isErrorReader) {
        this._hostShell = hostShell;
        this._listeners = new ArrayList();
        this._linesOfOutput = new ArrayList();
        this._consumerOffset = 0;
        this._isErrorReader = isErrorReader;
        this._timeOfLastEvent = System.currentTimeMillis();
    }

    public boolean isErrorReader() {
        return this._isErrorReader;
    }

    public IHostShell getHostShell() {
        return this._hostShell;
    }

    public void setWaitTime(int value) {
        this._waitIncrement = value;
    }

    public int getWaitTime() {
        return this._waitIncrement;
    }

    public void handle() {
        IHostOutput line = this.internalReadLine();
        if (line != null) {
            this.addLine(line);
        } else {
            this.finish();
            this._keepRunning = false;
        }
    }

    protected void addLine(IHostOutput line) {
        this._linesOfOutput.add(line);
        int sizenow = this._linesOfOutput.size();
        int deltaSize = sizenow - this._sizeAtLastEvent;
        long timenow = System.currentTimeMillis();
        HostShellChangeEvent event = new HostShellChangeEvent(this._hostShell, this, this._sizeAtLastEvent, deltaSize);
        this.fireOutputChanged(event);
        this._timeOfLastEvent = timenow;
        this._sizeAtLastEvent = sizenow;
    }

    public IHostOutput readLine() {
        if (!this.isAlive()) {
            this.internalReadLine();
            this.start();
        }
        return (IHostOutput)this._linesOfOutput.get(this._consumerOffset++);
    }

    public IHostOutput readLine(int lineNumber) {
        return (IHostOutput)this._linesOfOutput.get(lineNumber);
    }

    public void setLineOffset(int lineNumber) {
        this._consumerOffset = lineNumber;
    }

    public void addOutputListener(IHostShellOutputListener listener) {
        this._listeners.add(listener);
        if (!this.isAlive()) {
            this.start();
        }
    }

    public void fireOutputChanged(IHostShellChangeEvent event) {
        int i = 0;
        while (i < this._listeners.size()) {
            IHostShellOutputListener listener = (IHostShellOutputListener)this._listeners.get(i);
            listener.shellOutputChanged(event);
            ++i;
        }
        if (!this._keepRunning) {
            this.dispose();
        }
    }

    public void dispose() {
        this._listeners.clear();
    }

    public boolean isFinished() {
        return !this._keepRunning;
    }

    public void finish() {
        if (this._keepRunning) {
            this._waitIncrement = 0;
        }
    }

    public void run() {
        while (this._keepRunning) {
            try {
                Thread.sleep(this._waitIncrement);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.finish();
                return;
            }
            this.handle();
        }
    }

    protected abstract IHostOutput internalReadLine();
}

