/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;

public class SystemFileTransferModeMapping
implements ISystemFileTransferModeMapping,
Cloneable {
    private String name;
    private String extension;
    private boolean isBinary = true;

    public SystemFileTransferModeMapping(String extension) {
        this("*", extension);
    }

    public SystemFileTransferModeMapping(String name, String extension) {
        if (name == null || name.length() < 1) {
            this.setName("*");
        } else {
            this.setName(name);
        }
        this.setExtension(extension);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getLabel() {
        if (this.extension != null) {
            return String.valueOf(this.name) + "." + this.extension;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean isText() {
        return !this.isBinary();
    }

    public void setAsBinary() {
        this.isBinary = true;
    }

    public void setAsText() {
        this.isBinary = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

