/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemPropertiesWizardPage;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.monitor.TabFolderLayout;
import org.eclipse.rse.ui.ISystemVerifyListener;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.ISystemConnectionWizardErrorUpdater;
import org.eclipse.rse.ui.propertypages.ISystemConnectionWizardPropertyPage;
import org.eclipse.rse.ui.wizards.AbstractSystemNewConnectionWizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class SystemSubSystemsPropertiesWizardPage
extends AbstractSystemNewConnectionWizardPage
implements ISystemVerifyListener,
ISubSystemPropertiesWizardPage {
    private ISystemConnectionWizardPropertyPage _thePage;
    private CTabFolder _folder;
    private List _propertyPages;
    private String _lastHostName;

    public SystemSubSystemsPropertiesWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory, List propertyPages) {
        super(wizard, parentFactory, parentFactory.getId(), parentFactory.getName(), SystemResources.RESID_NEWCONN_SUBSYSTEMPAGE_DESCRIPTION);
        this._propertyPages = propertyPages;
    }

    protected Control getInitialFocusControl() {
        return this.getControl();
    }

    protected void hostNameUpdated(String hostName) {
        if (this._folder != null) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                ISystemConnectionWizardPropertyPage page = (ISystemConnectionWizardPropertyPage)this._folder.getItem(i).getData();
                page.setHostname(hostName);
                ++i;
            }
        }
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        int numAdded = 0;
        if (this._propertyPages.size() == 1) {
            PropertyPage page = (PropertyPage)this._propertyPages.get(0);
            if (page != null && page instanceof ISystemConnectionWizardPropertyPage) {
                ISystemConnectionWizardPropertyPage cpage = (ISystemConnectionWizardPropertyPage)page;
                cpage.setSubSystemConfiguration(this.parentFactory);
                page.createControl(composite_prompts);
                this._thePage = cpage;
                if (this.getMainPage() != null) {
                    cpage.setHostname(this.getMainPage().getSystemConnectionForm().getHostName());
                }
                ++numAdded;
            }
        } else {
            this._folder = new CTabFolder(composite_prompts, 0);
            this._folder.setLayout((Layout)new TabFolderLayout());
            int i = 0;
            while (i < this._propertyPages.size()) {
                PropertyPage page = (PropertyPage)this._propertyPages.get(i);
                if (page != null && page instanceof ISystemConnectionWizardPropertyPage) {
                    ISystemConnectionWizardPropertyPage cpage = (ISystemConnectionWizardPropertyPage)page;
                    cpage.setSubSystemConfiguration(this.parentFactory);
                    CTabItem titem = new CTabItem(this._folder, 0, numAdded);
                    titem.setData((Object)page);
                    page.createControl((Composite)this._folder);
                    titem.setText(page.getTitle());
                    try {
                        titem.setControl(page.getControl());
                    }
                    catch (Exception exception) {}
                    if (this.getMainPage() != null) {
                        cpage.setHostname(this.getMainPage().getSystemConnectionForm().getHostName());
                    }
                    ++numAdded;
                }
                ++i;
            }
        }
        this.addVerifyListener();
        return composite_prompts;
    }

    public boolean performFinish() {
        return true;
    }

    public boolean applyValues(ISubSystem ss) {
        boolean result = true;
        if (this._folder != null) {
            int i = 0;
            while (i < this._folder.getItemCount() && result) {
                ISystemConnectionWizardPropertyPage page = (ISystemConnectionWizardPropertyPage)this._folder.getItem(i).getData();
                result = page.applyValues(ss.getConnectorService());
                ++i;
            }
        } else if (this._thePage != null) {
            this._thePage.applyValues(ss.getConnectorService());
        }
        return result;
    }

    public boolean isPageComplete() {
        String hostName;
        String string = hostName = this.getMainPage() != null ? this.getMainPage().getSystemConnectionForm().getHostName() : null;
        if (hostName != null && !hostName.equals(this._lastHostName)) {
            this.hostNameUpdated(hostName);
            this._lastHostName = hostName;
        }
        boolean result = true;
        if (this._folder != null) {
            int i = 0;
            while (i < this._folder.getItemCount() && result) {
                if (this._folder.getItem(i).getData() instanceof ISystemConnectionWizardErrorUpdater) {
                    ISystemConnectionWizardErrorUpdater page = (ISystemConnectionWizardErrorUpdater)this._folder.getItem(i).getData();
                    result = page.isPageComplete();
                }
                ++i;
            }
        } else if (this._thePage != null && this._thePage instanceof ISystemConnectionWizardErrorUpdater) {
            result = ((ISystemConnectionWizardErrorUpdater)((Object)this._thePage)).isPageComplete();
        }
        return result;
    }

    protected void addVerifyListener() {
        if (this._folder != null) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                if (this._folder.getItem(i).getData() instanceof ISystemConnectionWizardErrorUpdater) {
                    ISystemConnectionWizardErrorUpdater page = (ISystemConnectionWizardErrorUpdater)this._folder.getItem(i).getData();
                    page.addVerifyListener(this);
                }
                ++i;
            }
        } else if (this._thePage != null && this._thePage instanceof ISystemConnectionWizardErrorUpdater) {
            ((ISystemConnectionWizardErrorUpdater)((Object)this._thePage)).addVerifyListener(this);
        }
    }

    public void handleVerifyComplete() {
        boolean complete = this.isPageComplete();
        if (!complete) {
            if (this._folder != null) {
                int i = 0;
                while (i < this._folder.getItemCount()) {
                    ISystemConnectionWizardErrorUpdater page;
                    String error;
                    if (this._folder.getItem(i).getData() instanceof ISystemConnectionWizardErrorUpdater && (error = (page = (ISystemConnectionWizardErrorUpdater)this._folder.getItem(i).getData()).getTheErrorMessage()) != null && !error.equals("")) {
                        this.setErrorMessage(String.valueOf(this._folder.getItem(i).getText()) + ": " + page.getTheErrorMessage());
                    }
                    ++i;
                }
            } else if (this._thePage != null && this._thePage instanceof ISystemConnectionWizardErrorUpdater) {
                ((ISystemConnectionWizardErrorUpdater)((Object)this._thePage)).getTheErrorMessage();
            }
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete(complete);
    }
}

