/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.serial.ISerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialConnector;
import org.eclipse.tm.internal.terminal.serial.SerialPortHandler;

public class SerialConnectWorker
extends Thread {
    private final ITerminalControl fControl;
    private final SerialConnector fConn;

    public SerialConnectWorker(SerialConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    public void run() {
        try {
            this.fControl.setState(TerminalState.OPENED);
            String strID = this.getClass().getPackage().getName();
            ISerialSettings s = this.fConn.getSerialSettings();
            this.fConn.setSerialPortHandler(new SerialPortHandler(this.fConn, this.fControl));
            this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)s.getSerialPort()));
            int timeoutInMs = s.getTimeout() * 1000;
            SerialPort serialPort = (SerialPort)this.fConn.getSerialPortIdentifier().open(strID, timeoutInMs);
            serialPort.setSerialPortParams(s.getBaudRate(), s.getDataBits(), s.getStopBits(), s.getParity());
            serialPort.setFlowControlMode(s.getFlowControl());
            serialPort.addEventListener((SerialPortEventListener)this.fConn.getSerialPortHandler());
            serialPort.notifyOnDataAvailable(true);
            this.fConn.getSerialPortIdentifier().addPortOwnershipListener((CommPortOwnershipListener)this.fConn.getSerialPortHandler());
            this.fConn.setSerialPort(serialPort);
            this.fControl.setState(TerminalState.CONNECTED);
        }
        catch (PortInUseException portInUseException) {
            this.fConn.setPortInUse(true);
            this.fControl.setState(TerminalState.CLOSED);
            this.fControl.setMsg("Connection Error!\n" + portInUseException.getMessage());
        }
        catch (Exception exception) {
            this.fControl.setState(TerminalState.CLOSED);
        }
    }
}

