/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.ISystemAddFileListener;
import org.eclipse.rse.files.ui.widgets.SystemSelectRemoteFileOrFolderForm;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewForm;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectRemoteFileOrFolderDialog
extends SystemPromptDialog {
    public static final boolean FILE_MODE = true;
    public static final boolean FOLDER_MODE = false;
    protected SystemSelectRemoteFileOrFolderForm form;
    private boolean multipleSelectionMode;
    protected IHost outputConnection;
    private ISystemAddFileListener addButtonCallback = null;

    public SystemSelectRemoteFileOrFolderDialog(Shell shell, boolean fileMode) {
        this(shell, fileMode ? SystemFileResources.RESID_SELECTFILE_TITLE : SystemFileResources.RESID_SELECTDIRECTORY_TITLE, fileMode);
    }

    public SystemSelectRemoteFileOrFolderDialog(Shell shell, String title, boolean fileMode) {
        super(shell, title);
        super.setBlockOnOpen(true);
        this.form = this.getForm(fileMode);
    }

    public void setAllowForMultipleParents(boolean flag) {
        this.form.setAllowForMultipleParents(flag);
    }

    public void setSystemConnection(IHost conn) {
        this.form.setSystemConnection(conn);
    }

    public void setDefaultConnection(IHost conn) {
        this.form.setDefaultConnection(conn);
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.form.setSystemTypes(systemTypes);
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.form.setShowNewConnectionPrompt(show);
    }

    public void setMessage(String message) {
        this.form.setMessage(message);
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.form.setSelectionTreeToolTipText(tip);
    }

    public void setAutoExpandDepth(int depth) {
        this.form.setAutoExpandDepth(depth);
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        this.form.setRootFolder(connection, folderAbsolutePath);
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.form.setRootFolder(rootFolder);
    }

    public void setPreSelection(IRemoteFile selection) {
        this.form.setPreSelection(selection);
    }

    public void setFileTypes(String[] fileTypes) {
        this.form.setFileTypes(fileTypes);
    }

    public void setFileTypes(String fileTypes) {
        this.form.setFileTypes(fileTypes);
    }

    public void setRestrictFolders(boolean restrict) {
        this.form.setRestrictFolders(restrict);
    }

    public void enableAddMode(ISystemAddFileListener caller) {
        this.addButtonCallback = caller;
        this.form.enableAddMode(caller);
        this.setShowAddButton(true);
        this.enableAddButton(false);
        this.setShowOkButton(false);
        this.setCancelButtonLabel(SystemResources.BUTTON_CLOSE);
    }

    public void enableAddMode(ISystemAddFileListener caller, String addLabel, String addToolTipText) {
        this.enableAddMode(caller);
        if (addLabel != null) {
            this.setAddButtonLabel(addLabel);
        }
        if (addToolTipText != null) {
            this.setAddButtonToolTipText(addToolTipText);
        }
    }

    public void setShowPropertySheet(boolean show) {
        this.form.setShowPropertySheet(show);
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        if (show) {
            this.form.setShowPropertySheet(initialState);
            this.setShowDetailsButton(true, !initialState);
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
        this.form.setMultipleSelectionMode(multiple);
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.form.setSelectionValidator(selectionValidator);
    }

    public Object getSelectedObject() {
        if (this.getOutputObject() instanceof Object[]) {
            return ((Object[])this.getOutputObject())[0];
        }
        return this.getOutputObject();
    }

    public Object[] getSelectedObjects() {
        if (this.getOutputObject() instanceof Object[]) {
            return (Object[])this.getOutputObject();
        }
        if (this.getOutputObject() != null) {
            return new Object[]{this.getOutputObject()};
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    public boolean getMultipleSelectionMode() {
        return this.multipleSelectionMode;
    }

    public SystemViewForm getSystemViewForm() {
        return this.form.getSystemViewForm();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.form.getSystemViewForm().getSystemView().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemSelectRemoteFileOrFolderDialog.this.handleDoubleClick(event);
            }
        });
        return control;
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        SystemView tree = this.form.getSystemViewForm().getSystemView();
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        if (this.form.isPageComplete() && !tree.isExpandable(element)) {
            this.setReturnCode(0);
            if (this.processOK()) {
                this.okPressed = true;
                this.close();
            }
        }
    }

    protected Control getInitialFocusControl() {
        return this.form.getInitialFocusControl();
    }

    protected Control createInner(Composite parent) {
        return this.form.createContents(this.getShell(), parent);
    }

    protected SystemSelectRemoteFileOrFolderForm getForm(boolean fileMode) {
        this.form = new SystemSelectRemoteFileOrFolderForm(this.getMessageLine(), (Object)this, fileMode);
        this.setOutputObject(null);
        this.outputConnection = null;
        return this.form;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        ISystemMessageLine msgLine = super.createMessageLine(c);
        if (this.form != null) {
            this.form.setMessageLine(msgLine);
        }
        return msgLine;
    }

    protected boolean processOK() {
        boolean closeDialog = this.form.verify();
        if (closeDialog) {
            this.outputConnection = this.form.getSelectedConnection();
            if (this.multipleSelectionMode) {
                this.setOutputObject(this.form.getSelectedObjects());
            } else {
                this.setOutputObject(this.form.getSelectedObject());
            }
        } else {
            this.setOutputObject(null);
        }
        return closeDialog;
    }

    protected boolean processAdd() {
        Object errMsg = this.addButtonCallback.addButtonPressed(this.form.getSelectedConnection(), (IRemoteFile[])this.form.getSelectedObjects());
        if (errMsg != null) {
            if (errMsg instanceof String) {
                this.setErrorMessage((String)errMsg);
            } else {
                this.setErrorMessage((SystemMessage)errMsg);
            }
        } else {
            this.clearErrorMessage();
        }
        this.enableAddButton(false);
        return false;
    }

    protected boolean processDetails(boolean hideMode) {
        this.form.toggleShowPropertySheet(this.getShell(), this.getContents());
        return true;
    }

    public void setPageComplete(boolean complete) {
        if (this.addButtonCallback != null) {
            this.enableAddButton(complete);
        } else {
            super.setPageComplete(complete);
        }
    }

    public boolean close() {
        if (super.close()) {
            if (this.form != null) {
                this.form.dispose();
            }
            this.form = null;
            return true;
        }
        return false;
    }

    public void addViewerFilter(ViewerFilter filter) {
        if (this.form != null) {
            this.form.addViewerFilter(filter);
        }
    }

    public void setAllowFolderSelection(boolean allow) {
        if (this.form != null) {
            this.form.setAllowFolderSelection(allow);
        }
    }
}

