/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemTempFileListener;
import org.eclipse.rse.internal.files.ui.actions.SystemUploadConflictAction;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.DisplaySystemMessageAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class SystemUniversalTempFileListener
extends SystemTempFileListener {
    private static SystemUniversalTempFileListener _instance = null;
    private ArrayList _editedFiles = new ArrayList();

    public static SystemUniversalTempFileListener getListener() {
        if (_instance == null) {
            _instance = new SystemUniversalTempFileListener();
        }
        return _instance;
    }

    public void registerEditedFile(SystemEditableRemoteFile editMember) {
        this._editedFiles.add(editMember);
    }

    public void unregisterEditedFile(SystemEditableRemoteFile editMember) {
        this._editedFiles.remove(editMember);
    }

    public SystemEditableRemoteFile getEditedFile(IRemoteFile file) {
        int i = 0;
        while (i < this._editedFiles.size()) {
            IRemoteFile editedFile;
            SystemEditableRemoteFile efile = (SystemEditableRemoteFile)this._editedFiles.get(i);
            if (efile != null && (editedFile = efile.getRemoteFile()).getAbsolutePathPlusConnection().equals(file.getAbsolutePathPlusConnection())) {
                return efile;
            }
            ++i;
        }
        return null;
    }

    protected boolean doesHandle(ISubSystem subsystem) {
        return subsystem instanceof IRemoteFileSubSystem;
    }

    protected void doResourceSynchronization(ISubSystem subsystem, IFile tempFile, String resourceId, IProgressMonitor monitor) {
        if (subsystem instanceof IRemoteFileSubSystem) {
            boolean isMounted;
            IRemoteFileSubSystem fs = (IRemoteFileSubSystem)subsystem;
            SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
            if (fs.isOffline()) {
                properties.setDirty(true);
                return;
            }
            if (fs.getHost().getSystemType().isLocal() && (isMounted = properties.getRemoteFileMounted())) {
                String mappedHostPath = properties.getResolvedMountedRemoteFilePath();
                String mappedHostName = properties.getResolvedMountedRemoteFileHost();
                String systemRemotePath = SystemRemoteEditManager.getInstance().getMountPathFor(mappedHostName, mappedHostPath);
                if (systemRemotePath == null) {
                    return;
                }
                if (!systemRemotePath.equals(resourceId)) {
                    resourceId = systemRemotePath;
                    properties.setRemoteFilePath(systemRemotePath);
                }
            }
            try {
                IRemoteFile remoteFile = fs.getRemoteFileObject(resourceId, monitor);
                if (remoteFile != null) {
                    remoteFile.markStale(true);
                    remoteFile = fs.getRemoteFileObject(resourceId, monitor);
                    long storedModifiedStamp = properties.getRemoteFileTimeStamp();
                    SystemEditableRemoteFile editable = this.getEditedFile(remoteFile);
                    if (editable != null && storedModifiedStamp == 0L) {
                        return;
                    }
                    if (editable == null) {
                        Object remoteObject = properties.getRemoteFileObject();
                        editable = remoteObject != null && remoteObject instanceof SystemEditableRemoteFile ? (SystemEditableRemoteFile)remoteObject : new SystemEditableRemoteFile(remoteFile);
                        final SystemEditableRemoteFile fEditable = editable;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                try {
                                    if (fEditable.checkOpenInEditor() != -1) {
                                        fEditable.openEditor();
                                    }
                                    fEditable.addAsListener();
                                }
                                catch (PartInitException partInitException) {}
                            }
                        });
                        editable.setLocalResourceProperties();
                    }
                    this.upload(fs, remoteFile, tempFile, properties, storedModifiedStamp, editable, monitor);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getMessage());
            }
        }
    }

    public void upload(IRemoteFileSubSystem fs, IRemoteFile remoteFile, IFile tempFile, SystemIFileProperties properties, long storedModifiedStamp, SystemEditableRemoteFile editable, IProgressMonitor monitor) {
        block11: {
            try {
                boolean remoteFileDeleted;
                long remoteModifiedStamp = remoteFile.getLastModified();
                boolean bl = remoteFileDeleted = !remoteFile.exists();
                if (remoteFileDeleted || storedModifiedStamp == remoteModifiedStamp) {
                    DisplaySystemMessageAction msgAction;
                    try {
                        String srcEncoding = tempFile.getCharset(true);
                        if (srcEncoding == null) {
                            srcEncoding = remoteFile.getEncoding();
                        }
                        fs.upload(tempFile.getLocation().makeAbsolute().toOSString(), remoteFile, srcEncoding, monitor);
                    }
                    catch (RemoteFileSecurityException e) {
                        msgAction = new DisplaySystemMessageAction(e.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction);
                    }
                    catch (RemoteFileIOException e) {
                        msgAction = new DisplaySystemMessageAction(e.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction);
                    }
                    catch (Exception e) {
                        RemoteFileIOException exc = new RemoteFileIOException(e);
                        DisplaySystemMessageAction msgAction2 = new DisplaySystemMessageAction(exc.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction2);
                    }
                    remoteFile.markStale(true);
                    IRemoteFile parent = remoteFile.getParentRemoteFile();
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    if (parent != null) {
                        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)parent, 82, null));
                    }
                    remoteFile = fs.getRemoteFileObject(remoteFile.getAbsolutePath(), monitor);
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 86, (Object)remoteFile));
                    properties.setRemoteFileTimeStamp(remoteFile.getLastModified());
                    properties.setDirty(false);
                    editable.updateDirtyIndicator();
                    break block11;
                }
                if (storedModifiedStamp == -1L) {
                    properties.setRemoteFileTimeStamp(remoteFile.getLastModified());
                } else {
                    final boolean remoteNewer = remoteModifiedStamp > storedModifiedStamp;
                    final SystemEditableRemoteFile remoteEdit = editable;
                    final IFile tFile = tempFile;
                    final IRemoteFile rFile = remoteFile;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = RSEUIPlugin.getTheSystemRegistryUI().getShell();
                            SystemUploadConflictAction conflictAction = new SystemUploadConflictAction(shell, tFile, rFile, remoteNewer);
                            conflictAction.run();
                            remoteEdit.updateDirtyIndicator();
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

