/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.actions.SystemCopyRemoteFileAction;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemMoveRemoteFileAction
extends SystemCopyRemoteFileAction
implements IValidatorRemoteSelection {
    private SystemMessage targetEqualsSrcMsg = null;
    private SystemMessage targetDescendsFromSrcMsg = null;
    protected Vector movedFiles = new Vector();

    public SystemMoveRemoteFileAction(Shell shell) {
        super(shell, 1);
        this.setHelp("org.eclipse.rse.ui.actn0111");
        this.setDialogHelp("org.eclipse.rse.ui.dmrf0000");
    }

    protected void reset() {
        this.movedFiles.clear();
        super.reset();
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        IRemoteFile targetFolder = (IRemoteFile)targetContainer;
        IRemoteFile srcFileOrFolder = (IRemoteFile)oldObject;
        IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
        boolean ok = false;
        ok = ss.move(srcFileOrFolder, targetFolder, newName, monitor);
        if (!ok) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF1307");
            msg.makeSubstitution((Object)srcFileOrFolder.getName());
            throw new SystemMessageException(msg);
        }
        String sep = targetFolder.getSeparator();
        String targetFolderName = targetFolder.getAbsolutePath();
        String resultPath = null;
        resultPath = !targetFolderName.endsWith(sep) ? String.valueOf(targetFolderName) + sep + newName : String.valueOf(targetFolderName) + newName;
        this.copiedFiles.addElement(resultPath);
        this.movedFiles.add(srcFileOrFolder);
        return ok;
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        IRemoteFile[] files = this.getSelectedFiles();
        Object selectedObject = selectedObjects[0];
        if (!(selectedObject instanceof IRemoteFile) || files == null) {
            return null;
        }
        IRemoteFile selectedFolder = (IRemoteFile)selectedObject;
        String selectedFolderPath = selectedFolder.getAbsolutePath();
        int i = 0;
        while (i < files.length) {
            IRemoteFile selectedFile = files[i];
            if (selectedFile != null && selectedFile.getParentRemoteFile() != null) {
                IRemoteFile selectedParentFile = selectedFile.getParentRemoteFile();
                if (selectedFolderPath.equals(selectedParentFile.getAbsolutePath())) {
                    if (this.targetEqualsSrcMsg == null) {
                        this.targetEqualsSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1308");
                    }
                    return this.targetEqualsSrcMsg;
                }
                if (selectedFolderPath.equals(selectedFile.getAbsolutePath())) {
                    if (this.targetEqualsSrcMsg == null) {
                        this.targetEqualsSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1308");
                    }
                    return this.targetEqualsSrcMsg;
                }
                if (selectedFolder.isDescendantOf(selectedFile)) {
                    if (this.targetDescendsFromSrcMsg == null) {
                        this.targetDescendsFromSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1312");
                    }
                    return this.targetDescendsFromSrcMsg;
                }
            }
            ++i;
        }
        return null;
    }

    public void copyComplete() {
        IRemoteFileSubSystem fileSS = this.targetFolder.getParentRemoteFileSubSystem();
        RSECorePlugin.getTheSystemRegistry().fireRemoteResourceChangeEvent(2, (Object)this.movedFiles, (Object)this.firstSelectionParent.getAbsolutePath(), (ISubSystem)fileSS, null, null);
        super.copyComplete();
    }
}

