/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.ftp.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigFactory;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigProxy;
import org.eclipse.rse.internal.subsystems.files.ftp.parser.FTPClientConfigProxy;
import org.osgi.framework.Bundle;

public class FTPClientConfigFactory
implements IFTPClientConfigFactory {
    private static FTPClientConfigFactory factory = null;
    private Hashtable ftpConfigProxyById = new Hashtable();
    private Hashtable ftpParsers = new Hashtable();
    private IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rse.subsystems.files.ftp", "ftpListingParsers");
    private UnixFTPEntryParser defaultFTPEntryParser = new UnixFTPEntryParser();

    public static FTPClientConfigFactory getParserFactory() {
        if (factory == null) {
            factory = new FTPClientConfigFactory();
        }
        return factory;
    }

    private FTPClientConfigFactory() {
        IConfigurationElement[] ce = this.ep.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            String id = ce[i].getAttribute("id");
            String label = ce[i].getAttribute("label");
            String priority = ce[i].getAttribute("priority");
            String systemTypeRegex = ce[i].getAttribute("systemTypeRegex");
            String className = ce[i].getAttribute("class");
            Bundle declaringBundle = Platform.getBundle((String)ce[i].getContributor().getName());
            String listCommandModifiers = ce[i].getAttribute("listCommandModifiers");
            String defaultDateFormatStr = ce[i].getAttribute("defaultDateFormatStr");
            String recentDateFormatStr = ce[i].getAttribute("recentDateFormatStr");
            String serverLanguageCode = ce[i].getAttribute("serverLanguageCode");
            String shortMonthNames = ce[i].getAttribute("shortMonthNames");
            String serverTimeZoneId = ce[i].getAttribute("serverTimeZoneId");
            FTPClientConfigProxy ftpClientConfigProxy = new FTPClientConfigProxy(id, label, priority, systemTypeRegex, className, declaringBundle, listCommandModifiers, defaultDateFormatStr, recentDateFormatStr, serverLanguageCode, shortMonthNames, serverTimeZoneId);
            this.ftpConfigProxyById.put(id, ftpClientConfigProxy);
            ++i;
        }
    }

    public IFTPClientConfigProxy getFTPClientConfig(String parser, String systemName) {
        FTPClientConfigProxy foundFTPClientConfigProxy = null;
        if (parser.equals("AUTO")) {
            int previousPriority = Integer.MAX_VALUE;
            FTPClientConfigProxy foundProxy = null;
            Enumeration ftpConfigProxyEnum = this.ftpConfigProxyById.elements();
            while (ftpConfigProxyEnum.hasMoreElements()) {
                int priority;
                Pattern ftpSystemTypesRegex;
                FTPClientConfigProxy proxy = (FTPClientConfigProxy)ftpConfigProxyEnum.nextElement();
                if (proxy.getSystemTypeRegex() == null || !(ftpSystemTypesRegex = Pattern.compile(proxy.getSystemTypeRegex())).matcher(systemName).matches() || (priority = proxy.getPriority()) >= previousPriority) continue;
                foundProxy = proxy;
                previousPriority = priority;
            }
            if (foundProxy != null) {
                FTPClientConfig config = null;
                if (!this.ftpParsers.containsKey(foundProxy.getClassName())) {
                    FTPFileEntryParser entryParser = null;
                    try {
                        entryParser = (FTPFileEntryParser)foundProxy.getDeclaringBundle().loadClass(foundProxy.getClassName()).newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    this.ftpParsers.put(foundProxy.getClassName(), entryParser);
                }
                config = new FTPClientConfig(foundProxy.getClassName());
                config.setDefaultDateFormatStr(foundProxy.getDefaultDateFormatStr());
                config.setRecentDateFormatStr(foundProxy.getRecentDateFormatStr());
                config.setServerLanguageCode(foundProxy.getServerLanguageCode());
                config.setShortMonthNames(foundProxy.getShortMonthNames());
                config.setServerTimeZoneId(foundProxy.getServerTimeZoneId());
                foundProxy.setFTPClientConfig(config);
                foundFTPClientConfigProxy = foundProxy;
            }
        }
        if (foundFTPClientConfigProxy == null && this.ftpConfigProxyById.containsKey(parser) && (foundFTPClientConfigProxy = (FTPClientConfigProxy)this.ftpConfigProxyById.get(parser)).getFTPClientConfig() == null) {
            FTPClientConfig config = null;
            if (!this.ftpParsers.containsKey(foundFTPClientConfigProxy.getClassName())) {
                FTPFileEntryParser entryParser = null;
                try {
                    entryParser = (FTPFileEntryParser)foundFTPClientConfigProxy.getDeclaringBundle().loadClass(foundFTPClientConfigProxy.getClassName()).newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                this.ftpParsers.put(foundFTPClientConfigProxy.getClassName(), entryParser);
            }
            config = new FTPClientConfig(foundFTPClientConfigProxy.getClassName());
            config.setDefaultDateFormatStr(foundFTPClientConfigProxy.getDefaultDateFormatStr());
            config.setRecentDateFormatStr(foundFTPClientConfigProxy.getRecentDateFormatStr());
            config.setServerLanguageCode(foundFTPClientConfigProxy.getServerLanguageCode());
            config.setShortMonthNames(foundFTPClientConfigProxy.getShortMonthNames());
            config.setServerTimeZoneId(foundFTPClientConfigProxy.getServerTimeZoneId());
            foundFTPClientConfigProxy.setFTPClientConfig(config);
        }
        return foundFTPClientConfigProxy;
    }

    public String[] getKeySet() {
        return this.ftpConfigProxyById.keySet().toArray(new String[this.ftpConfigProxyById.size()]);
    }

    public FTPFileEntryParser createFileEntryParser(String key) throws ParserInitializationException {
        Object entryParser = null;
        entryParser = !this.ftpParsers.containsKey(key) ? this.defaultFTPEntryParser : (FTPFileEntryParser)this.ftpParsers.get(key);
        return entryParser;
    }

    public FTPFileEntryParser createFileEntryParser(FTPClientConfig config) throws ParserInitializationException {
        String key = config.getServerSystemKey();
        return this.createFileEntryParser(key);
    }
}

