/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.events.ISystemPreferenceChangeEvent;
import org.eclipse.rse.core.events.ISystemPreferenceChangeListener;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemRemoteChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterStartHere;
import org.eclipse.rse.core.filters.SystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemNewConnectionWizardPage;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServiceSubSystem;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.core.filters.SystemFilterStartHere;
import org.eclipse.rse.internal.core.model.SystemHostPool;
import org.eclipse.rse.internal.core.model.SystemModelChangeEvent;
import org.eclipse.rse.internal.core.model.SystemModelChangeEventManager;
import org.eclipse.rse.internal.core.model.SystemPreferenceChangeManager;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.core.model.SystemRemoteChangeEventManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.internal.model.SystemResourceChangeManager;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;

public class SystemRegistry
implements ISystemRegistry {
    private static Exception lastException = null;
    private static SystemRegistry registry = null;
    private SystemResourceChangeManager listenerManager = new SystemResourceChangeManager();
    private SystemPreferenceChangeManager preferenceListManager = null;
    private SystemModelChangeEventManager modelListenerManager = new SystemModelChangeEventManager();
    private SystemModelChangeEvent modelEvent;
    private SystemRemoteChangeEventManager remoteListManager = new SystemRemoteChangeEventManager();
    private SystemRemoteChangeEvent remoteEvent;
    private int listenerCount = 0;
    private int modelListenerCount = 0;
    private int remoteListCount = 0;
    private ISubSystemConfigurationProxy[] subsystemConfigurationProxies = null;
    private boolean errorLoadingFactory = false;
    private Object shell = null;
    private Object viewer = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected SystemRegistry(String logfilePath) {
        this.preferenceListManager = new SystemPreferenceChangeManager();
        registry = this;
        this.restore();
    }

    public void reset() {
        SystemHostPool.reset();
        this.restore();
    }

    public static SystemRegistry getInstance(String logfilePath) {
        if (registry == null) {
            new SystemRegistry(logfilePath);
        }
        return registry;
    }

    public static SystemRegistry getInstance() {
        return registry;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return this.getSubSystems(selectedConnection);
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return true;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void setSubSystemConfigurationProxies(ISubSystemConfigurationProxy[] proxies) {
        this.subsystemConfigurationProxies = proxies;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxies() {
        return this.subsystemConfigurationProxies;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxiesByCategory(String factoryCategory) {
        Vector<ISubSystemConfigurationProxy> v = new Vector<ISubSystemConfigurationProxy>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                if (this.subsystemConfigurationProxies[idx].getCategory().equals(factoryCategory)) {
                    v.addElement(this.subsystemConfigurationProxies[idx]);
                }
                ++idx;
            }
        }
        ISubSystemConfigurationProxy[] proxies = new ISubSystemConfigurationProxy[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            proxies[idx] = (ISubSystemConfigurationProxy)v.elementAt(idx);
            ++idx;
        }
        return proxies;
    }

    public ISubSystemConfiguration getSubSystemConfiguration(String id) {
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        ISubSystemConfiguration match = null;
        int idx = 0;
        while (match == null && idx < proxies.length) {
            if (proxies[idx].getId().equals(id)) {
                match = proxies[idx].getSubSystemConfiguration();
            }
            ++idx;
        }
        return match;
    }

    public ISubSystemConfiguration[] getSubSystemConfigurationsBySystemType(IRSESystemType systemType, boolean filterDuplicateServiceSubSystemFactories) {
        ArrayList<Class> serviceTypesAdded = new ArrayList<Class>();
        ArrayList<Class> serviceImplsAdded = new ArrayList<Class>();
        Vector<ISubSystemConfiguration> v = new Vector<ISubSystemConfiguration>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystemConfiguration ssFactory;
                ISubSystemConfigurationProxy ssfProxy = this.subsystemConfigurationProxies[idx];
                if (ssfProxy.appliesToSystemType(systemType) && (ssFactory = ssfProxy.getSubSystemConfiguration()) != null) {
                    if (ssFactory instanceof IServiceSubSystemConfiguration && filterDuplicateServiceSubSystemFactories) {
                        IServiceSubSystemConfiguration serviceFactory = (IServiceSubSystemConfiguration)ssFactory;
                        Class serviceType = serviceFactory.getServiceType();
                        Class serviceImplType = serviceFactory.getServiceImplType();
                        boolean containsThisServiceType = serviceTypesAdded.contains(serviceType);
                        boolean containsThisServiceImplType = serviceImplsAdded.contains(serviceImplType);
                        if (!containsThisServiceType) {
                            serviceTypesAdded.add(serviceType);
                            serviceImplsAdded.add(serviceImplType);
                            v.addElement(ssFactory);
                        } else if (containsThisServiceImplType) {
                            int i = 0;
                            while (i < v.size()) {
                                IServiceSubSystemConfiguration addedConfig;
                                if (v.get(i) instanceof IServiceSubSystemConfiguration && (addedConfig = (IServiceSubSystemConfiguration)v.get(i)).getServiceType() == serviceType) {
                                    v.remove(addedConfig);
                                }
                                ++i;
                            }
                            v.addElement(ssFactory);
                        }
                    } else {
                        v.addElement(ssFactory);
                    }
                }
                ++idx;
            }
        }
        ISubSystemConfiguration[] factories = v.toArray(new ISubSystemConfiguration[v.size()]);
        return factories;
    }

    public boolean getQualifiedHostNames() {
        return SystemPreferencesManager.getQualifyConnectionNames();
    }

    public void setQualifiedHostNames(boolean set) {
        SystemPreferencesManager.setQualifyConnectionNames(set);
        IHost[] conns = this.getHosts();
        if (conns != null) {
            int idx = 0;
            while (idx < conns.length) {
                this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conns[idx], 65, (Object)this));
                ++idx;
            }
        }
        if (SystemPreferencesManager.getShowFilterPools()) {
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, (Object)this));
        }
    }

    public void setShowFilterPools(boolean show) {
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystemConfiguration factory;
                if (this.subsystemConfigurationProxies[idx].isSubSystemConfigurationActive() && (factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration()) != null && factory.supportsFilters()) {
                    factory.setShowFilterPools(show);
                }
                ++idx;
            }
        }
    }

    public void setShowNewHostPrompt(boolean show) {
        this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, null));
    }

    public ISystemProfileManager getSystemProfileManager() {
        return SystemProfileManager.getDefault();
    }

    public ISystemProfile[] getActiveSystemProfiles() {
        return this.getSystemProfileManager().getActiveSystemProfiles();
    }

    public ISystemProfile getSystemProfile(String profileName) {
        return this.getSystemProfileManager().getSystemProfile(profileName);
    }

    public ISystemProfile createSystemProfile(String profileName, boolean makeActive) throws Exception {
        ISystemProfileManager mgr = this.getSystemProfileManager();
        ISystemProfile profile = mgr.createSystemProfile(profileName, makeActive);
        this.fireModelChangeEvent(1, 1, profile, null);
        return profile;
    }

    public void renameSystemProfile(ISystemProfile profile, String newName) throws Exception {
        int idx;
        this.loadAll();
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        IHost[] connections = this.getHostsByProfile(profile);
        String oldName = profile.getName();
        if (proxies != null) {
            int idx2 = 0;
            while (idx2 < proxies.length) {
                if (proxies[idx2] != null && proxies[idx2].getSubSystemConfiguration() != null) {
                    proxies[idx2].getSubSystemConfiguration().preTestRenameSubSystemProfile(oldName);
                }
                ++idx2;
            }
        }
        ISystemHostPool profilePool = this.getHostPool(profile);
        profilePool.renameHostPool(newName);
        this.getSystemProfileManager().renameSystemProfile(profile, newName);
        if (proxies != null) {
            idx = 0;
            while (idx < proxies.length) {
                ISubSystemConfiguration factory = proxies[idx].getSubSystemConfiguration();
                if (factory != null) {
                    factory.renameSubSystemProfile(oldName, newName);
                }
                ++idx;
            }
        }
        idx = 0;
        while (idx < connections.length) {
            ISubSystem[] subsystems = this.getSubSystems(connections[idx]);
            int jdx = 0;
            while (jdx < subsystems.length) {
                ISubSystem ss = subsystems[jdx];
                ISubSystemConfiguration ssf = ss.getSubSystemConfiguration();
                ssf.renameSubSystemProfile(ss, oldName, newName);
                ++jdx;
            }
            ++idx;
        }
        SystemPreferencesManager.setConnectionNamesOrder();
        boolean namesQualifed = this.getQualifiedHostNames();
        if (namesQualifed) {
            this.setQualifiedHostNames(namesQualifed);
        }
        this.fireModelChangeEvent(8, 1, profile, oldName);
    }

    public ISystemProfile copySystemProfile(ISystemProfile profile, String newName, boolean makeActive, IProgressMonitor monitor) throws Exception {
        Exception lastExc = null;
        boolean failed = false;
        String msg = null;
        String oldName = profile.getName();
        IHost[] newConns = null;
        this.loadAll();
        IHost[] conns = this.getHostsByProfile(profile);
        Vector factories = this.getSubSystemFactories(conns);
        if (this.errorLoadingFactory) {
            return null;
        }
        ISystemProfile newProfile = this.getSystemProfileManager().cloneSystemProfile(profile, newName);
        try {
            ISystemHostPool oldPool = this.getHostPool(profile);
            ISystemHostPool newPool = this.getHostPool(newProfile);
            if (conns != null && conns.length > 0) {
                newConns = new IHost[conns.length];
                SystemMessage msgNoSubs = RSEUIPlugin.getPluginMessage("RSEG1073");
                int idx = 0;
                while (idx < conns.length) {
                    msgNoSubs.makeSubstitution((Object)conns[idx].getAliasName());
                    SystemBasePlugin.logDebugMessage(this.getClass().getName(), msgNoSubs.getLevelOneText());
                    monitor.subTask(msgNoSubs.getLevelOneText());
                    newConns[idx] = oldPool.cloneHost(newPool, conns[idx], conns[idx].getAliasName());
                    monitor.worked(1);
                    ++idx;
                }
            }
            msg = RSEUIPlugin.getPluginMessage("RSEG1075").getLevelOneText();
            monitor.subTask(msg);
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
            int idx = 0;
            while (idx < factories.size()) {
                ISubSystemConfiguration factory = (ISubSystemConfiguration)factories.elementAt(idx);
                msg = "Copying filterPools for factory " + factory.getName();
                SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
                factory.copyFilterPoolManager(profile, newProfile);
                ++idx;
            }
            monitor.worked(1);
            msg = RSEUIPlugin.getPluginMessage("RSEG1081").getLevelOneText();
            monitor.subTask(msg);
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
            if (conns != null && conns.length > 0) {
                ISubSystem[] subsystems = null;
                ISubSystemConfiguration factory = null;
                int idx2 = 0;
                while (idx2 < conns.length) {
                    msg = "Copying subsystems for connection " + conns[idx2].getAliasName();
                    SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
                    subsystems = this.getSubSystems(conns[idx2]);
                    if (subsystems != null && subsystems.length > 0 && newConns != null) {
                        int jdx = 0;
                        while (jdx < subsystems.length) {
                            msg = String.valueOf(msg) + ": subsystem " + subsystems[jdx].getName();
                            SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
                            factory = subsystems[jdx].getSubSystemConfiguration();
                            factory.cloneSubSystem(subsystems[jdx], newConns[idx2], true);
                            ++jdx;
                        }
                    }
                    ++idx2;
                }
            }
            monitor.worked(1);
        }
        catch (Exception exc) {
            failed = true;
            lastExc = exc;
        }
        if (failed) {
            try {
                if (newConns != null) {
                    int idx = 0;
                    while (idx < newConns.length) {
                        this.deleteHost(newConns[idx]);
                        ++idx;
                    }
                }
                int idx = 0;
                while (idx < this.subsystemConfigurationProxies.length) {
                    ISubSystemConfiguration factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                    if (factory != null) {
                        factory.deletingSystemProfile(newProfile);
                    }
                    ++idx;
                }
                this.getSystemProfileManager().deleteSystemProfile(newProfile, true);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Exception (ignored) cleaning up from copy-profile exception.", exc);
            }
            throw lastExc;
        }
        this.fireModelChangeEvent(1, 1, newProfile, null);
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Copy of system profile " + oldName + " to " + newName + " successful");
        return newProfile;
    }

    public void deleteSystemProfile(ISystemProfile profile) throws Exception {
        this.loadAll();
        Object[] connections = this.getHostsByProfile(profile);
        int idx = 0;
        while (idx < connections.length) {
            this.deleteHost(connections[idx]);
            ++idx;
        }
        if (this.subsystemConfigurationProxies != null) {
            idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystemConfiguration factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                if (factory != null) {
                    factory.deletingSystemProfile(profile);
                }
                ++idx;
            }
        }
        this.getSystemProfileManager().deleteSystemProfile(profile, true);
        SystemPreferencesManager.setConnectionNamesOrder();
        if (connections.length > 0) {
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(connections, 60, (Object)this));
        }
        this.fireModelChangeEvent(2, 1, profile, null);
    }

    public void setSystemProfileActive(ISystemProfile profile, boolean makeActive) {
        ISubSystemConfiguration factory;
        int idx;
        Vector<ISubSystem> activeReferenceVector = new Vector<ISubSystem>();
        if (!makeActive && this.subsystemConfigurationProxies != null) {
            idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystem[] activeReferences;
                factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                if (factory != null && (activeReferences = factory.testForActiveReferences(profile)) != null) {
                    int jdx = 0;
                    while (jdx < activeReferences.length) {
                        activeReferenceVector.addElement(activeReferences[jdx]);
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        if (activeReferenceVector.size() > 0) {
            SystemBasePlugin.logWarning("RSEG1069: De-Activativing profile " + profile.getName() + " for which there are subsystems containing references to filter pools:");
            idx = 0;
            while (idx < activeReferenceVector.size()) {
                ISubSystem activeReference = (ISubSystem)activeReferenceVector.elementAt(idx);
                SystemBasePlugin.logWarning("  " + activeReference.getName() + " in connection " + activeReference.getHost().getAliasName() + " in profile " + activeReference.getSystemProfileName());
                ++idx;
            }
            ISubSystem firstSubSystem = (ISubSystem)activeReferenceVector.elementAt(0);
            String connectionName = String.valueOf(firstSubSystem.getHost().getSystemProfileName()) + "." + firstSubSystem.getHost().getAliasName();
            SystemMessage sysMsg = RSEUIPlugin.getPluginMessage("RSEG1069");
            sysMsg.makeSubstitution((Object)profile.getName(), (Object)connectionName);
            SystemBasePlugin.logWarning(String.valueOf(sysMsg.getFullMessageID()) + ": " + sysMsg.getLevelOneText());
            SystemMessageDialog msgDlg = new SystemMessageDialog(null, sysMsg);
            msgDlg.open();
        }
        this.getSystemProfileManager().makeSystemProfileActive(profile, makeActive);
        if (this.subsystemConfigurationProxies != null) {
            int idx2 = 0;
            while (idx2 < this.subsystemConfigurationProxies.length) {
                if (this.subsystemConfigurationProxies[idx2].isSubSystemConfigurationActive() && (factory = this.subsystemConfigurationProxies[idx2].getSubSystemConfiguration()) != null) {
                    factory.changingSystemProfileActiveStatus(profile, makeActive);
                }
                ++idx2;
            }
        }
        Object[] affectedConnections = this.getHostsByProfile(profile);
        if (!makeActive) {
            if (affectedConnections != null && affectedConnections.length > 0) {
                int idx3 = 0;
                while (idx3 < affectedConnections.length) {
                    this.disconnectAllSubSystems((IHost)affectedConnections[idx3]);
                    ++idx3;
                }
                SystemResourceChangeEvent event = new SystemResourceChangeEvent(affectedConnections, 60, (Object)this);
                this.fireEvent((ISystemResourceChangeEvent)event);
            }
        } else if (affectedConnections != null && affectedConnections.length > 0) {
            SystemResourceChangeEvent event = new SystemResourceChangeEvent(affectedConnections, 51, (Object)this);
            this.fireEvent((ISystemResourceChangeEvent)event);
        }
        SystemPreferencesManager.setConnectionNamesOrder();
        this.fireModelChangeEvent(4, 1, profile, null);
    }

    private ISystemProfile getSystemProfile(ISystemHostPool pool) {
        return pool.getSystemProfile();
    }

    public IConnectorService[] getConnectorServices(IHost conn) {
        ArrayList<IConnectorService> csList = new ArrayList<IConnectorService>();
        ISubSystem[] sses = this.getSubSystems(conn);
        int i = 0;
        while (i < sses.length) {
            ISubSystem ss = sses[i];
            IConnectorService service = ss.getConnectorService();
            if (!csList.contains(service)) {
                csList.add(service);
            }
            ++i;
        }
        return csList.toArray(new IConnectorService[csList.size()]);
    }

    public ISubSystem[] getSubSystems(IHost conn) {
        return this.getSubSystems(conn, true);
    }

    public ISubSystem[] getSubSystems(IHost conn, boolean force) {
        ISubSystem[] subsystems = null;
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystem[] sss;
                ISubSystemConfiguration factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                if (factory != null && (sss = factory.getSubSystems(conn, force)) != null) {
                    int jdx = 0;
                    while (jdx < sss.length) {
                        v.addElement(sss[jdx]);
                        ++jdx;
                    }
                }
                ++idx;
            }
            subsystems = new ISubSystem[v.size()];
            idx = 0;
            while (idx < v.size()) {
                subsystems[idx] = (ISubSystem)v.elementAt(idx);
                ++idx;
            }
        }
        return subsystems;
    }

    public ISubSystem getSubSystem(String absoluteSubSystemName) {
        int profileDelim = absoluteSubSystemName.indexOf(".");
        int connectionDelim = absoluteSubSystemName.indexOf(":", profileDelim + 1);
        if (profileDelim > 0 && connectionDelim > profileDelim) {
            String srcProfileName = absoluteSubSystemName.substring(0, profileDelim);
            String srcConnectionName = absoluteSubSystemName.substring(profileDelim + 1, connectionDelim);
            String srcSubSystemConfigurationId = absoluteSubSystemName.substring(connectionDelim + 1, absoluteSubSystemName.length());
            ISystemProfile profile = this.getSystemProfile(srcProfileName);
            return this.getSubSystem(profile, srcConnectionName, srcSubSystemConfigurationId);
        }
        return null;
    }

    public ISubSystem getSubSystem(ISystemProfile profile, String srcConnectionName, String subsystemConfigurationId) {
        IHost[] connections = this.getHostsByProfile(profile);
        if (connections == null) {
            connections = this.getHosts();
        }
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            String connectionName = connection.getAliasName();
            if (connectionName.equals(srcConnectionName)) {
                ISubSystem[] subsystems = this.getSubSystems(connection);
                int s = 0;
                while (s < subsystems.length) {
                    ISubSystem subsystem = subsystems[s];
                    String compareId = subsystem.getConfigurationId();
                    if (compareId.equals(subsystemConfigurationId)) {
                        return subsystem;
                    }
                    if (subsystem.getName().equals(subsystemConfigurationId)) {
                        return subsystem;
                    }
                    ++s;
                }
            }
            ++i;
        }
        return null;
    }

    public String getAbsoluteNameForSubSystem(ISubSystem subSystem) {
        StringBuffer dataStream = new StringBuffer();
        String profileName = subSystem.getSystemProfileName();
        String connectionName = subSystem.getHostAliasName();
        String factoryId = subSystem.getConfigurationId();
        dataStream.append(profileName);
        dataStream.append(".");
        dataStream.append(connectionName);
        dataStream.append(":");
        dataStream.append(factoryId);
        return dataStream.toString();
    }

    public boolean isSameObjectByAbsoluteName(Object firstObject, String firstObjectFullName, Object secondObject, String secondObjectFullName) {
        if (firstObject == secondObject) {
            return true;
        }
        String firstObjectAbsoluteNameWithSubSystemId = null;
        if (firstObject instanceof IAdaptable) {
            ISystemDragDropAdapter adapter = null;
            IAdaptable iAdaptable = (IAdaptable)firstObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
            String subSystemId = null;
            if (adapter != null) {
                ISubSystem subSystem = adapter.getSubSystem(firstObject);
                subSystemId = subSystem != null ? this.getAbsoluteNameForSubSystem(subSystem) : "";
                if (firstObjectFullName != null) {
                    firstObjectAbsoluteNameWithSubSystemId = String.valueOf(subSystemId) + ":" + firstObjectFullName;
                } else {
                    String absolutePath = adapter.getAbsoluteName(firstObject);
                    firstObjectAbsoluteNameWithSubSystemId = String.valueOf(subSystemId) + ":" + absolutePath;
                }
            }
        }
        String secondObjectAbsoluteNameWithSubSystemId = null;
        if (secondObject instanceof IAdaptable) {
            ISystemDragDropAdapter adapter = null;
            IAdaptable iAdaptable = (IAdaptable)secondObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
            String subSystemId = null;
            if (adapter != null) {
                ISubSystem subSystem = adapter.getSubSystem(secondObject);
                subSystemId = subSystem != null ? this.getAbsoluteNameForSubSystem(subSystem) : "";
                if (secondObjectFullName != null) {
                    secondObjectAbsoluteNameWithSubSystemId = String.valueOf(subSystemId) + ":" + secondObjectFullName;
                } else {
                    String absolutePath = adapter.getAbsoluteName(secondObject);
                    secondObjectAbsoluteNameWithSubSystemId = String.valueOf(subSystemId) + ":" + absolutePath;
                }
            }
        }
        return firstObjectAbsoluteNameWithSubSystemId != null && firstObjectAbsoluteNameWithSubSystemId.equals(secondObjectAbsoluteNameWithSubSystemId);
    }

    public String getAbsoluteNameForConnection(IHost connection) {
        StringBuffer dataStream = new StringBuffer();
        String profileName = connection.getSystemProfileName();
        String connectionName = connection.getAliasName();
        dataStream.append(profileName);
        dataStream.append(".");
        dataStream.append(connectionName);
        return dataStream.toString();
    }

    public ISubSystem[] getSubSystemsLazily(IHost conn) {
        ISubSystem[] subsystems = null;
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystem[] sss;
                ISubSystemConfiguration factory;
                if (this.subsystemConfigurationProxies[idx].appliesToSystemType(conn.getSystemType()) && this.subsystemConfigurationProxies[idx].isSubSystemConfigurationActive() && (factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration()) != null && (sss = factory.getSubSystems(conn, false)) != null) {
                    int jdx = 0;
                    while (jdx < sss.length) {
                        v.addElement(sss[jdx]);
                        ++jdx;
                    }
                }
                ++idx;
            }
            subsystems = new ISubSystem[v.size()];
            idx = 0;
            while (idx < v.size()) {
                subsystems[idx] = (ISubSystem)v.elementAt(idx);
                ++idx;
            }
        }
        return subsystems;
    }

    public ISubSystem[] getSubsystems(IHost connection, Class subsystemInterface) {
        ArrayList<ISubSystem> matches = new ArrayList<ISubSystem>();
        ISubSystem[] allSS = connection.getSubSystems();
        int i = 0;
        while (i < allSS.length) {
            ISubSystem ss = allSS[i];
            if (subsystemInterface.isInstance(subsystemInterface)) {
                matches.add(ss);
            }
            ++i;
        }
        return matches.toArray(new ISubSystem[matches.size()]);
    }

    public ISubSystem[] getServiceSubSystems(IHost connection, Class serviceType) {
        ArrayList<ISubSystem> matches = new ArrayList<ISubSystem>();
        ISubSystem[] allSS = connection.getSubSystems();
        int i = 0;
        while (i < allSS.length) {
            IServiceSubSystem serviceSubSystem;
            ISubSystem ss = allSS[i];
            if (ss instanceof IServiceSubSystem && (serviceSubSystem = (IServiceSubSystem)ss).getServiceType() == serviceType) {
                matches.add(ss);
            }
            ++i;
        }
        return matches.toArray(new ISubSystem[matches.size()]);
    }

    public ISubSystem[] getSubSystemsBySubSystemConfigurationCategory(String factoryCategory, IHost connection) {
        ISubSystem[] subsystems = this.getSubSystems(connection);
        if (subsystems != null && subsystems.length > 0) {
            Vector<ISubSystem> v = new Vector<ISubSystem>();
            int idx = 0;
            while (idx < subsystems.length) {
                if (subsystems[idx].getSubSystemConfiguration().getCategory().equals(factoryCategory)) {
                    v.addElement(subsystems[idx]);
                }
                ++idx;
            }
            ISubSystem[] sss = new ISubSystem[v.size()];
            int idx2 = 0;
            while (idx2 < sss.length) {
                sss[idx2] = (ISubSystem)v.elementAt(idx2);
                ++idx2;
            }
            return sss;
        }
        return new ISubSystem[0];
    }

    public ISubSystemConfiguration[] getSubSystemConfigurations() {
        Vector<ISubSystemConfiguration> v = new Vector<ISubSystemConfiguration>();
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        if (proxies != null) {
            int idx = 0;
            while (idx < proxies.length) {
                ISubSystemConfigurationProxy proxy = proxies[idx];
                ISubSystemConfiguration config = proxy.getSubSystemConfiguration();
                if (config != null) {
                    v.add(proxies[idx].getSubSystemConfiguration());
                }
                ++idx;
            }
        }
        ISubSystemConfiguration[] result = new ISubSystemConfiguration[v.size()];
        v.toArray(result);
        return result;
    }

    protected Vector getSubSystemFactories(IHost conn) {
        Vector factories = new Vector();
        this.errorLoadingFactory = false;
        return this.getSubSystemFactories(conn, factories);
    }

    protected Vector getSubSystemFactories(IHost conn, Vector factories) {
        ISubSystem[] subsystems = this.getSubSystems(conn);
        if (subsystems != null) {
            int idx = 0;
            while (idx < subsystems.length) {
                ISubSystemConfiguration ssFactory = subsystems[idx].getSubSystemConfiguration();
                if (ssFactory == null) {
                    this.errorLoadingFactory = true;
                }
                if (ssFactory != null && !factories.contains(ssFactory)) {
                    factories.add(ssFactory);
                }
                ++idx;
            }
        }
        return factories;
    }

    protected Vector getSubSystemFactories(IHost[] conns) {
        Vector factories = new Vector();
        this.errorLoadingFactory = false;
        if (conns != null) {
            int idx = 0;
            while (idx < conns.length) {
                this.getSubSystemFactories(conns[idx], factories);
                ++idx;
            }
        }
        return factories;
    }

    public boolean deleteSubSystem(ISubSystem subsystem) {
        ISubSystemConfiguration ssFactory = subsystem.getSubSystemConfiguration();
        if (ssFactory == null) {
            return false;
        }
        boolean ok = ssFactory.deleteSubSystem(subsystem);
        return ok;
    }

    private ISystemHostPool getHostPool(String profileName) {
        ISystemProfile profile = this.getSystemProfileManager().getSystemProfile(profileName);
        if (profile == null) {
            return null;
        }
        return this.getHostPool(profile);
    }

    private ISystemHostPool getHostPool(ISystemProfile profile) {
        lastException = null;
        try {
            return SystemHostPool.getSystemHostPool((ISystemProfile)profile);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Exception in getConnectionPool for " + profile.getName(), exc);
            lastException = exc;
        }
        catch (Throwable t) {
            SystemBasePlugin.logError("Exception in getConnectionPool for " + profile.getName(), t);
        }
        return null;
    }

    private ISystemHostPool[] getHostPools() {
        ISystemProfile[] profiles = this.getSystemProfileManager().getActiveSystemProfiles();
        ISystemHostPool[] pools = new ISystemHostPool[profiles.length];
        int idx = 0;
        while (idx < pools.length) {
            try {
                pools[idx] = SystemHostPool.getSystemHostPool((ISystemProfile)profiles[idx]);
            }
            catch (Exception exception) {}
            ++idx;
        }
        return pools;
    }

    public IHost getLocalHost() {
        IHost localConn = null;
        IRSESystemType localType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local");
        IHost[] conns = this.getHostsBySystemType(localType);
        if (conns != null && conns.length > 0) {
            return conns[0];
        }
        return localConn;
    }

    public IHost[] getHosts() {
        ISystemHostPool[] pools = this.getHostPools();
        Vector<IHost> v = new Vector<IHost>();
        int idx = 0;
        while (idx < pools.length) {
            IHost[] conns = this.getHostsByProfile(this.getSystemProfile(pools[idx]));
            if (conns != null) {
                int jdx = 0;
                while (jdx < conns.length) {
                    v.addElement(conns[jdx]);
                    ++jdx;
                }
            }
            ++idx;
        }
        IHost[] allConns = new IHost[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            allConns[idx2] = (IHost)v.elementAt(idx2);
            ++idx2;
        }
        return allConns;
    }

    public IHost[] getHostsByProfile(ISystemProfile profile) {
        ISystemHostPool pool = this.getHostPool(profile);
        return pool.getHosts();
    }

    public IHost[] getHostsBySubSystemConfiguration(ISubSystemConfiguration factory) {
        ISubSystem[] subsystems = factory.getSubSystems(true);
        Vector<IHost> v = new Vector<IHost>();
        int idx = 0;
        while (idx < subsystems.length) {
            IHost conn = subsystems[idx].getHost();
            if (!v.contains(conn)) {
                v.addElement(conn);
            }
            ++idx;
        }
        IHost[] conns = new IHost[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            conns[idx2] = (IHost)v.elementAt(idx2);
            ++idx2;
        }
        return conns;
    }

    public IHost[] getHostsBySubSystemConfigurationCategory(String factoryCategory) {
        Vector<IHost> v = new Vector<IHost>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystem[] subsystems;
                ISubSystemConfiguration factory;
                if (this.subsystemConfigurationProxies[idx].getCategory().equals(factoryCategory) && (factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration()) != null && (subsystems = factory.getSubSystems(true)) != null) {
                    int jdx = 0;
                    while (jdx < subsystems.length) {
                        IHost conn = subsystems[jdx].getHost();
                        if (!v.contains(conn)) {
                            v.addElement(conn);
                        }
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        IHost[] conns = new IHost[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            conns[idx] = (IHost)v.elementAt(idx);
            ++idx;
        }
        return conns;
    }

    public IHost[] getHostsBySystemType(IRSESystemType systemType) {
        ArrayList<IHost> connections = new ArrayList<IHost>();
        if (systemType != null) {
            IHost[] candidates = this.getHosts();
            int i = 0;
            while (i < candidates.length) {
                IHost candidate = candidates[i];
                IRSESystemType candidateType = candidate.getSystemType();
                if (systemType.equals(candidateType)) {
                    connections.add(candidate);
                }
                ++i;
            }
        }
        return connections.toArray(new IHost[connections.size()]);
    }

    public IHost[] getHostsBySystemTypes(IRSESystemType[] systemTypes) {
        List<IRSESystemType> systemTypesList = Arrays.asList(systemTypes);
        IHost[] connections = this.getHosts();
        Vector<IHost> v = new Vector<IHost>();
        int idx = 0;
        while (idx < connections.length) {
            IRSESystemType systemType = connections[idx].getSystemType();
            if (systemTypesList.contains(systemType)) {
                v.addElement(connections[idx]);
            }
            ++idx;
        }
        return v.toArray(new IHost[v.size()]);
    }

    public IHost getHost(ISystemProfile profile, String connectionName) {
        return this.getHostPool(profile).getHost(connectionName);
    }

    public int getHostPosition(IHost conn) {
        ISystemHostPool pool = conn.getHostPool();
        return pool.getHostPosition(conn);
    }

    public int getHostPositionInView(IHost conn) {
        IHost[] conns = this.getHosts();
        int pos = -1;
        int idx = 0;
        while (pos == -1 && idx < conns.length) {
            if (conns[idx] == conn) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public int getHostCount(ISystemProfile profile) {
        return this.getHostPool(profile).getHostCount();
    }

    public int getHostCountWithinProfile(IHost conn) {
        return conn.getHostPool().getHostCount();
    }

    public int getHostCount() {
        ISystemHostPool[] pools = this.getHostPools();
        int total = 0;
        int idx = 0;
        while (idx < pools.length) {
            total += pools[idx].getHostCount();
            ++idx;
        }
        return total;
    }

    public Vector getHostAliasNames(ISystemProfile profile) {
        ISystemHostPool pool = this.getHostPool(profile);
        Vector<String> names = new Vector<String>();
        IHost[] conns = pool.getHosts();
        int idx = 0;
        while (idx < conns.length) {
            names.addElement(conns[idx].getAliasName());
            ++idx;
        }
        return names;
    }

    public Vector getHostAliasNamesForAllActiveProfiles() {
        ISystemHostPool[] allPools = this.getHostPools();
        Vector allNames = new Vector();
        int idx = 0;
        while (idx < allPools.length) {
            Vector v = this.getHostAliasNames(this.getSystemProfile(allPools[idx]));
            int jdx = 0;
            while (jdx < v.size()) {
                allNames.addElement(v.elementAt(jdx));
                ++jdx;
            }
            ++idx;
        }
        return allNames;
    }

    public String[] getHostNames(IRSESystemType systemType) {
        Vector<String> v = new Vector<String>();
        if (systemType != null) {
            IHost[] conns = this.getHosts();
            int idx = 0;
            while (idx < conns.length) {
                if (conns[idx].getHostName() != null && !v.contains(conns[idx].getHostName()) && conns[idx].getSystemType().equals(systemType)) {
                    v.addElement(conns[idx].getHostName());
                }
                ++idx;
            }
        }
        if (systemType != null && systemType.isLocal() && v.size() == 0) {
            v.addElement("localhost");
        }
        return v.toArray(new String[v.size()]);
    }

    public IHost createLocalHost(ISystemProfile profile, String name, String userId) {
        IHost localConn = null;
        if (profile == null) {
            profile = this.getSystemProfileManager().getDefaultPrivateSystemProfile();
        }
        if (profile == null) {
            profile = this.getSystemProfileManager().getActiveSystemProfiles()[0];
        }
        try {
            IRSESystemType localType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local");
            localConn = this.createHost(profile.getName(), localType, name, "localhost", "", userId, 3, null);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error creating local connection", exc);
        }
        return localConn;
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description, String defaultUserId, int defaultUserIdLocation, ISystemNewConnectionWizardPage[] newConnectionWizardPages) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, defaultUserId, defaultUserIdLocation, true, newConnectionWizardPages);
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description, String defaultUserId, int defaultUserIdLocation, boolean createSubSystems, ISystemNewConnectionWizardPage[] newConnectionWizardPages) throws Exception {
        lastException = null;
        ISystemHostPool pool = this.getHostPool(profileName);
        IHost conn = null;
        boolean promptable = false;
        try {
            if (defaultUserId != null && defaultUserId.length() == 0) {
                defaultUserId = null;
            }
            if ((conn = pool.createHost(systemType, connectionName, hostName, description, defaultUserId, defaultUserIdLocation)) == null) {
                conn = pool.getHost(connectionName);
            }
            if (promptable) {
                conn.setPromptable(true);
            }
        }
        catch (Exception exc) {
            lastException = exc;
            SystemBasePlugin.logError("Exception in createConnection for " + connectionName, exc);
            throw exc;
        }
        if (lastException == null && !promptable && createSubSystems) {
            ISubSystemConfiguration[] factories = this.getSubSystemConfigurationsBySystemType(systemType, true);
            ISubSystem[] subSystems = new ISubSystem[factories.length];
            int idx = 0;
            while (idx < factories.length) {
                ISubSystemConfiguration factory = factories[idx];
                ISystemNewConnectionWizardPage[] interestingPages = this.getApplicableWizardPages(factory, newConnectionWizardPages);
                subSystems[idx] = factory.createSubSystem(conn, true, interestingPages);
                ++idx;
            }
            FireNewHostEvents fire = new FireNewHostEvents(conn, subSystems, this);
            Display.getDefault().asyncExec((Runnable)fire);
        }
        conn.commit();
        SystemPreferencesManager.setConnectionNamesOrder();
        return conn;
    }

    public ISubSystem[] createSubSystems(IHost host, ISubSystemConfiguration[] configurations) {
        ISubSystem[] subsystems = new ISubSystem[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            subsystems[i] = configurations[i].createSubSystem(host, true, null);
            ++i;
        }
        int j = 0;
        while (j < subsystems.length) {
            this.fireModelChangeEvent(1, 4, subsystems[j], null);
            ++j;
        }
        host.commit();
        return subsystems;
    }

    private ISystemNewConnectionWizardPage[] getApplicableWizardPages(ISubSystemConfiguration ssf, ISystemNewConnectionWizardPage[] allPages) {
        if (allPages == null || allPages.length == 0) {
            return null;
        }
        int count = 0;
        int idx = 0;
        while (idx < allPages.length) {
            if (allPages[idx].getSubSystemConfiguration() == ssf) {
                ++count;
            }
            ++idx;
        }
        if (count == 0) {
            return null;
        }
        ISystemNewConnectionWizardPage[] subPages = new ISystemNewConnectionWizardPage[count];
        count = 0;
        int idx2 = 0;
        while (idx2 < allPages.length) {
            if (allPages[idx2].getSubSystemConfiguration() == ssf) {
                subPages[count++] = allPages[idx2];
            }
            ++idx2;
        }
        return subPages;
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, true);
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description, boolean createSubSystems) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, null, 2, null);
    }

    public IHost createHost(IRSESystemType systemType, String connectionName, String hostName, String description) throws Exception {
        ISystemProfile profile = this.getSystemProfileManager().getDefaultPrivateSystemProfile();
        if (profile == null) {
            profile = this.getSystemProfileManager().getActiveSystemProfiles()[0];
        }
        return this.createHost(profile.getName(), systemType, connectionName, hostName, description);
    }

    protected IHost getPreviousHost(IHost conn) {
        IHost prevConn = null;
        ISystemHostPool pool = conn.getHostPool();
        int pos = pool.getHostPosition(conn);
        if (pos > 0) {
            prevConn = pool.getHost(pos - 1);
        } else {
            IHost[] allConns = this.getHosts();
            if (allConns != null && (pos = this.getHostPositionInView(conn)) > 0) {
                prevConn = allConns[pos - 1];
            }
        }
        return prevConn;
    }

    public void updateHost(IHost conn, IRSESystemType systemType, String connectionName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) {
        boolean skipUpdate;
        lastException = null;
        boolean connectionNameChanged = !connectionName.equalsIgnoreCase(conn.getAliasName());
        boolean hostNameChanged = !hostName.equalsIgnoreCase(conn.getHostName());
        String orgDefaultUserId = conn.getDefaultUserId();
        boolean defaultUserIdChanged = false;
        if (defaultUserId == null || orgDefaultUserId == null) {
            if (orgDefaultUserId != defaultUserId) {
                defaultUserIdChanged = true;
            }
        } else {
            defaultUserIdChanged = !conn.compareUserIds(defaultUserId, orgDefaultUserId);
        }
        try {
            if (connectionNameChanged) {
                this.renameHost(conn, connectionName);
            }
            conn.getHostPool().updateHost(conn, systemType, connectionName, hostName, description, defaultUserId, defaultUserIdLocation);
        }
        catch (SystemMessageException exc) {
            SystemBasePlugin.logError("Exception in updateConnection for " + connectionName, exc);
            lastException = exc;
            return;
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Exception in updateConnection for " + connectionName, exc);
            lastException = exc;
            return;
        }
        boolean bl = skipUpdate = defaultUserIdChanged && !hostNameChanged && !connectionNameChanged;
        if (!skipUpdate) {
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conn, 86, (Object)this));
        }
        if (!skipUpdate) {
            this.fireModelChangeEvent(4, 2, conn, null);
        }
        if (hostNameChanged || defaultUserIdChanged) {
            ISubSystem[] subsystems = this.getSubSystems(conn);
            int idx = 0;
            while (idx < subsystems.length) {
                if (hostNameChanged || subsystems[idx].getLocalUserId() == null) {
                    try {
                        if (subsystems[idx].isConnected()) {
                            subsystems[idx].disconnect();
                        }
                        if (defaultUserIdChanged) {
                            subsystems[idx].getConnectorService().clearCredentials();
                        }
                        subsystems[idx].getConnectorService().clearPassword(false, true);
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        }
    }

    public void setHostOffline(IHost conn, boolean offline) {
        if (conn.isOffline() != offline) {
            conn.setOffline(offline);
            this.saveHost(conn);
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conn, 87, null));
        }
    }

    public void deleteHost(IHost conn) {
        Vector affectedSubSystemFactories = this.getSubSystemFactories(conn);
        int idx = 0;
        while (idx < affectedSubSystemFactories.size()) {
            ((ISubSystemConfiguration)affectedSubSystemFactories.elementAt(idx)).deleteSubSystemsByConnection(conn);
            ++idx;
        }
        conn.getHostPool().deleteHost(conn);
        SystemPreferencesManager.setConnectionNamesOrder();
        this.fireModelChangeEvent(2, 2, conn, null);
    }

    public void renameHost(IHost conn, String newName) throws Exception {
        String oldName = conn.getAliasName();
        ISubSystem[] subsystems = conn.getSubSystems();
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem ss = subsystems[i];
            ss.getSubSystemConfiguration().renameSubSystemsByConnection(conn, newName);
            ++i;
        }
        conn.getHostPool().renameHost(conn, newName);
        SystemPreferencesManager.setConnectionNamesOrder();
        this.fireModelChangeEvent(8, 2, conn, oldName);
    }

    public void moveHosts(String profileName, IHost[] conns, int delta) {
        ISystemHostPool pool = this.getHostPool(profileName);
        pool.moveHosts(conns, delta);
        SystemPreferencesManager.setConnectionNamesOrder();
        SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object[])conns, 75, (Object)this);
        event.setPosition(delta);
        this.fireEvent((ISystemResourceChangeEvent)event);
        int idx = 0;
        while (idx < conns.length) {
            this.fireModelChangeEvent(16, 2, conns[idx], null);
            ++idx;
        }
    }

    public IHost copyHost(IHost conn, ISystemProfile targetProfile, String newName, IProgressMonitor monitor) throws Exception {
        Exception lastExc = null;
        boolean failed = false;
        String msg = null;
        String oldName = conn.getAliasName();
        ISystemHostPool oldPool = conn.getHostPool();
        ISystemHostPool targetPool = this.getHostPool(targetProfile);
        IHost newConn = null;
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Start of system connection copy. From: " + oldName + " to: " + newName);
        this.getSubSystemFactories(conn);
        if (this.errorLoadingFactory) {
            return null;
        }
        try {
            newConn = oldPool.cloneHost(targetPool, conn, newName);
            msg = RSEUIPlugin.getPluginMessage("RSEG1081").getLevelOneText();
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
            ISubSystem[] subsystems = null;
            ISubSystemConfiguration factory = null;
            msg = "Copying subsystems for connection " + conn.getAliasName();
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
            subsystems = this.getSubSystems(conn);
            if (subsystems != null && subsystems.length > 0) {
                int jdx = 0;
                while (jdx < subsystems.length) {
                    msg = String.valueOf(msg) + ": subsystem " + subsystems[jdx].getName();
                    SystemBasePlugin.logDebugMessage(this.getClass().getName(), msg);
                    factory = subsystems[jdx].getSubSystemConfiguration();
                    factory.cloneSubSystem(subsystems[jdx], newConn, false);
                    ++jdx;
                }
            }
        }
        catch (Exception exc) {
            failed = true;
            lastExc = exc;
        }
        if (failed) {
            try {
                if (newConn != null) {
                    this.deleteHost(newConn);
                }
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Exception (ignored) cleaning up from copy-connection exception.", exc);
            }
            throw lastExc;
        }
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Copy of system connection " + oldName + " to " + newName + " successful");
        if (this.getSystemProfileManager().isSystemProfileActive(targetProfile.getName())) {
            int eventType = 53;
            SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)newConn, eventType, (Object)this);
            event.setRelativePrevious((Object)this.getPreviousHost(newConn));
            this.fireEvent((ISystemResourceChangeEvent)event);
        }
        this.fireModelChangeEvent(1, 2, newConn, null);
        return newConn;
    }

    public IHost moveHost(IHost conn, ISystemProfile targetProfile, String newName, IProgressMonitor monitor) throws Exception {
        IHost newConn = null;
        newConn = this.copyHost(conn, targetProfile, newName, monitor);
        if (newConn != null) {
            this.deleteHost(conn);
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Move of system connection " + conn.getAliasName() + " to profile " + targetProfile.getName() + " successful");
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conn, 55, (Object)this));
        }
        return newConn;
    }

    public boolean isAnySubSystemSupportsConnect(IHost conn) {
        Vector v = this.getSubSystemFactories(conn);
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                ISubSystemConfiguration config;
                Object obj = iter.next();
                if (!(obj instanceof ISubSystemConfiguration) || !(config = (ISubSystemConfiguration)obj).supportsSubSystemConnect()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnySubSystemConnected(IHost conn) {
        boolean any = false;
        ISubSystem[] subsystems = this.getSubSystemsLazily(conn);
        if (subsystems == null) {
            return false;
        }
        int idx = 0;
        while (!any && idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            if (ss.isConnected()) {
                any = true;
            }
            ++idx;
        }
        return any;
    }

    public boolean areAllSubSystemsConnected(IHost conn) {
        boolean all = true;
        ISubSystem[] subsystems = this.getSubSystemsLazily(conn);
        if (subsystems == null) {
            return false;
        }
        int idx = 0;
        while (all && idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            if (!ss.isConnected()) {
                return false;
            }
            ++idx;
        }
        return all;
    }

    public void disconnectAllSubSystems(IHost conn) {
        ISubSystem[] subsystems = this.getSubSystemsLazily(conn);
        if (subsystems == null) {
            return;
        }
        boolean cancelled = false;
        int idx = 0;
        while (idx < subsystems.length && !cancelled) {
            ISubSystem ss = subsystems[idx];
            if (ss.isConnected()) {
                try {
                    ss.disconnect();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Cacnelled");
                    cancelled = true;
                }
                catch (Exception exception) {}
            }
            ++idx;
        }
    }

    public void connectedStatusChange(ISubSystem subsystem, boolean connected, boolean wasConnected) {
        this.connectedStatusChange(subsystem, connected, wasConnected, true);
    }

    public void connectedStatusChange(ISubSystem subsystem, boolean connected, boolean wasConnected, boolean collapseTree) {
        IHost conn = subsystem.getHost();
        if (connected != wasConnected) {
            int eventId = 81;
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conn, eventId, (Object)this));
            SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)subsystem, eventId, (Object)conn);
            this.fireEvent((ISystemResourceChangeEvent)event);
            ISubSystem[] sses = this.getSubSystems(conn);
            int i = 0;
            while (i < sses.length) {
                ISubSystem ss = sses[i];
                if (ss != subsystem) {
                    SystemResourceChangeEvent sevent = new SystemResourceChangeEvent((Object)ss, eventId, (Object)conn);
                    this.fireEvent((ISystemResourceChangeEvent)sevent);
                    sevent.setType(86);
                    this.fireEvent((ISystemResourceChangeEvent)sevent);
                }
                ++i;
            }
            event.setType(86);
            this.fireEvent((ISystemResourceChangeEvent)event);
        }
        if (!connected && wasConnected && collapseTree) {
            this.invalidateFiltersFor(subsystem);
            this.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)subsystem, 90, (Object)this));
            ISubSystem[] sses = this.getSubSystems(conn);
            int i = 0;
            while (i < sses.length) {
                ISubSystem ss = sses[i];
                if (ss != subsystem && !ss.isConnected()) {
                    this.invalidateFiltersFor(ss);
                    SystemResourceChangeEvent sevent = new SystemResourceChangeEvent((Object)ss, 90, (Object)conn);
                    this.fireEvent((ISystemResourceChangeEvent)sevent);
                }
                ++i;
            }
        }
    }

    public void addSystemResourceChangeListener(ISystemResourceChangeListener l) {
        this.listenerManager.addSystemResourceChangeListener(l);
        ++this.listenerCount;
    }

    public void removeSystemResourceChangeListener(ISystemResourceChangeListener l) {
        this.listenerManager.removeSystemResourceChangeListener(l);
        --this.listenerCount;
    }

    public boolean isRegisteredSystemResourceChangeListener(ISystemResourceChangeListener l) {
        return this.listenerManager.isRegisteredSystemResourceChangeListener(l);
    }

    public void fireEvent(ISystemResourceChangeEvent event) {
        Object src = event.getSource();
        if (src instanceof ISystemFilter) {
            IRSEBaseReferencingObject[] references = ((ISystemFilter)src).getReferencingObjects();
            int i = 0;
            while (i < references.length) {
                IRSEBaseReferencingObject ref = references[i];
                if (ref instanceof ISystemContainer) {
                    ((ISystemContainer)ref).markStale(true);
                }
                ++i;
            }
        }
        if (this.onMainThread()) {
            this.listenerManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyResourceChangedRunnable(event));
        }
    }

    public void fireEvent(ISystemResourceChangeListener l, ISystemResourceChangeEvent event) {
        if (this.onMainThread()) {
            l.systemResourceChanged(event);
        } else {
            this.runOnMainThread(new ResourceChangedRunnable(event, l));
        }
    }

    public SystemResourceChangeManager getResourceChangeManager() {
        return this.listenerManager;
    }

    public void addSystemModelChangeListener(ISystemModelChangeListener l) {
        this.modelListenerManager.addSystemModelChangeListener(l);
        ++this.modelListenerCount;
    }

    public void removeSystemModelChangeListener(ISystemModelChangeListener l) {
        this.modelListenerManager.removeSystemModelChangeListener(l);
        --this.modelListenerCount;
    }

    private boolean onMainThread() {
        return Display.getCurrent() != null;
    }

    private void runOnMainThread(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    public void fireEvent(ISystemModelChangeEvent event) {
        if (this.onMainThread()) {
            this.modelListenerManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyModelChangedRunnable(event));
        }
    }

    public void fireModelChangeEvent(int eventType, int resourceType, Object resource, String oldName) {
        if (this.modelEvent == null) {
            this.modelEvent = new SystemModelChangeEvent();
        }
        this.modelEvent.setEventType(eventType);
        this.modelEvent.setResourceType(resourceType);
        this.modelEvent.setResource(resource);
        this.modelEvent.setOldName(oldName);
        if (this.onMainThread()) {
            this.modelListenerManager.notify((ISystemModelChangeEvent)this.modelEvent);
        } else {
            this.runOnMainThread(new NotifyModelChangedRunnable((ISystemModelChangeEvent)this.modelEvent));
        }
    }

    public void fireEvent(ISystemModelChangeListener l, ISystemModelChangeEvent event) {
        if (this.onMainThread()) {
            l.systemModelResourceChanged(event);
        } else {
            this.runOnMainThread(new ModelResourceChangedRunnable(event, l));
        }
    }

    public void addSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        this.remoteListManager.addSystemRemoteChangeListener(l);
        ++this.remoteListCount;
    }

    public void removeSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        this.remoteListManager.removeSystemRemoteChangeListener(l);
        --this.remoteListCount;
    }

    public void fireEvent(ISystemRemoteChangeEvent event) {
        if (this.onMainThread()) {
            this.remoteListManager.notify(event);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(event));
        }
    }

    public void fireRemoteResourceChangeEvent(int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String oldName) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (this.remoteEvent == null) {
            this.remoteEvent = new SystemRemoteChangeEvent();
        }
        this.remoteEvent.setEventType(eventType);
        this.remoteEvent.setResource(resource);
        this.remoteEvent.setResourceParent(resourceParent);
        this.remoteEvent.setOldName(oldName);
        this.remoteEvent.setSubSystem(subsystem);
        if (this.onMainThread()) {
            this.remoteListManager.notify((ISystemRemoteChangeEvent)this.remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable((ISystemRemoteChangeEvent)this.remoteEvent));
        }
    }

    public void fireRemoteResourceChangeEvent(int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String oldName, Object originatingViewer) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (this.remoteEvent == null) {
            this.remoteEvent = new SystemRemoteChangeEvent();
        }
        this.remoteEvent.setEventType(eventType);
        this.remoteEvent.setResource(resource);
        this.remoteEvent.setResourceParent(resourceParent);
        this.remoteEvent.setOldName(oldName);
        this.remoteEvent.setSubSystem(subsystem);
        this.remoteEvent.setOriginatingViewer(originatingViewer);
        if (this.onMainThread()) {
            this.remoteListManager.notify((ISystemRemoteChangeEvent)this.remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable((ISystemRemoteChangeEvent)this.remoteEvent));
        }
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    private String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else if (remoteResource instanceof SystemFilterReference) {
            ISystemFilterReference ref = (ISystemFilterReference)remoteResource;
            ISubSystem ss = ref.getSubSystem();
            ISystemRemoteElementAdapter ra = this.getRemoteAdapter(remoteResource = ss.getTargetForFilter(ref));
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        } else {
            ISystemRemoteElementAdapter ra = this.getRemoteAdapter(remoteResource);
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    private List findFilterReferencesFor(ISubSystem subsystem) {
        ISystemFilterPoolReferenceManager refmgr;
        ArrayList<ISystemFilterReference> results = new ArrayList<ISystemFilterReference>();
        if (subsystem != null && (refmgr = subsystem.getFilterPoolReferenceManager()) != null) {
            ISystemFilterReference[] refs = refmgr.getSystemFilterReferences(subsystem);
            int i = 0;
            while (i < refs.length) {
                ISystemFilterReference filterRef = refs[i];
                if (!filterRef.isStale() && filterRef.hasContents((ISystemContentsType)SystemChildrenContentsType.getInstance())) {
                    results.add(filterRef);
                }
                ++i;
            }
        }
        return results;
    }

    public List findFilterReferencesFor(Object resource, ISubSystem subsystem) {
        return this.findFilterReferencesFor(resource, subsystem, true);
    }

    public List findFilterReferencesFor(Object resource, ISubSystem subsystem, boolean onlyCached) {
        String elementName = this.getRemoteResourceAbsoluteName(resource);
        ArrayList<ISystemFilterReference> results = new ArrayList<ISystemFilterReference>();
        if (subsystem != null && elementName != null && subsystem.getSubSystemConfiguration().supportsFilters()) {
            ISystemFilterReference[] refs = subsystem.getFilterPoolReferenceManager().getSystemFilterReferences(subsystem);
            int i = 0;
            while (i < refs.length) {
                ISystemFilterReference filterRef = refs[i];
                if (!onlyCached || !filterRef.isStale() && filterRef.hasContents((ISystemContentsType)SystemChildrenContentsType.getInstance())) {
                    if (subsystem.doesFilterMatch(filterRef.getReferencedFilter(), elementName)) {
                        results.add(filterRef);
                    } else if (subsystem.doesFilterListContentsOf(filterRef.getReferencedFilter(), elementName)) {
                        results.add(filterRef);
                    }
                }
                ++i;
            }
        }
        return results;
    }

    public void invalidateFiltersFor(ISubSystem subsystem) {
        if (subsystem != null) {
            List results = this.findFilterReferencesFor(subsystem);
            int i = 0;
            while (i < results.size()) {
                ((ISystemFilterReference)results.get(i)).markStale(true);
                ++i;
            }
        }
    }

    public void invalidateFiltersFor(Object resourceParent, ISubSystem subsystem) {
        if (subsystem != null) {
            List results = this.findFilterReferencesFor(resourceParent, subsystem);
            int i = 0;
            while (i < results.size()) {
                ((ISystemFilterReference)results.get(i)).markStale(true);
                ++i;
            }
        }
    }

    public void fireEvent(ISystemRemoteChangeListener l, ISystemRemoteChangeEvent event) {
        if (this.onMainThread()) {
            l.systemRemoteResourceChanged(event);
        } else {
            this.runOnMainThread(new RemoteResourceChangedRunnable(event, l));
        }
    }

    public void addSystemPreferenceChangeListener(ISystemPreferenceChangeListener l) {
        this.preferenceListManager.addSystemPreferenceChangeListener(l);
    }

    public void removeSystemPreferenceChangeListener(ISystemPreferenceChangeListener l) {
        this.preferenceListManager.removeSystemPreferenceChangeListener(l);
    }

    public void fireEvent(ISystemPreferenceChangeEvent event) {
        if (this.onMainThread()) {
            this.preferenceListManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyPreferenceChangedRunnable(event));
        }
    }

    public void fireEvent(ISystemPreferenceChangeListener l, ISystemPreferenceChangeEvent event) {
        if (this.onMainThread()) {
            l.systemPreferenceChanged(event);
        } else {
            this.runOnMainThread(new PreferenceChangedRunnable(event, l));
        }
    }

    public void loadAll() {
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        if (proxies != null) {
            int idx = 0;
            while (idx < proxies.length) {
                proxies[idx].getSubSystemConfiguration();
                ++idx;
            }
        }
        IHost[] connections = this.getHosts();
        int idx = 0;
        while (idx < connections.length) {
            this.getSubSystems(connections[idx]);
            ++idx;
        }
    }

    public Exception getLastException() {
        Exception last = lastException;
        lastException = null;
        return last;
    }

    public boolean save() {
        ISystemProfile[] notSaved = RSECorePlugin.getThePersistenceManager().commitProfiles(5000L);
        return notSaved.length > 0;
    }

    public boolean saveHostPool(ISystemHostPool pool) {
        return pool.commit();
    }

    public boolean saveHost(IHost conn) {
        return conn.commit();
    }

    public boolean restore() {
        boolean ok = true;
        lastException = null;
        return ok;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public ISystemFilterStartHere getSystemFilterStartHere() {
        return SystemFilterStartHere.getInstance();
    }

    public Object[] getSystemViewRoots() {
        IHost[] connections = this.getHosts();
        ArrayList<IHost> result = new ArrayList<IHost>();
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            IRSESystemType sysType = con.getSystemType();
            if (sysType != null) {
                RSESystemTypeAdapter adapter;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (RSESystemTypeAdapter)sysType.getAdapter((Class)clazz)).isEnabled(sysType)) {
                    result.add(con);
                }
            }
            ++i;
        }
        return result.toArray();
    }

    public boolean hasSystemViewRoots() {
        return this.getHostCount() > 0;
    }

    public boolean showingConnections() {
        return true;
    }

    public void setShell(Object shell) {
        this.shell = shell;
    }

    public Object getShell() {
        return this.shell;
    }

    public void setViewer(Object viewer) {
        this.viewer = viewer;
    }

    public Object getViewer() {
        return this.viewer;
    }

    class FireNewHostEvents
    implements Runnable {
        private ISubSystem[] subSystems;
        private IHost conn;
        private ISystemRegistry reg;

        public FireNewHostEvents(IHost host, ISubSystem[] subSystems, ISystemRegistry registry) {
            this.subSystems = subSystems;
            this.conn = host;
            this.reg = registry;
        }

        public void run() {
            int eventType = 53;
            SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)this.conn, eventType, (Object)this.reg);
            IHost previous = SystemRegistry.this.getPreviousHost(this.conn);
            if (previous != null) {
                event.setRelativePrevious((Object)previous);
            } else {
                event.setType(50);
            }
            SystemRegistry.this.fireEvent((ISystemResourceChangeEvent)event);
            SystemRegistry.this.fireModelChangeEvent(1, 2, this.conn, null);
            int s = 0;
            while (s < this.subSystems.length) {
                ISubSystem ss = this.subSystems[s];
                SystemRegistry.this.fireModelChangeEvent(1, 4, ss, null);
                ++s;
            }
        }
    }

    class ModelResourceChangedRunnable
    implements Runnable {
        private ISystemModelChangeListener _listener;
        private ISystemModelChangeEvent _event;

        public ModelResourceChangedRunnable(ISystemModelChangeEvent event, ISystemModelChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemModelResourceChanged(this._event);
        }
    }

    class NotifyModelChangedRunnable
    implements Runnable {
        private ISystemModelChangeEvent _event;

        public NotifyModelChangedRunnable(ISystemModelChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.modelListenerManager.notify(this._event);
        }
    }

    class NotifyPreferenceChangedRunnable
    implements Runnable {
        private ISystemPreferenceChangeEvent _event;

        public NotifyPreferenceChangedRunnable(ISystemPreferenceChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.preferenceListManager.notify(this._event);
        }
    }

    class NotifyResourceChangedRunnable
    implements Runnable {
        private ISystemResourceChangeEvent _event;

        public NotifyResourceChangedRunnable(ISystemResourceChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.listenerManager.notify(this._event);
        }
    }

    class PreferenceChangedRunnable
    implements Runnable {
        private ISystemPreferenceChangeEvent _event;
        private ISystemPreferenceChangeListener _listener;

        public PreferenceChangedRunnable(ISystemPreferenceChangeEvent event, ISystemPreferenceChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemPreferenceChanged(this._event);
        }
    }

    class RemoteChangedRunnable
    implements Runnable {
        private ISystemRemoteChangeEvent _event;

        public RemoteChangedRunnable(ISystemRemoteChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.remoteListManager.notify(this._event);
        }
    }

    class RemoteResourceChangedRunnable
    implements Runnable {
        private ISystemRemoteChangeListener _listener;
        private ISystemRemoteChangeEvent _event;

        public RemoteResourceChangedRunnable(ISystemRemoteChangeEvent event, ISystemRemoteChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemRemoteResourceChanged(this._event);
        }
    }

    class ResourceChangedRunnable
    implements Runnable {
        private ISystemResourceChangeListener _listener;
        private ISystemResourceChangeEvent _event;

        public ResourceChangedRunnable(ISystemResourceChangeEvent event, ISystemResourceChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemResourceChanged(this._event);
        }
    }
}

