/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.telnet.ITelnetSettings;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnectWorker;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnection;
import org.eclipse.tm.internal.terminal.telnet.TelnetSettings;
import org.eclipse.tm.internal.terminal.telnet.TelnetSettingsPage;

public class TelnetConnector
implements ITerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private Socket fSocket;
    private ITerminalControl fControl;
    private TelnetConnection fTelnetConnection;
    private final TelnetSettings fSettings;
    private int fWidth = -1;
    private int fHeight = -1;

    public TelnetConnector() {
        this(new TelnetSettings());
    }

    public TelnetConnector(TelnetSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
    }

    public void connect(ITerminalControl control) {
        Logger.log((String)"entered.");
        this.fControl = control;
        this.fWidth = -1;
        this.fHeight = -1;
        TelnetConnectWorker worker = new TelnetConnectWorker(this, control);
        worker.start();
    }

    public void disconnect() {
        Logger.log((String)"entered.");
        if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getOutputStream() != null) {
            try {
                this.getOutputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.cleanSocket();
        this.setState(TerminalState.CLOSED);
    }

    public boolean isLocalEcho() {
        if (this.fTelnetConnection != null) {
            return false;
        }
        return this.fTelnetConnection.localEcho();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fTelnetConnection != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fTelnetConnection.setTerminalSize(newWidth, newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    Socket getSocket() {
        return this.fSocket;
    }

    void cleanSocket() {
        this.fSocket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    void setSocket(Socket socket) throws IOException {
        if (socket == null) {
            this.cleanSocket();
        } else {
            this.fSocket = socket;
            this.setInputStream(socket.getInputStream());
            this.setOutputStream(socket.getOutputStream());
        }
    }

    public void setTelnetConnection(TelnetConnection connection) {
        this.fTelnetConnection = connection;
    }

    public void displayTextInTerminal(String text) {
        this.fControl.displayTextInTerminal(text);
    }

    public OutputStream getRemoteToTerminalOutputStream() {
        return this.fControl.getRemoteToTerminalOutputStream();
    }

    public void setState(TerminalState state) {
        this.fControl.setState(state);
    }

    public ITelnetSettings getTelnetSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new TelnetSettingsPage(this.fSettings);
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

