/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.view;

import java.util.HashSet;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.actions.TerminalAction;
import org.eclipse.tm.internal.terminal.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.actions.TerminalActionConnect;
import org.eclipse.tm.internal.terminal.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.actions.TerminalActionCut;
import org.eclipse.tm.internal.terminal.actions.TerminalActionDisconnect;
import org.eclipse.tm.internal.terminal.actions.TerminalActionNewTerminal;
import org.eclipse.tm.internal.terminal.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.actions.TerminalActionSelectAll;
import org.eclipse.tm.internal.terminal.actions.TerminalActionSettings;
import org.eclipse.tm.internal.terminal.actions.TerminalActionToggleCommandInputField;
import org.eclipse.tm.internal.terminal.control.CommandInputFieldWithHistory;
import org.eclipse.tm.internal.terminal.control.ICommandInputField;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnectorInfo;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.view.ITerminalView;
import org.eclipse.tm.internal.terminal.view.SettingStorePrefixDecorator;
import org.eclipse.tm.internal.terminal.view.SettingsStore;
import org.eclipse.tm.internal.terminal.view.TerminalSettingsDlg;
import org.eclipse.tm.internal.terminal.view.TerminalViewPlugin;
import org.eclipse.tm.internal.terminal.view.ViewMessages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ITerminalView,
ITerminalListener {
    private static final String STORE_CONNECTION_TYPE = "ConnectionType";
    private static final String STORE_SETTING_SUMMARY = "SettingSummary";
    private static final String STORE_HAS_COMMAND_INPUT_FIELD = "HasCommandInputField";
    private static final String STORE_COMMAND_INPUT_FIELD_HISTORY = "CommandInputFieldHistory";
    private static final String STORE_TITLE = "Title";
    public static final String FONT_DEFINITION = "terminal.views.view.font.definition";
    protected ITerminalViewControl fCtlTerminal;
    protected TerminalAction fActionTerminalNewTerminal;
    protected TerminalAction fActionTerminalConnect;
    protected TerminalAction fActionTerminalDisconnect;
    protected TerminalAction fActionTerminalSettings;
    protected TerminalAction fActionEditCopy;
    protected TerminalAction fActionEditCut;
    protected TerminalAction fActionEditPaste;
    protected TerminalAction fActionEditClearAll;
    protected TerminalAction fActionEditSelectAll;
    protected TerminalAction fActionToggleCommandInputField;
    protected TerminalPropertyChangeHandler fPropertyChangeHandler;
    protected boolean fMenuAboutToShow;
    private SettingsStore fStore;
    private CommandInputFieldWithHistory fCommandInputField;
    private final IPropertyChangeListener fPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("TerminalPrefLimitOutput") || event.getProperty().equals("TerminalPrefBufferLines")) {
                TerminalView.this.updatePreferences();
            }
        }
    };

    public TerminalView() {
        Logger.log((String)"===============================================================");
    }

    String findUniqueTitle(String title) {
        IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
        String id = this.getViewSite().getId();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < pages.length) {
            IViewReference[] views = pages[i].getViewReferences();
            int j = 0;
            while (j < views.length) {
                String name;
                IViewReference view = views[j];
                if (id.equals(view.getId()) && (name = view.getTitle()) != null) {
                    names.add(view.getPartName());
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        String uniqueTitle = title;
        while (names.contains(uniqueTitle)) {
            uniqueTitle = String.valueOf(title) + " " + i++;
        }
        return uniqueTitle;
    }

    private void updatePreferences() {
        Preferences preferences = TerminalViewPlugin.getDefault().getPluginPreferences();
        boolean limitOutput = preferences.getBoolean("TerminalPrefLimitOutput");
        int bufferLineLimit = preferences.getInt("TerminalPrefBufferLines");
        if (!limitOutput) {
            bufferLineLimit = -1;
        }
        this.fCtlTerminal.setBufferLineLimit(bufferLineLimit);
    }

    public void setState(TerminalState state) {
        Runnable runnable = new Runnable(){

            public void run() {
                TerminalView.this.updateStatus();
                TerminalView.this.onTerminalStatus();
            }
        };
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    public void onTerminalNewTerminal() {
        Logger.log((String)"creating new Terminal instance.");
        try {
            this.getSite().getPage().showView("org.eclipse.tm.terminal.view.TerminalView", "SecondaryTerminal" + System.currentTimeMillis(), 1);
        }
        catch (PartInitException ex) {
            Logger.logException((Exception)((Object)ex));
        }
    }

    public void onTerminalConnect() {
        if (this.fCtlTerminal.getState() != TerminalState.CLOSED) {
            return;
        }
        if (this.fCtlTerminal.getTerminalConnectorInfo() == null) {
            this.setConnector(this.showSettingsDialog());
        }
        this.fCtlTerminal.connectTerminal();
    }

    public void updateStatus() {
        this.updateTerminalConnect();
        this.updateTerminalDisconnect();
        this.updateTerminalSettings();
    }

    public void updateTerminalConnect() {
        boolean bEnabled = this.fCtlTerminal.getState() == TerminalState.CLOSED;
        this.fActionTerminalConnect.setEnabled(bEnabled);
    }

    private boolean isConnecting() {
        return this.fCtlTerminal.getState() == TerminalState.CONNECTING || this.fCtlTerminal.getState() == TerminalState.OPENED;
    }

    private boolean isConnected() {
        return this.fCtlTerminal.getState() == TerminalState.CONNECTED;
    }

    public void onTerminalDisconnect() {
        this.fCtlTerminal.disconnectTerminal();
    }

    public void updateTerminalDisconnect() {
        boolean bEnabled = this.isConnecting() || this.fCtlTerminal.isConnected();
        this.fActionTerminalDisconnect.setEnabled(bEnabled);
    }

    public void onTerminalSettings() {
        ITerminalConnectorInfo c = this.showSettingsDialog();
        if (c != null) {
            this.setConnector(c);
            this.onTerminalConnect();
        }
    }

    private ITerminalConnectorInfo showSettingsDialog() {
        TerminalSettingsDlg dlgTerminalSettings = new TerminalSettingsDlg(this.getViewSite().getShell(), this.fCtlTerminal.getConnectors(), this.fCtlTerminal.getTerminalConnectorInfo());
        dlgTerminalSettings.setTerminalTitle(this.getPartName());
        Logger.log((String)"opening Settings dialog.");
        if (dlgTerminalSettings.open() == 1) {
            Logger.log((String)"Settings dialog cancelled.");
            return null;
        }
        Logger.log((String)"Settings dialog OK'ed.");
        this.saveSettings(dlgTerminalSettings.getConnector());
        this.setPartName(dlgTerminalSettings.getTerminalTitle());
        return dlgTerminalSettings.getConnector();
    }

    private void setConnector(ITerminalConnectorInfo connector) {
        this.fCtlTerminal.setConnector(connector);
    }

    public void updateTerminalSettings() {
        boolean bEnabled = this.fCtlTerminal.getState() == TerminalState.CLOSED;
        this.fActionTerminalSettings.setEnabled(bEnabled);
    }

    public void setTerminalTitle(String strTitle) {
        if (this.fCtlTerminal.isDisposed()) {
            return;
        }
        if (strTitle == null) {
            if (this.fCtlTerminal.getTerminalConnectorInfo() == null) {
                strTitle = ViewMessages.NO_CONNECTION_SELECTED;
            } else {
                String name;
                String strConnected = this.getStateDisplayName(this.fCtlTerminal.getState());
                String summary = this.getSettingsSummary();
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + " - ";
                }
                if ((name = this.fCtlTerminal.getTerminalConnectorInfo().getName()).length() > 0) {
                    name = String.valueOf(name) + ": ";
                }
                strTitle = String.valueOf(name) + "(" + summary + strConnected + ")";
            }
        }
        this.setContentDescription(strTitle);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(strTitle);
        this.setTitleToolTip(String.valueOf(this.getPartName()) + ": " + strTitle);
    }

    private String getSettingsSummary() {
        String summary = "?";
        if (this.fCtlTerminal.getTerminalConnectorInfo() != null) {
            summary = this.fCtlTerminal.getSettingsSummary();
        }
        if ("?".equals(summary)) {
            summary = this.fStore.get(STORE_SETTING_SUMMARY, "");
        }
        return summary;
    }

    public void onTerminalStatus() {
        this.setTerminalTitle(null);
    }

    private String getStateDisplayName(TerminalState state) {
        if (state == TerminalState.CONNECTED) {
            return ViewMessages.STATE_CONNECTED;
        }
        if (state == TerminalState.CONNECTING) {
            return ViewMessages.STATE_CONNECTING;
        }
        if (state == TerminalState.OPENED) {
            return ViewMessages.STATE_OPENED;
        }
        if (state == TerminalState.CLOSED) {
            return ViewMessages.STATE_CLOSED;
        }
        throw new IllegalStateException(state.toString());
    }

    public void onTerminalFontChanged() {
        this.fCtlTerminal.setFont(JFaceResources.getFont((String)FONT_DEFINITION));
    }

    public void onEditCopy() {
        String selection = this.fCtlTerminal.getSelection();
        if (!selection.equals("")) {
            this.fCtlTerminal.copy();
        } else {
            this.fCtlTerminal.sendKey('\u0003');
        }
    }

    public void updateEditCopy() {
        boolean bEnabled = true;
        if (this.fMenuAboutToShow) {
            bEnabled = this.fCtlTerminal.getSelection().length() > 0;
        }
        this.fActionEditCopy.setEnabled(bEnabled);
    }

    public void onEditCut() {
        this.fCtlTerminal.sendKey('\u0018');
    }

    public void updateEditCut() {
        boolean bEnabled = !this.fMenuAboutToShow;
        this.fActionEditCut.setEnabled(bEnabled);
    }

    public void onEditPaste() {
        this.fCtlTerminal.paste();
    }

    public void updateEditPaste() {
        String strText = (String)this.fCtlTerminal.getClipboard().getContents((Transfer)TextTransfer.getInstance());
        boolean bEnabled = strText != null && !strText.equals("") && this.isConnected();
        this.fActionEditPaste.setEnabled(bEnabled);
    }

    public void onEditClearAll() {
        this.fCtlTerminal.clearTerminal();
    }

    public void updateEditClearAll() {
        this.fActionEditClearAll.setEnabled(!this.fCtlTerminal.isEmpty());
    }

    public void onEditSelectAll() {
        this.fCtlTerminal.selectAll();
    }

    public void updateEditSelectAll() {
        this.fActionEditSelectAll.setEnabled(!this.fCtlTerminal.isEmpty());
    }

    public void createPartControl(Composite wndParent) {
        this.setPartName(this.findUniqueTitle(ViewMessages.PROP_TITLE));
        this.setupControls(wndParent);
        this.setupActions();
        this.setupLocalToolBars();
        this.setupContextMenus();
        this.setupListeners(wndParent);
        this.onTerminalStatus();
        this.onTerminalFontChanged();
    }

    public void dispose() {
        Logger.log((String)"entered.");
        TerminalViewPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPreferenceListener);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fPropertyChangeHandler);
        this.fCtlTerminal.disposeTerminal();
        super.dispose();
    }

    public void setFocus() {
        this.fCtlTerminal.setFocus();
    }

    protected void setupControls(Composite wndParent) {
        ITerminalConnectorInfo[] connectors = TerminalConnectorExtension.getTerminalConnectors();
        this.fCtlTerminal = TerminalViewControlFactory.makeControl((ITerminalListener)this, (Composite)wndParent, (ITerminalConnectorInfo[])connectors);
        String connectionType = this.fStore.get(STORE_CONNECTION_TYPE);
        int i = 0;
        while (i < connectors.length) {
            connectors[i].getConnector().load(this.getStore(connectors[i]));
            if (connectors[i].getId().equals(connectionType)) {
                this.fCtlTerminal.setConnector(connectors[i]);
            }
            ++i;
        }
        this.setCommandInputField("true".equals(this.fStore.get(STORE_HAS_COMMAND_INPUT_FIELD)));
        this.updatePreferences();
        TerminalViewPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPreferenceListener);
        String title = this.fStore.get(STORE_TITLE);
        if (title != null && title.length() > 0) {
            this.setPartName(title);
        }
    }

    private void saveSettings(ITerminalConnectorInfo connector) {
        ITerminalConnectorInfo[] connectors = this.fCtlTerminal.getConnectors();
        int i = 0;
        while (i < connectors.length) {
            connectors[i].getConnector().save(this.getStore(connectors[i]));
            ++i;
        }
        if (connector != null) {
            this.fStore.put(STORE_CONNECTION_TYPE, connector.getId());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fStore = new SettingsStore(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fCommandInputField != null) {
            this.fStore.put(STORE_COMMAND_INPUT_FIELD_HISTORY, this.fCommandInputField.getHistory());
        }
        this.fStore.put(STORE_HAS_COMMAND_INPUT_FIELD, this.hasCommandInputField() ? "true" : "false");
        this.fStore.put(STORE_SETTING_SUMMARY, this.getSettingsSummary());
        this.fStore.put(STORE_TITLE, this.getPartName());
        this.fStore.saveState(memento);
    }

    private ISettingsStore getStore(ITerminalConnectorInfo connector) {
        return new SettingStorePrefixDecorator(this.fStore, String.valueOf(connector.getId()) + ".");
    }

    protected void setupActions() {
        this.fActionTerminalNewTerminal = new TerminalActionNewTerminal(this);
        this.fActionTerminalConnect = new TerminalActionConnect(this);
        this.fActionTerminalDisconnect = new TerminalActionDisconnect(this);
        this.fActionTerminalSettings = new TerminalActionSettings(this);
        this.fActionEditCopy = new TerminalActionCopy(this);
        this.fActionEditCut = new TerminalActionCut(this);
        this.fActionEditPaste = new TerminalActionPaste(this);
        this.fActionEditClearAll = new TerminalActionClearAll(this);
        this.fActionEditSelectAll = new TerminalActionSelectAll(this);
        this.fActionToggleCommandInputField = new TerminalActionToggleCommandInputField(this);
    }

    protected void setupLocalToolBars() {
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.add((IAction)this.fActionTerminalNewTerminal);
        toolBarMgr.add((IAction)this.fActionTerminalConnect);
        toolBarMgr.add((IAction)this.fActionTerminalDisconnect);
        toolBarMgr.add((IAction)this.fActionTerminalSettings);
        toolBarMgr.add((IAction)this.fActionToggleCommandInputField);
    }

    protected void setupContextMenus() {
        Control ctlText = this.fCtlTerminal.getControl();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(ctlText);
        this.loadContextMenus((IMenuManager)menuMgr);
        TerminalContextMenuHandler contextMenuHandler = new TerminalContextMenuHandler();
        ctlText.setMenu(menu);
        menuMgr.addMenuListener((IMenuListener)contextMenuHandler);
        menu.addMenuListener((MenuListener)contextMenuHandler);
    }

    protected void loadContextMenus(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.fActionEditCopy);
        menuMgr.add((IAction)this.fActionEditPaste);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionEditClearAll);
        menuMgr.add((IAction)this.fActionEditSelectAll);
        menuMgr.add((IAction)this.fActionToggleCommandInputField);
        menuMgr.add((IContributionItem)new Separator("Additions"));
    }

    protected void setupListeners(Composite wndParent) {
        this.fPropertyChangeHandler = new TerminalPropertyChangeHandler();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fPropertyChangeHandler);
    }

    public boolean hasCommandInputField() {
        return this.fCommandInputField != null;
    }

    public void setCommandInputField(boolean on) {
        if (this.fCommandInputField != null) {
            this.fStore.put(STORE_COMMAND_INPUT_FIELD_HISTORY, this.fCommandInputField.getHistory());
            this.fCommandInputField = null;
        }
        if (on) {
            this.fCommandInputField = new CommandInputFieldWithHistory(100);
            this.fCommandInputField.setHistory(this.fStore.get(STORE_COMMAND_INPUT_FIELD_HISTORY));
        }
        this.fCtlTerminal.setCommandInputField((ICommandInputField)this.fCommandInputField);
    }

    protected class TerminalContextMenuHandler
    implements MenuListener,
    IMenuListener {
        protected TerminalContextMenuHandler() {
        }

        public void menuHidden(MenuEvent event) {
            TerminalView.this.fMenuAboutToShow = false;
            TerminalView.this.updateEditCopy();
        }

        public void menuShown(MenuEvent e) {
        }

        public void menuAboutToShow(IMenuManager menuMgr) {
            TerminalView.this.fMenuAboutToShow = true;
            TerminalView.this.updateEditCopy();
            TerminalView.this.updateEditCut();
            TerminalView.this.updateEditSelectAll();
            TerminalView.this.updateEditPaste();
            TerminalView.this.updateEditClearAll();
        }
    }

    protected class TerminalPropertyChangeHandler
    implements IPropertyChangeListener {
        protected TerminalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(TerminalView.FONT_DEFINITION)) {
                TerminalView.this.onTerminalFontChanged();
            }
        }
    }
}

