/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.control.ICommandInputField;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;

public class CommandInputFieldWithHistory
implements ICommandInputField {
    final List fHistory = new ArrayList();
    List fEditedHistory;
    private int fEditHistoryPos = 0;
    private final int fMaxSize;
    private Text fInputField;

    public CommandInputFieldWithHistory(int maxHistorySize) {
        this.fMaxSize = maxHistorySize;
    }

    protected void pushLine(String line) {
        this.endHistoryMode();
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.fHistory.add(0, line);
        if (this.fHistory.size() > 1 && line.equals(this.fHistory.get(1))) {
            this.fHistory.remove(0);
        }
        if (this.fHistory.size() >= this.fMaxSize) {
            this.fHistory.remove(this.fHistory.size() - 1);
        }
    }

    public void setHistory(String history) {
        this.endHistoryMode();
        this.fHistory.clear();
        if (history == null) {
            return;
        }
        this.fHistory.addAll(Arrays.asList(history.split("\n")));
    }

    public String getHistory() {
        StringBuffer buff = new StringBuffer();
        boolean sep = false;
        Iterator iterator = this.fHistory.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line.length() <= 0) continue;
            if (sep) {
                buff.append("\n");
            } else {
                sep = true;
            }
            buff.append(line);
        }
        return buff.toString();
    }

    public String move(String currLine, int count) {
        if (!this.inHistoryMode()) {
            this.fEditedHistory = new ArrayList(this.fHistory.size() + 1);
            this.fEditedHistory.add(currLine);
            this.fEditedHistory.addAll(this.fHistory);
            this.fEditHistoryPos = 0;
        }
        this.fEditedHistory.set(this.fEditHistoryPos, currLine);
        if (this.fEditHistoryPos + count >= this.fEditedHistory.size()) {
            return null;
        }
        if (this.fEditHistoryPos + count < 0) {
            return null;
        }
        this.fEditHistoryPos += count;
        return (String)this.fEditedHistory.get(this.fEditHistoryPos);
    }

    private boolean inHistoryMode() {
        return this.fEditedHistory != null;
    }

    protected String escape() {
        if (!this.inHistoryMode()) {
            return null;
        }
        String line = (String)this.fEditedHistory.get(0);
        this.endHistoryMode();
        return line;
    }

    private void endHistoryMode() {
        this.fEditedHistory = null;
        this.fEditHistoryPos = 0;
    }

    public void createControl(Composite parent, final ITerminalViewControl terminal) {
        this.fInputField = new Text(parent, 2052);
        this.fInputField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fInputField.setFont(terminal.getFont());
        this.fInputField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 10 || e.keyCode == 13) {
                    e.doit = false;
                    String line = CommandInputFieldWithHistory.this.fInputField.getText();
                    if (!terminal.pasteString(String.valueOf(line) + "\n")) {
                        return;
                    }
                    CommandInputFieldWithHistory.this.pushLine(line);
                    this.setCommand("");
                } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.move(CommandInputFieldWithHistory.this.fInputField.getText(), 1));
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.move(CommandInputFieldWithHistory.this.fInputField.getText(), -1));
                } else if (e.keyCode == 27) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.escape());
                }
            }

            private void setCommand(String line) {
                if (line == null) {
                    return;
                }
                CommandInputFieldWithHistory.this.fInputField.setText(line);
                CommandInputFieldWithHistory.this.fInputField.setSelection(CommandInputFieldWithHistory.this.fInputField.getCharCount());
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setFont(Font font) {
        this.fInputField.setFont(font);
        this.fInputField.getParent().layout(true);
    }

    public void dispose() {
        this.fInputField.dispose();
        this.fInputField = null;
    }
}

