/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class StyleMap {
    String fFontName = "org.eclipse.jface.textfont";
    Map fColorMap = new HashMap();
    Map fFontMap = new HashMap();
    private Point fCharSize;
    private Style fDefaultStyle;

    StyleMap() {
        Display display = Display.getCurrent();
        this.fColorMap.put(StyleColor.getStyleColor("white"), new Color((Device)display, 255, 255, 255));
        this.fColorMap.put(StyleColor.getStyleColor("black"), new Color((Device)display, 0, 0, 0));
        this.fColorMap.put(StyleColor.getStyleColor("red"), new Color((Device)display, 255, 128, 128));
        this.fColorMap.put(StyleColor.getStyleColor("green"), new Color((Device)display, 128, 255, 128));
        this.fColorMap.put(StyleColor.getStyleColor("blue"), new Color((Device)display, 128, 128, 255));
        this.fColorMap.put(StyleColor.getStyleColor("yellow"), new Color((Device)display, 255, 255, 0));
        this.fColorMap.put(StyleColor.getStyleColor("cyan"), new Color((Device)display, 0, 255, 255));
        this.fColorMap.put(StyleColor.getStyleColor("magenta"), new Color((Device)display, 255, 255, 0));
        this.fColorMap.put(StyleColor.getStyleColor("gray"), new Color((Device)display, 128, 128, 128));
        this.fColorMap.put(StyleColor.getStyleColor("WHITE"), new Color((Device)display, 255, 255, 255));
        this.fColorMap.put(StyleColor.getStyleColor("BLACK"), new Color((Device)display, 0, 0, 0));
        this.fColorMap.put(StyleColor.getStyleColor("RED"), new Color((Device)display, 255, 128, 128));
        this.fColorMap.put(StyleColor.getStyleColor("GREEN"), new Color((Device)display, 128, 255, 128));
        this.fColorMap.put(StyleColor.getStyleColor("BLUE"), new Color((Device)display, 128, 128, 255));
        this.fColorMap.put(StyleColor.getStyleColor("YELLOW"), new Color((Device)display, 255, 255, 0));
        this.fColorMap.put(StyleColor.getStyleColor("CYAN"), new Color((Device)display, 0, 255, 255));
        this.fColorMap.put(StyleColor.getStyleColor("MAGENTA"), new Color((Device)display, 255, 255, 0));
        this.fColorMap.put(StyleColor.getStyleColor("GRAY"), new Color((Device)display, 128, 128, 128));
        this.fDefaultStyle = Style.getStyle(StyleColor.getStyleColor("black"), StyleColor.getStyleColor("white"));
        GC gc = new GC((Drawable)display);
        gc.setFont(this.getFont());
        this.fCharSize = gc.textExtent("W");
        gc.dispose();
    }

    public Color getColor(StyleColor colorName) {
        return (Color)this.fColorMap.get(colorName);
    }

    public Color getForegrondColor(Style style) {
        if ((style = this.defaultIfNull(style)).isReverse()) {
            return this.getColor(style.getBackground());
        }
        return this.getColor(style.getForground());
    }

    private Style defaultIfNull(Style style) {
        if (style == null) {
            style = this.fDefaultStyle;
        }
        return style;
    }

    public Color getBackgroundColor(Style style) {
        if ((style = this.defaultIfNull(style)).isReverse()) {
            return this.getColor(style.getForground());
        }
        return this.getColor(style.getBackground());
    }

    public Font getFont(Style style) {
        if ((style = this.defaultIfNull(style)).isBold()) {
            return JFaceResources.getFontRegistry().getBold(this.fFontName);
        }
        if (style.isUnderline()) {
            return JFaceResources.getFontRegistry().getItalic(this.fFontName);
        }
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public Font getFont() {
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public int getFontWidth() {
        return this.fCharSize.x;
    }

    public int getFontHeight() {
        return this.fCharSize.y;
    }
}

