/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.references.SystemReferencedObjectHelper;

public class SystemFilterString
extends RSEModelObject
implements ISystemFilterString,
IAdaptable {
    private ISystemFilter parentFilter;
    protected SystemReferencedObjectHelper helper = null;
    protected static final String STRING_EDEFAULT = null;
    protected String string = STRING_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected static final boolean DEFAULT_EDEFAULT = false;
    protected boolean default_ = false;

    protected SystemFilterString() {
        this.helper = new SystemReferencedObjectHelper(this);
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void setParentSystemFilter(ISystemFilter filter) {
        this.parentFilter = filter;
    }

    public ISystemFilter getParentSystemFilter() {
        return this.parentFilter;
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        if (this.parentFilter != null) {
            return this.parentFilter.getProvider();
        }
        return null;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        if (this.parentFilter != null) {
            return this.parentFilter.getSystemFilterPoolManager();
        }
        return null;
    }

    public String getType() {
        String type = this.getTypeGen();
        if (type == null) {
            return "default";
        }
        return type;
    }

    public void clone(ISystemFilterString targetString) {
        String ourString = this.getString();
        if (ourString != null) {
            targetString.setString(new String(ourString));
        }
        targetString.setType(this.getTypeGen());
        targetString.setDefault(this.isDefault());
    }

    public boolean isChangable() {
        boolean enable = !this.getParentSystemFilter().isNonChangable() && !this.getParentSystemFilter().isStringsNonChangable();
        return enable;
    }

    public int addReference(IRSEBaseReferencingObject ref) {
        return this.helper.addReference(ref);
    }

    public int removeReference(IRSEBaseReferencingObject ref) {
        return this.helper.removeReference(ref);
    }

    public int getReferenceCount() {
        return this.helper.getReferenceCount();
    }

    public void removeAllReferences() {
        this.helper.removeAllReferences();
    }

    public IRSEBaseReferencingObject[] getReferencingObjects() {
        return this.helper.getReferencingObjects();
    }

    public String getName() {
        return this.getString();
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_FILTERSTRING_DESCRIPTION;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String newString) {
        this.string = newString;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean newDefault) {
        this.default_ = newDefault;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (string: ");
        result.append(this.string);
        result.append(", type: ");
        result.append(this.type);
        result.append(", default: ");
        result.append(this.default_);
        result.append(')');
        return result.toString();
    }

    public String getTypeGen() {
        return this.type;
    }

    public boolean commit() {
        boolean result = this.getParentSystemFilter().commit();
        return result;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return this.parentFilter;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }
}

